<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Agent extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'office_id',
        'agent_code',
        'phone',
        'address',
        'vehicle_type',
        'license_number',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * Get the user that owns the agent.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the office that owns the agent.
     */
    public function office()
    {
        return $this->belongsTo(Office::class);
    }

    /**
     * Get the orders assigned to this agent.
     */
    public function orders()
    {
        return $this->hasMany(Order::class, 'assigned_agent_id');
    }

    /**
     * Get the orders assigned to this agent (alias for orders).
     */
    public function assignedOrders()
    {
        return $this->hasMany(Order::class, 'assigned_agent_id');
    }

    /**
     * Generate unique agent code
     */
    public static function generateAgentCode()
    {
        do {
            $code = 'AG' . str_pad(mt_rand(1, 9999), 4, '0', STR_PAD_LEFT);
        } while (self::where('agent_code', $code)->exists());
        
        return $code;
    }
}
