<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class District extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'province',
        'latitude',
        'longitude',
    ];

    protected $casts = [
        'latitude' => 'decimal:8',
        'longitude' => 'decimal:8',
    ];

    /**
     * Get the offices in this district.
     */
    public function offices()
    {
        return $this->hasMany(Office::class);
    }

    /**
     * Get orders with this district as pickup location.
     */
    public function pickupOrders()
    {
        return $this->hasMany(Order::class, 'pickup_district_id');
    }

    /**
     * Get orders with this district as drop location.
     */
    public function dropOrders()
    {
        return $this->hasMany(Order::class, 'drop_district_id');
    }
}
