<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Office extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'address',
        'phone',
        'email',
        'manager_name',
        'district_id',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * Get the district that owns the office.
     */
    public function district()
    {
        return $this->belongsTo(District::class);
    }

    /**
     * Get the agents for the office.
     */
    public function agents()
    {
        return $this->hasMany(Agent::class);
    }

    /**
     * Get the orders assigned to this office.
     */
    public function orders()
    {
        return $this->hasMany(Order::class, 'assigned_office_id');
    }
}
