<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->string('tracking_code')->unique();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('pickup_district_id')->constrained('districts');
            $table->foreignId('drop_district_id')->constrained('districts');
            $table->foreignId('assigned_office_id')->nullable()->constrained('offices');
            $table->foreignId('assigned_agent_id')->nullable()->constrained('agents');
            
            // Sender Information
            $table->string('sender_name');
            $table->string('sender_phone');
            $table->text('sender_address');
            
            // Receiver Information
            $table->string('receiver_name');
            $table->string('receiver_phone');
            $table->text('receiver_address');
            
            // Parcel Details
            $table->decimal('weight', 8, 2);
            $table->string('size'); // Small, Medium, Large
            $table->string('category');
            $table->text('description')->nullable();
            
            // Delivery Options
            $table->enum('delivery_type', ['standard', 'express', 'same_day']);
            $table->enum('vehicle_type', ['bike', 'car', 'van', 'truck']);
            
            // Pricing
            $table->decimal('estimated_price', 10, 2);
            $table->decimal('final_price', 10, 2)->nullable();
            
            // Payment
            $table->enum('payment_method', ['cod', 'jazzcash', 'easypaisa']);
            $table->enum('payment_status', ['pending', 'paid', 'failed'])->default('pending');
            $table->string('payment_reference')->nullable();
            
            // Order Status
            $table->enum('status', ['created', 'picked', 'in_transit', 'delivered', 'cancelled'])->default('created');
            $table->timestamp('picked_at')->nullable();
            $table->timestamp('delivered_at')->nullable();
            
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
