<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDistrictPricingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('district_pricings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('pickup_district_id')->constrained('districts')->onDelete('cascade');
            $table->foreignId('drop_district_id')->constrained('districts')->onDelete('cascade');
            $table->string('service_type')->default('standard'); // standard, express, overnight
            $table->decimal('base_rate', 8, 2)->nullable(); // Base delivery rate
            $table->decimal('per_kg_rate', 8, 2)->default(0); // Rate per kilogram
            $table->decimal('minimum_charge', 8, 2)->nullable(); // Minimum charge
            $table->decimal('maximum_charge', 8, 2)->nullable(); // Maximum charge (optional)
            $table->integer('estimated_days')->default(1); // Estimated delivery days
            $table->boolean('is_active')->default(true);
            $table->text('notes')->nullable();
            $table->timestamps();
            
            // Ensure unique combination of pickup, drop district and service type
            $table->unique(['pickup_district_id', 'drop_district_id', 'service_type'], 'unique_district_service');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('district_pricings');
    }
}
