<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\District;

class DistrictSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $districts = [
            // Punjab
            ['name' => 'Lahore', 'province' => 'Punjab', 'latitude' => 31.5204, 'longitude' => 74.3587],
            ['name' => 'Karachi', 'province' => 'Sindh', 'latitude' => 24.8607, 'longitude' => 67.0011],
            ['name' => 'Islamabad', 'province' => 'Federal Capital', 'latitude' => 33.6844, 'longitude' => 73.0479],
            ['name' => 'Rawalpindi', 'province' => 'Punjab', 'latitude' => 33.5651, 'longitude' => 73.0169],
            ['name' => 'Faisalabad', 'province' => 'Punjab', 'latitude' => 31.4504, 'longitude' => 73.1350],
            ['name' => 'Multan', 'province' => 'Punjab', 'latitude' => 30.1575, 'longitude' => 71.5249],
            ['name' => 'Gujranwala', 'province' => 'Punjab', 'latitude' => 32.1877, 'longitude' => 74.1945],
            ['name' => 'Sialkot', 'province' => 'Punjab', 'latitude' => 32.4945, 'longitude' => 74.5229],
            ['name' => 'Bahawalpur', 'province' => 'Punjab', 'latitude' => 29.4000, 'longitude' => 71.6833],
            ['name' => 'Sargodha', 'province' => 'Punjab', 'latitude' => 32.0836, 'longitude' => 72.6711],
            
            // Sindh
            ['name' => 'Hyderabad', 'province' => 'Sindh', 'latitude' => 25.3960, 'longitude' => 68.3578],
            ['name' => 'Sukkur', 'province' => 'Sindh', 'latitude' => 27.7052, 'longitude' => 68.8574],
            ['name' => 'Larkana', 'province' => 'Sindh', 'latitude' => 27.5590, 'longitude' => 68.2123],
            ['name' => 'Mirpur Khas', 'province' => 'Sindh', 'latitude' => 25.5267, 'longitude' => 69.0142],
            ['name' => 'Nawabshah', 'province' => 'Sindh', 'latitude' => 26.2442, 'longitude' => 68.4100],
            
            // Khyber Pakhtunkhwa
            ['name' => 'Peshawar', 'province' => 'Khyber Pakhtunkhwa', 'latitude' => 34.0151, 'longitude' => 71.5249],
            ['name' => 'Mardan', 'province' => 'Khyber Pakhtunkhwa', 'latitude' => 34.1987, 'longitude' => 72.0407],
            ['name' => 'Abbottabad', 'province' => 'Khyber Pakhtunkhwa', 'latitude' => 34.1463, 'longitude' => 73.2021],
            ['name' => 'Swat', 'province' => 'Khyber Pakhtunkhwa', 'latitude' => 35.2227, 'longitude' => 72.4258],
            ['name' => 'Kohat', 'province' => 'Khyber Pakhtunkhwa', 'latitude' => 33.5919, 'longitude' => 71.4469],
            
            // Balochistan
            ['name' => 'Quetta', 'province' => 'Balochistan', 'latitude' => 30.1798, 'longitude' => 66.9750],
            ['name' => 'Turbat', 'province' => 'Balochistan', 'latitude' => 26.0042, 'longitude' => 63.0480],
            ['name' => 'Gwadar', 'province' => 'Balochistan', 'latitude' => 25.1216, 'longitude' => 62.3254],
            ['name' => 'Khuzdar', 'province' => 'Balochistan', 'latitude' => 27.8094, 'longitude' => 66.6114],
            
            // Gilgit-Baltistan
            ['name' => 'Gilgit', 'province' => 'Gilgit-Baltistan', 'latitude' => 35.9197, 'longitude' => 74.3079],
            ['name' => 'Skardu', 'province' => 'Gilgit-Baltistan', 'latitude' => 35.2971, 'longitude' => 75.6333],
            
            // Azad Kashmir
            ['name' => 'Muzaffarabad', 'province' => 'Azad Kashmir', 'latitude' => 34.3700, 'longitude' => 73.4711],
            ['name' => 'Mirpur', 'province' => 'Azad Kashmir', 'latitude' => 33.1507, 'longitude' => 73.7516],
        ];

        foreach ($districts as $district) {
            District::create($district);
        }
    }
}
