@extends('layouts.app')

@section('title', 'Create Agent')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">
                <i class="bi bi-person-plus text-primary"></i> Create New Agent
            </h1>
            <p class="text-muted mb-0">Add a new delivery agent to the system</p>
        </div>
        <div>
            <a href="{{ route('admin.agents') }}" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left"></i> Back to Agents
            </a>
        </div>
    </div>
    
    <!-- Create Agent Form -->
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card shadow">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-person-badge"></i> Agent Information</h5>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{ route('admin.agents.store') }}">
                        @csrf
                        
                        <!-- User Selection -->
                        <div class="mb-4">
                            <label for="user_id" class="form-label">Select User <span class="text-danger">*</span></label>
                            <select class="form-select @error('user_id') is-invalid @enderror" id="user_id" name="user_id" required>
                                <option value="">Choose a user to make an agent...</option>
                                @foreach($users as $user)
                                    <option value="{{ $user->id }}" {{ old('user_id') == $user->id ? 'selected' : '' }}>
                                        {{ $user->name }} ({{ $user->email }})
                                    </option>
                                @endforeach
                            </select>
                            @error('user_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">Only users without existing agent profiles are shown</small>
                        </div>
                        
                        <!-- Office Selection -->
                        <div class="mb-4">
                            <label for="office_id" class="form-label">Assign Office <span class="text-danger">*</span></label>
                            <select class="form-select @error('office_id') is-invalid @enderror" id="office_id" name="office_id" required>
                                <option value="">Choose an office...</option>
                                @foreach($offices as $office)
                                    <option value="{{ $office->id }}" {{ old('office_id') == $office->id ? 'selected' : '' }}>
                                        {{ $office->name }} - {{ $office->district->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('office_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">Select the office where this agent will be based</small>
                        </div>
                        
                        <div class="row">
                            <!-- Agent Code -->
                            <div class="col-md-6 mb-3">
                                <label for="agent_code" class="form-label">Agent Code <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('agent_code') is-invalid @enderror" 
                                       id="agent_code" name="agent_code" value="{{ old('agent_code') }}" 
                                       placeholder="e.g., AGT001" required>
                                @error('agent_code')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">Unique identifier for the agent</small>
                            </div>
                            
                            <!-- Phone -->
                            <div class="col-md-6 mb-3">
                                <label for="phone" class="form-label">Phone Number <span class="text-danger">*</span></label>
                                <input type="tel" class="form-control @error('phone') is-invalid @enderror" 
                                       id="phone" name="phone" value="{{ old('phone') }}" 
                                       placeholder="+92-300-1234567" required>
                                @error('phone')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <!-- Address -->
                        <div class="mb-3">
                            <label for="address" class="form-label">Address <span class="text-danger">*</span></label>
                            <textarea class="form-control @error('address') is-invalid @enderror" 
                                      id="address" name="address" rows="3" 
                                      placeholder="Complete address of the agent" required>{{ old('address') }}</textarea>
                            @error('address')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="row">
                            <!-- Vehicle Type -->
                            <div class="col-md-6 mb-3">
                                <label for="vehicle_type" class="form-label">Vehicle Type <span class="text-danger">*</span></label>
                                <select class="form-select @error('vehicle_type') is-invalid @enderror" 
                                        id="vehicle_type" name="vehicle_type" required>
                                    <option value="">Select vehicle type...</option>
                                    <option value="bike" {{ old('vehicle_type') == 'bike' ? 'selected' : '' }}>Bike</option>
                                    <option value="car" {{ old('vehicle_type') == 'car' ? 'selected' : '' }}>Car</option>
                                    <option value="van" {{ old('vehicle_type') == 'van' ? 'selected' : '' }}>Van</option>
                                    <option value="truck" {{ old('vehicle_type') == 'truck' ? 'selected' : '' }}>Truck</option>
                                </select>
                                @error('vehicle_type')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <!-- License Number -->
                            <div class="col-md-6 mb-3">
                                <label for="license_number" class="form-label">License Number <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('license_number') is-invalid @enderror" 
                                       id="license_number" name="license_number" value="{{ old('license_number') }}" 
                                       placeholder="e.g., LHR-123456" required>
                                @error('license_number')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <!-- Status -->
                        <div class="mb-4">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="is_active" name="is_active" 
                                       {{ old('is_active', true) ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_active">
                                    <strong>Active Agent</strong>
                                    <small class="text-muted d-block">Agent can receive order assignments</small>
                                </label>
                            </div>
                        </div>
                        
                        <!-- Submit Buttons -->
                        <div class="d-flex justify-content-end gap-2">
                            <a href="{{ route('admin.agents') }}" class="btn btn-secondary">
                                <i class="bi bi-x-circle"></i> Cancel
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-check-circle"></i> Create Agent
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .card {
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        border: 1px solid #e3e6f0;
    }
    
    .card-header {
        background-color: #f8f9fa;
        border-bottom: 1px solid #e3e6f0;
    }
    
    .form-label {
        font-weight: 600;
        color: #5a5c69;
    }
    
    .text-danger {
        font-size: 0.9rem;
    }
    
    .form-text {
        font-size: 0.8rem;
    }
    
    .btn {
        font-weight: 500;
    }
</style>
@endpush

@push('scripts')
<script>
    // Auto-generate agent code based on user selection
    document.getElementById('user_id').addEventListener('change', function() {
        const selectedOption = this.options[this.selectedIndex];
        if (selectedOption.value) {
            const userName = selectedOption.text.split(' (')[0];
            const initials = userName.split(' ').map(name => name.charAt(0)).join('').toUpperCase();
            const randomNum = Math.floor(Math.random() * 1000).toString().padStart(3, '0');
            document.getElementById('agent_code').value = 'AGT' + initials + randomNum;
        } else {
            document.getElementById('agent_code').value = '';
        }
    });
    
    // Form validation
    document.querySelector('form').addEventListener('submit', function(e) {
        const requiredFields = ['user_id', 'agent_code', 'phone', 'address', 'vehicle_type', 'license_number'];
        let isValid = true;
        
        requiredFields.forEach(field => {
            const input = document.getElementById(field);
            if (!input.value.trim()) {
                input.classList.add('is-invalid');
                isValid = false;
            } else {
                input.classList.remove('is-invalid');
            }
        });
        
        if (!isValid) {
            e.preventDefault();
            alert('Please fill in all required fields.');
        }
    });
</script>
@endpush