@extends('layouts.app')

@section('title', 'Manage Agents')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">
                <i class="bi bi-person-badge text-primary"></i> Agent Management
            </h1>
            <p class="text-muted mb-0">Manage delivery agents and their assignments</p>
        </div>
        <div>
            <a href="{{ route('admin.dashboard') }}" class="btn btn-outline-secondary me-2">
                <i class="bi bi-arrow-left"></i> Back to Dashboard
            </a>
            <a href="{{ route('admin.agents.create') }}" class="btn btn-primary">
                <i class="bi bi-plus-circle"></i> Add New Agent
            </a>
        </div>
    </div>
    
    <!-- Search & Filters -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="bi bi-funnel"></i> Search & Filters
            </h6>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('admin.agents') }}">
                <div class="row g-3">
                    <div class="col-md-6">
                        <label for="search" class="form-label">Search</label>
                        <input type="text" class="form-control" id="search" name="search" 
                               value="{{ request('search') }}" 
                               placeholder="Agent name, email, code, phone...">
                    </div>
                    <div class="col-md-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary me-2">
                            <i class="bi bi-search"></i> Search
                        </button>
                        <a href="{{ route('admin.agents') }}" class="btn btn-outline-secondary">
                            <i class="bi bi-x-circle"></i> Clear
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Agents Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="bi bi-list"></i> Agents List ({{ $agents->total() }} total)
            </h6>
            <div class="dropdown">
                <button class="btn btn-sm btn-outline-primary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                    <i class="bi bi-download"></i> Export
                </button>
                <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="#"><i class="bi bi-file-earmark-excel"></i> Export to Excel</a></li>
                    <li><a class="dropdown-item" href="#"><i class="bi bi-file-earmark-pdf"></i> Export to PDF</a></li>
                </ul>
            </div>
        </div>
        <div class="card-body">
            @if($agents->count() > 0)
                <div class="table-responsive">
                    <table class="table table-bordered table-hover" width="100%" cellspacing="0">
                        <thead class="table-light">
                            <tr>
                                <th>Agent Info</th>
                                <th>Contact Details</th>
                                <th>Vehicle Info</th>
                                <th>Performance</th>
                                <th>Status</th>
                                <th>Joined Date</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($agents as $agent)
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="avatar-circle bg-primary text-white me-3">
                                                {{ strtoupper(substr($agent->user->name, 0, 2)) }}
                                            </div>
                                            <div>
                                                <strong>{{ $agent->user->name }}</strong>
                                                <br><small class="text-muted">{{ $agent->user->email }}</small>
                                                <br><span class="badge bg-info">{{ $agent->agent_code }}</span>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="small">
                                            <i class="bi bi-telephone text-primary"></i> 
                                            <a href="tel:{{ $agent->phone }}" class="text-decoration-none">{{ $agent->phone }}</a>
                                            <br><i class="bi bi-geo-alt text-secondary"></i> {{ Str::limit($agent->address, 30) }}
                                        </div>
                                    </td>
                                    <td>
                                        <div class="text-center">
                                            <i class="bi bi-truck fs-4 text-{{ $agent->vehicle_type === 'bike' ? 'warning' : ($agent->vehicle_type === 'car' ? 'info' : 'success') }}"></i>
                                            <br><strong>{{ ucfirst($agent->vehicle_type) }}</strong>
                                            <br><small class="text-muted">{{ $agent->license_number }}</small>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="text-center">
                                            <div class="h5 mb-1 text-primary">{{ $agent->assignedOrders->count() }}</div>
                                            <small class="text-muted">Total Orders</small>
                                            <br>
                                            <div class="small">
                                                <span class="text-success">{{ $agent->assignedOrders->where('status', 'delivered')->count() }} Delivered</span>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="text-center">
                                            @if($agent->is_active)
                                                <span class="badge bg-success">Active</span>
                                                <br><small class="text-muted">Available</small>
                                            @else
                                                <span class="badge bg-danger">Inactive</span>
                                                <br><small class="text-muted">Unavailable</small>
                                            @endif
                                        </div>
                                    </td>
                                    <td>
                                        <div class="small">
                                            {{ $agent->created_at->format('M d, Y') }}
                                            <br>{{ $agent->created_at->format('h:i A') }}
                                        </div>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('admin.agents.edit', $agent) }}" 
                                               class="btn btn-sm btn-outline-primary" title="Edit Agent">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                            <button type="button" class="btn btn-sm btn-outline-info" 
                                                    data-bs-toggle="modal" data-bs-target="#viewModal{{ $agent->id }}" 
                                                    title="View Details">
                                                <i class="bi bi-eye"></i>
                                            </button>
                                            <button type="button" class="btn btn-sm btn-outline-{{ $agent->is_active ? 'warning' : 'success' }}" 
                                                    onclick="toggleAgentStatus({{ $agent->id }}, {{ $agent->is_active ? 'false' : 'true' }})" 
                                                    title="{{ $agent->is_active ? 'Deactivate' : 'Activate' }} Agent">
                                                <i class="bi bi-{{ $agent->is_active ? 'pause' : 'play' }}"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                
                                <!-- View Details Modal -->
                                <div class="modal fade" id="viewModal{{ $agent->id }}" tabindex="-1">
                                    <div class="modal-dialog modal-lg">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title">Agent Details - {{ $agent->user->name }}</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                            </div>
                                            <div class="modal-body">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <h6 class="text-primary mb-3">Personal Information</h6>
                                                        <div class="mb-2"><strong>Name:</strong> {{ $agent->user->name }}</div>
                                                        <div class="mb-2"><strong>Email:</strong> {{ $agent->user->email }}</div>
                                                        <div class="mb-2"><strong>Phone:</strong> {{ $agent->phone }}</div>
                                                        <div class="mb-2"><strong>Agent Code:</strong> {{ $agent->agent_code }}</div>
                                                        <div class="mb-2"><strong>Address:</strong> {{ $agent->address }}</div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <h6 class="text-success mb-3">Vehicle & Performance</h6>
                                                        <div class="mb-2"><strong>Vehicle Type:</strong> {{ ucfirst($agent->vehicle_type) }}</div>
                                                        <div class="mb-2"><strong>License Number:</strong> {{ $agent->license_number }}</div>
                                                        <div class="mb-2"><strong>Status:</strong> 
                                                            <span class="badge bg-{{ $agent->is_active ? 'success' : 'danger' }}">
                                                                {{ $agent->is_active ? 'Active' : 'Inactive' }}
                                                            </span>
                                                        </div>
                                                        <div class="mb-2"><strong>Total Orders:</strong> {{ $agent->assignedOrders->count() }}</div>
                                                        <div class="mb-2"><strong>Delivered Orders:</strong> {{ $agent->assignedOrders->where('status', 'delivered')->count() }}</div>
                                                        <div class="mb-2"><strong>Joined Date:</strong> {{ $agent->created_at->format('M d, Y') }}</div>
                                                    </div>
                                                </div>
                                                
                                                @if($agent->assignedOrders->count() > 0)
                                                    <hr>
                                                    <h6 class="text-info mb-3">Recent Orders</h6>
                                                    <div class="table-responsive">
                                                        <table class="table table-sm">
                                                            <thead>
                                                                <tr>
                                                                    <th>Tracking Code</th>
                                                                    <th>Route</th>
                                                                    <th>Status</th>
                                                                    <th>Date</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @foreach($agent->assignedOrders->take(5) as $order)
                                                                    <tr>
                                                                        <td><strong>{{ $order->tracking_code }}</strong></td>
                                                                        <td class="small">
                                                                            {{ $order->pickupDistrict->name }} → {{ $order->dropDistrict->name }}
                                                                        </td>
                                                                        <td>
                                                                            <span class="badge bg-{{ $order->status_badge }} badge-sm">
                                                                                {{ ucfirst(str_replace('_', ' ', $order->status)) }}
                                                                            </span>
                                                                        </td>
                                                                        <td class="small">{{ $order->created_at->format('M d') }}</td>
                                                                    </tr>
                                                                @endforeach
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                @endif
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                <a href="{{ route('admin.agents.edit', $agent) }}" class="btn btn-primary">
                                                    <i class="bi bi-pencil"></i> Edit Agent
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <div class="d-flex justify-content-center mt-4">
                    {{ $agents->appends(request()->query())->links() }}
                </div>
            @else
                <div class="text-center py-5">
                    <i class="bi bi-person-badge text-muted" style="font-size: 4rem;"></i>
                    <h4 class="text-muted mt-3">No Agents Found</h4>
                    <p class="text-muted">No agents match your current search criteria.</p>
                    <a href="{{ route('admin.agents.create') }}" class="btn btn-primary">
                        <i class="bi bi-plus-circle"></i> Add First Agent
                    </a>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .avatar-circle {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
        font-size: 14px;
    }
    
    .table th {
        border-top: none;
        font-weight: 600;
        font-size: 0.85rem;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .table td {
        vertical-align: middle;
        font-size: 0.9rem;
    }
    
    .btn-group .btn {
        border-radius: 0.25rem;
        margin-right: 2px;
    }
    
    .badge {
        font-size: 0.75rem;
    }
    
    .badge-sm {
        font-size: 0.65rem;
        padding: 0.25em 0.5em;
    }
    
    .card {
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        border: 1px solid #e3e6f0;
    }
    
    .card-header {
        background-color: #f8f9fa;
        border-bottom: 1px solid #e3e6f0;
    }
    
    .modal-header {
        background-color: #f8f9fa;
        border-bottom: 1px solid #dee2e6;
    }
</style>
@endpush

@push('scripts')
<script>
    function toggleAgentStatus(agentId, newStatus) {
        if (confirm('Are you sure you want to ' + (newStatus ? 'activate' : 'deactivate') + ' this agent?')) {
            // Create a form and submit it
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = '/admin/agents/' + agentId + '/toggle-status';
            
            // Add CSRF token
            const csrfToken = document.createElement('input');
            csrfToken.type = 'hidden';
            csrfToken.name = '_token';
            csrfToken.value = '{{ csrf_token() }}';
            form.appendChild(csrfToken);
            
            // Add method override
            const methodField = document.createElement('input');
            methodField.type = 'hidden';
            methodField.name = '_method';
            methodField.value = 'PATCH';
            form.appendChild(methodField);
            
            // Add status field
            const statusField = document.createElement('input');
            statusField.type = 'hidden';
            statusField.name = 'is_active';
            statusField.value = newStatus;
            form.appendChild(statusField);
            
            document.body.appendChild(form);
            form.submit();
        }
    }
    
    // Show success message if exists
    @if(session('success'))
        const toast = document.createElement('div');
        toast.className = 'alert alert-success alert-dismissible fade show position-fixed';
        toast.style.top = '20px';
        toast.style.right = '20px';
        toast.style.zIndex = '9999';
        toast.innerHTML = `
            <i class="bi bi-check-circle"></i> {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        `;
        document.body.appendChild(toast);
        
        setTimeout(() => {
            toast.remove();
        }, 5000);
    @endif
</script>
@endpush