@extends('layouts.app')

@section('title', 'Manage Orders')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">
                <i class="bi bi-box-seam text-primary"></i> Order Management
            </h1>
            <p class="text-muted mb-0">Manage and track all courier orders</p>
        </div>
        <div>
            <a href="{{ route('admin.dashboard') }}" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left"></i> Back to Dashboard
            </a>
        </div>
    </div>
    
    <!-- Filters -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="bi bi-funnel"></i> Filters
            </h6>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('admin.orders') }}">
                <div class="row g-3">
                    <div class="col-md-3">
                        <label for="search" class="form-label">Search</label>
                        <input type="text" class="form-control" id="search" name="search" 
                               value="{{ request('search') }}" 
                               placeholder="Tracking code, name, phone...">
                    </div>
                    <div class="col-md-3">
                        <label for="status" class="form-label">Status</label>
                        <select class="form-select" id="status" name="status">
                            <option value="">All Statuses</option>
                            <option value="created" {{ request('status') == 'created' ? 'selected' : '' }}>Created</option>
                            <option value="picked" {{ request('status') == 'picked' ? 'selected' : '' }}>Picked</option>
                            <option value="in_transit" {{ request('status') == 'in_transit' ? 'selected' : '' }}>In Transit</option>
                            <option value="delivered" {{ request('status') == 'delivered' ? 'selected' : '' }}>Delivered</option>
                            <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="payment_status" class="form-label">Payment Status</label>
                        <select class="form-select" id="payment_status" name="payment_status">
                            <option value="">All Payment Status</option>
                            <option value="pending" {{ request('payment_status') == 'pending' ? 'selected' : '' }}>Pending</option>
                            <option value="paid" {{ request('payment_status') == 'paid' ? 'selected' : '' }}>Paid</option>
                            <option value="failed" {{ request('payment_status') == 'failed' ? 'selected' : '' }}>Failed</option>
                        </select>
                    </div>
                    <div class="col-md-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary me-2">
                            <i class="bi bi-search"></i> Filter
                        </button>
                        <a href="{{ route('admin.orders') }}" class="btn btn-outline-secondary">
                            <i class="bi bi-x-circle"></i> Clear
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Orders Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="bi bi-list"></i> Orders List ({{ $orders->total() }} total)
            </h6>
            <div class="dropdown">
                <button class="btn btn-sm btn-outline-primary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                    <i class="bi bi-download"></i> Export
                </button>
                <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="#"><i class="bi bi-file-earmark-excel"></i> Export to Excel</a></li>
                    <li><a class="dropdown-item" href="#"><i class="bi bi-file-earmark-pdf"></i> Export to PDF</a></li>
                </ul>
            </div>
        </div>
        <div class="card-body">
            @if($orders->count() > 0)
                <div class="table-responsive">
                    <table class="table table-bordered table-hover" width="100%" cellspacing="0">
                        <thead class="table-light">
                            <tr>
                                <th>Tracking Code</th>
                                <th>Customer</th>
                                <th>Route</th>
                                <th>Package</th>
                                <th>Status</th>
                                <th>Payment</th>
                                <th>Amount</th>
                                <th>Date</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($orders as $order)
                                <tr>
                                    <td>
                                        <strong class="text-primary">{{ $order->tracking_code }}</strong>
                                        @if($order->assignedAgent)
                                            <br><small class="text-muted">
                                                <i class="bi bi-person-badge"></i> {{ $order->assignedAgent->agent_code }}
                                            </small>
                                        @endif
                                    </td>
                                    <td>
                                        <div>
                                            <strong>{{ $order->user->name }}</strong>
                                            <br><small class="text-muted">{{ $order->user->email }}</small>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="small">
                                            <i class="bi bi-geo-alt text-primary"></i> {{ $order->pickupDistrict->name }}
                                            <br><i class="bi bi-geo-alt-fill text-success"></i> {{ $order->dropDistrict->name }}
                                        </div>
                                    </td>
                                    <td>
                                        <div class="small">
                                            <strong>{{ $order->weight }}kg</strong> - {{ $order->size }}
                                            <br>{{ $order->category }}
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-{{ $order->status_badge }}">
                                            {{ ucfirst(str_replace('_', ' ', $order->status)) }}
                                        </span>
                                        @if($order->status == 'delivered' && $order->delivered_at)
                                            <br><small class="text-muted">{{ $order->delivered_at->format('M d, Y') }}</small>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge bg-{{ $order->payment_status === 'paid' ? 'success' : ($order->payment_status === 'failed' ? 'danger' : 'warning') }}">
                                            {{ ucfirst($order->payment_status) }}
                                        </span>
                                        <br><small class="text-muted">{{ $order->payment_method === 'cod' ? 'COD' : ucfirst($order->payment_method) }}</small>
                                    </td>
                                    <td>
                                        <strong>PKR {{ number_format($order->final_price, 2) }}</strong>
                                    </td>
                                    <td>
                                        <div class="small">
                                            {{ $order->created_at->format('M d, Y') }}
                                            <br>{{ $order->created_at->format('h:i A') }}
                                        </div>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('admin.orders.show', $order) }}" 
                                               class="btn btn-sm btn-outline-primary" title="View Details">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                            <button type="button" class="btn btn-sm btn-outline-success" 
                                                    data-bs-toggle="modal" data-bs-target="#statusModal{{ $order->id }}" 
                                                    title="Update Status">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            @if(!$order->assignedAgent)
                                                <button type="button" class="btn btn-sm btn-outline-warning" 
                                                        data-bs-toggle="modal" data-bs-target="#assignModal{{ $order->id }}" 
                                                        title="Assign Agent">
                                                    <i class="bi bi-person-plus"></i>
                                                </button>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                                
                                <!-- Status Update Modal -->
                                <div class="modal fade" id="statusModal{{ $order->id }}" tabindex="-1">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title">Update Order Status</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                            </div>
                                            <form method="POST" action="{{ route('admin.orders.update-status', $order) }}">
                                                @csrf
                                                @method('PATCH')
                                                <div class="modal-body">
                                                    <div class="mb-3">
                                                        <label for="status{{ $order->id }}" class="form-label">Status</label>
                                                        <select class="form-select" id="status{{ $order->id }}" name="status" required>
                                                            <option value="created" {{ $order->status == 'created' ? 'selected' : '' }}>Created</option>
                                                            <option value="picked" {{ $order->status == 'picked' ? 'selected' : '' }}>Picked</option>
                                                            <option value="in_transit" {{ $order->status == 'in_transit' ? 'selected' : '' }}>In Transit</option>
                                                            <option value="delivered" {{ $order->status == 'delivered' ? 'selected' : '' }}>Delivered</option>
                                                            <option value="cancelled" {{ $order->status == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                                                        </select>
                                                    </div>
                                                    <div class="mb-3">
                                                        <label for="notes{{ $order->id }}" class="form-label">Notes (Optional)</label>
                                                        <textarea class="form-control" id="notes{{ $order->id }}" name="notes" rows="3" placeholder="Add any notes about this status update...">{{ $order->notes }}</textarea>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                    <button type="submit" class="btn btn-primary">Update Status</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Assign Agent Modal -->
                                @if(!$order->assignedAgent)
                                    <div class="modal fade" id="assignModal{{ $order->id }}" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Assign Agent</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                </div>
                                                <form method="POST" action="{{ route('admin.orders.assign-agent', $order) }}">
                                                    @csrf
                                                    @method('PUT')
                                                    <div class="modal-body">
                                                        <div class="mb-3">
                                                            <label for="agent{{ $order->id }}" class="form-label">Select Agent</label>
                                                            <select class="form-select" id="agent{{ $order->id }}" name="agent_id" required>
                                                                <option value="">Choose an agent...</option>
                                                                @foreach(\App\Models\Agent::with('user')->where('is_active', true)->get() as $agent)
                                                                    <option value="{{ $agent->id }}">
                                                                        {{ $agent->user->name }} ({{ $agent->agent_code }}) - {{ $agent->vehicle_type }}
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                        <button type="submit" class="btn btn-primary">Assign Agent</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <div class="d-flex justify-content-center mt-4">
                    {{ $orders->appends(request()->query())->links() }}
                </div>
            @else
                <div class="text-center py-5">
                    <i class="bi bi-inbox text-muted" style="font-size: 4rem;"></i>
                    <h4 class="text-muted mt-3">No Orders Found</h4>
                    <p class="text-muted">No orders match your current filters.</p>
                    <a href="{{ route('admin.orders') }}" class="btn btn-primary">
                        <i class="bi bi-arrow-clockwise"></i> Reset Filters
                    </a>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .table th {
        border-top: none;
        font-weight: 600;
        font-size: 0.85rem;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    .table td {
        vertical-align: middle;
        font-size: 0.9rem;
    }
    .btn-group .btn {
        border-radius: 0.25rem;
        margin-right: 2px;
    }
    .badge {
        font-size: 0.75rem;
    }
    .modal-header {
        background-color: #f8f9fa;
        border-bottom: 1px solid #dee2e6;
    }
    .card {
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        border: 1px solid #e3e6f0;
    }
    .card-header {
        background-color: #f8f9fa;
        border-bottom: 1px solid #e3e6f0;
    }
</style>
@endpush

@push('scripts')
<script>
    // Auto-refresh page every 30 seconds
    setTimeout(function() {
        location.reload();
    }, 30000);
    
    // Show success message if exists
    @if(session('success'))
        const toast = document.createElement('div');
        toast.className = 'alert alert-success alert-dismissible fade show position-fixed';
        toast.style.top = '20px';
        toast.style.right = '20px';
        toast.style.zIndex = '9999';
        toast.innerHTML = `
            <i class="bi bi-check-circle"></i> {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        `;
        document.body.appendChild(toast);
        
        setTimeout(() => {
            toast.remove();
        }, 5000);
    @endif
</script>
@endpush