@extends('layouts.app')

@section('title', 'Order Details - ' . $order->tracking_code)

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">
                <i class="bi bi-box-seam text-primary"></i> Order Details
            </h1>
            <p class="text-muted mb-0">Tracking Code: <strong class="text-primary">{{ $order->tracking_code }}</strong></p>
        </div>
        <div>
            <a href="{{ route('admin.orders') }}" class="btn btn-outline-secondary me-2">
                <i class="bi bi-arrow-left"></i> Back to Orders
            </a>
            <a href="{{ route('orders.invoice', $order) }}" class="btn btn-primary" target="_blank">
                <i class="bi bi-download"></i> Download Invoice
            </a>
        </div>
    </div>
    
    <!-- Order Status Card -->
    <div class="card shadow-lg mb-4">
        <div class="card-header bg-{{ $order->status_badge }} text-white">
            <div class="row align-items-center">
                <div class="col">
                    <h4 class="mb-0">
                        <i class="bi bi-truck"></i> 
                        Status: {{ ucfirst(str_replace('_', ' ', $order->status)) }}
                    </h4>
                </div>
                <div class="col-auto">
                    <button type="button" class="btn btn-light btn-sm" data-bs-toggle="modal" data-bs-target="#statusModal">
                        <i class="bi bi-pencil"></i> Update Status
                    </button>
                </div>
            </div>
        </div>
        <div class="card-body">
            <!-- Progress Timeline -->
            <div class="row">
                <div class="col-12">
                    <div class="timeline">
                        <div class="timeline-item {{ $order->status === 'created' || $order->status === 'picked' || $order->status === 'in_transit' || $order->status === 'delivered' ? 'completed' : '' }}">
                            <div class="timeline-marker bg-success"></div>
                            <div class="timeline-content">
                                <h6 class="mb-1">Order Created</h6>
                                <small class="text-muted">{{ $order->created_at->format('M d, Y - h:i A') }}</small>
                                <p class="mb-0 small">Order placed by {{ $order->user->name }}</p>
                            </div>
                        </div>
                        
                        <div class="timeline-item {{ $order->status === 'picked' || $order->status === 'in_transit' || $order->status === 'delivered' ? 'completed' : '' }}">
                            <div class="timeline-marker {{ $order->picked_at ? 'bg-success' : 'bg-secondary' }}"></div>
                            <div class="timeline-content">
                                <h6 class="mb-1">Package Picked Up</h6>
                                <small class="text-muted">
                                    {{ $order->picked_at ? $order->picked_at->format('M d, Y - h:i A') : 'Pending pickup' }}
                                </small>
                                @if($order->assignedAgent)
                                    <p class="mb-0 small">Agent: {{ $order->assignedAgent->user->name }} ({{ $order->assignedAgent->agent_code }})</p>
                                @endif
                            </div>
                        </div>
                        
                        <div class="timeline-item {{ $order->status === 'in_transit' || $order->status === 'delivered' ? 'completed' : '' }}">
                            <div class="timeline-marker {{ $order->status === 'in_transit' || $order->status === 'delivered' ? 'bg-success' : 'bg-secondary' }}"></div>
                            <div class="timeline-content">
                                <h6 class="mb-1">In Transit</h6>
                                <small class="text-muted">
                                    {{ $order->status === 'in_transit' || $order->status === 'delivered' ? 'Package is on the way' : 'Waiting for pickup' }}
                                </small>
                            </div>
                        </div>
                        
                        <div class="timeline-item {{ $order->status === 'delivered' ? 'completed' : '' }}">
                            <div class="timeline-marker {{ $order->delivered_at ? 'bg-success' : 'bg-secondary' }}"></div>
                            <div class="timeline-content">
                                <h6 class="mb-1">Delivered</h6>
                                <small class="text-muted">
                                    {{ $order->delivered_at ? $order->delivered_at->format('M d, Y - h:i A') : 'Pending delivery' }}
                                </small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Order Details -->
    <div class="row g-4">
        <!-- Customer & Contact Info -->
        <div class="col-lg-6">
            <div class="card h-100 shadow">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-people"></i> Customer & Contact Information</h5>
                </div>
                <div class="card-body">
                    <!-- Customer Info -->
                    <div class="mb-4">
                        <h6 class="text-primary mb-3">Customer Information</h6>
                        <div class="p-3 bg-light rounded">
                            <div class="row">
                                <div class="col-sm-4"><strong>Name:</strong></div>
                                <div class="col-sm-8">{{ $order->user->name }}</div>
                            </div>
                            <div class="row">
                                <div class="col-sm-4"><strong>Email:</strong></div>
                                <div class="col-sm-8">{{ $order->user->email }}</div>
                            </div>
                            <div class="row">
                                <div class="col-sm-4"><strong>Phone:</strong></div>
                                <div class="col-sm-8">{{ $order->user->phone ?? 'Not provided' }}</div>
                            </div>
                            <div class="row">
                                <div class="col-sm-4"><strong>Member Since:</strong></div>
                                <div class="col-sm-8">{{ $order->user->created_at->format('M d, Y') }}</div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Sender Info -->
                    <div class="mb-4">
                        <h6 class="text-info mb-3">Sender Information</h6>
                        <div class="p-3 bg-light rounded">
                            <p class="mb-2"><strong>{{ $order->sender_name }}</strong></p>
                            <p class="mb-2">
                                <i class="bi bi-telephone text-primary"></i> 
                                <a href="tel:{{ $order->sender_phone }}" class="text-decoration-none">{{ $order->sender_phone }}</a>
                            </p>
                            <p class="mb-0">
                                <i class="bi bi-geo-alt text-primary"></i> 
                                {{ $order->sender_address }}
                            </p>
                        </div>
                    </div>
                    
                    <!-- Receiver Info -->
                    <div>
                        <h6 class="text-success mb-3">Receiver Information</h6>
                        <div class="p-3 bg-light rounded">
                            <p class="mb-2"><strong>{{ $order->receiver_name }}</strong></p>
                            <p class="mb-2">
                                <i class="bi bi-telephone text-success"></i> 
                                <a href="tel:{{ $order->receiver_phone }}" class="text-decoration-none">{{ $order->receiver_phone }}</a>
                            </p>
                            <p class="mb-0">
                                <i class="bi bi-geo-alt text-success"></i> 
                                {{ $order->receiver_address }}
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Package & Delivery Details -->
        <div class="col-lg-6">
            <div class="card h-100 shadow">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-box"></i> Package & Delivery Details</h5>
                </div>
                <div class="card-body">
                    <!-- Package Details -->
                    <h6 class="text-warning mb-3">Package Information</h6>
                    <div class="row g-3 mb-4">
                        <div class="col-6">
                            <div class="border rounded p-3 text-center">
                                <i class="bi bi-speedometer2 text-primary d-block mb-2" style="font-size: 1.5rem;"></i>
                                <small class="text-muted">Weight</small>
                                <div class="fw-bold">{{ $order->weight }} kg</div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="border rounded p-3 text-center">
                                <i class="bi bi-arrows-fullscreen text-info d-block mb-2" style="font-size: 1.5rem;"></i>
                                <small class="text-muted">Size</small>
                                <div class="fw-bold">{{ $order->size }}</div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="border rounded p-3 text-center">
                                <i class="bi bi-tag text-warning d-block mb-2" style="font-size: 1.5rem;"></i>
                                <small class="text-muted">Category</small>
                                <div class="fw-bold">{{ $order->category }}</div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="border rounded p-3 text-center">
                                <i class="bi bi-truck text-success d-block mb-2" style="font-size: 1.5rem;"></i>
                                <small class="text-muted">Vehicle</small>
                                <div class="fw-bold">{{ ucfirst($order->vehicle_type) }}</div>
                            </div>
                        </div>
                    </div>
                    
                    @if($order->description)
                        <div class="mb-4">
                            <h6 class="text-secondary mb-2">Description</h6>
                            <div class="p-3 bg-light rounded">
                                <p class="mb-0">{{ $order->description }}</p>
                            </div>
                        </div>
                    @endif
                    
                    <!-- Delivery Type -->
                    <div class="mb-3">
                        <h6 class="text-primary mb-2">Delivery Information</h6>
                        <div class="p-3 bg-light rounded">
                            <div class="row mb-2">
                                <div class="col-sm-5"><strong>Delivery Type:</strong></div>
                                <div class="col-sm-7">
                                    <span class="badge bg-info">
                                        {{ ucfirst(str_replace('_', ' ', $order->delivery_type)) }}
                                    </span>
                                </div>
                            </div>
                            <div class="row mb-2">
                                <div class="col-sm-5"><strong>Estimated Delivery:</strong></div>
                                <div class="col-sm-7">
                                    {{ $order->delivery_type === 'express' ? '1-2 days' : ($order->delivery_type === 'standard' ? '3-5 days' : '5-7 days') }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Route & Service Provider -->
    <div class="row g-4 mt-2">
        <div class="col-lg-8">
            <div class="card shadow">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-map"></i> Delivery Route & Service Provider</h5>
                </div>
                <div class="card-body">
                    <div class="row align-items-center mb-4">
                        <div class="col-md-5 text-center">
                            <div class="p-4 bg-light rounded">
                                <i class="bi bi-geo-alt-fill text-primary fs-1 mb-3"></i>
                                <h6 class="mb-2">Pickup Location</h6>
                                <p class="mb-1 fw-bold fs-5">{{ $order->pickupDistrict->name }}</p>
                                <small class="text-muted">{{ $order->pickupDistrict->province }}</small>
                            </div>
                        </div>
                        <div class="col-md-2 text-center">
                            <i class="bi bi-arrow-right text-primary" style="font-size: 2rem;"></i>
                        </div>
                        <div class="col-md-5 text-center">
                            <div class="p-4 bg-light rounded">
                                <i class="bi bi-geo-alt-fill text-success fs-1 mb-3"></i>
                                <h6 class="mb-2">Drop Location</h6>
                                <p class="mb-1 fw-bold fs-5">{{ $order->dropDistrict->name }}</p>
                                <small class="text-muted">{{ $order->dropDistrict->province }}</small>
                            </div>
                        </div>
                    </div>
                    
                    @if($order->assignedOffice)
                        <div class="p-3 bg-info bg-opacity-10 rounded mb-3">
                            <h6 class="text-info mb-2">
                                <i class="bi bi-building"></i> Assigned Office
                            </h6>
                            <div class="row">
                                <div class="col-md-6">
                                    <p class="mb-1 fw-bold">{{ $order->assignedOffice->name }}</p>
                                    <p class="mb-1">{{ $order->assignedOffice->address }}</p>
                                </div>
                                <div class="col-md-6">
                                    <p class="mb-1">
                                        <i class="bi bi-telephone"></i> {{ $order->assignedOffice->phone }}
                                    </p>
                                    <p class="mb-1">
                                        <i class="bi bi-person"></i> Manager: {{ $order->assignedOffice->manager_name }}
                                    </p>
                                </div>
                            </div>
                        </div>
                    @endif
                    
                    @if($order->assignedAgent)
                        <div class="p-3 bg-success bg-opacity-10 rounded">
                            <h6 class="text-success mb-2">
                                <i class="bi bi-person-badge"></i> Assigned Agent
                            </h6>
                            <div class="row">
                                <div class="col-md-6">
                                    <p class="mb-1 fw-bold">{{ $order->assignedAgent->user->name }}</p>
                                    <p class="mb-1">Agent Code: {{ $order->assignedAgent->agent_code }}</p>
                                </div>
                                <div class="col-md-6">
                                    <p class="mb-1">
                                        <i class="bi bi-telephone"></i> {{ $order->assignedAgent->phone }}
                                    </p>
                                    <p class="mb-1">
                                        <i class="bi bi-truck"></i> Vehicle: {{ ucfirst($order->assignedAgent->vehicle_type) }}
                                    </p>
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="p-3 bg-warning bg-opacity-10 rounded">
                            <h6 class="text-warning mb-2">
                                <i class="bi bi-exclamation-triangle"></i> No Agent Assigned
                            </h6>
                            <p class="mb-2">This order has not been assigned to any agent yet.</p>
                            <button type="button" class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#assignModal">
                                <i class="bi bi-person-plus"></i> Assign Agent
                            </button>
                        </div>
                    @endif
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <div class="card shadow">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-currency-dollar"></i> Payment Details</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-3">
                        <span>Estimated Price:</span>
                        <span class="fw-bold">PKR {{ number_format($order->estimated_price, 2) }}</span>
                    </div>
                    <div class="d-flex justify-content-between mb-3">
                        <span>Delivery Type:</span>
                        <span class="fw-bold">{{ ucfirst(str_replace('_', ' ', $order->delivery_type)) }}</span>
                    </div>
                    <div class="d-flex justify-content-between mb-3">
                        <span>Payment Method:</span>
                        <span class="fw-bold">{{ $order->payment_method === 'cod' ? 'COD' : ucfirst($order->payment_method) }}</span>
                    </div>
                    <div class="d-flex justify-content-between mb-3">
                        <span>Payment Status:</span>
                        <span class="badge bg-{{ $order->payment_status === 'paid' ? 'success' : ($order->payment_status === 'failed' ? 'danger' : 'warning') }}">
                            {{ ucfirst($order->payment_status) }}
                        </span>
                    </div>
                    @if($order->payment_reference)
                        <div class="d-flex justify-content-between mb-3">
                            <span>Reference:</span>
                            <span class="fw-bold">{{ $order->payment_reference }}</span>
                        </div>
                    @endif
                    <hr>
                    <div class="d-flex justify-content-between">
                        <span class="fw-bold fs-5">Total Amount:</span>
                        <span class="fw-bold text-primary fs-4">PKR {{ number_format($order->final_price, 2) }}</span>
                    </div>
                </div>
            </div>
            
            @if($order->notes)
                <div class="card shadow mt-3">
                    <div class="card-header">
                        <h6 class="mb-0"><i class="bi bi-sticky"></i> Admin Notes</h6>
                    </div>
                    <div class="card-body">
                        <p class="mb-0">{{ $order->notes }}</p>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Status Update Modal -->
<div class="modal fade" id="statusModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Update Order Status</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="{{ route('admin.orders.update-status', $order) }}">
                @csrf
                @method('PATCH')
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="status" class="form-label">Status</label>
                        <select class="form-select" id="status" name="status" required>
                            <option value="created" {{ $order->status == 'created' ? 'selected' : '' }}>Created</option>
                            <option value="picked" {{ $order->status == 'picked' ? 'selected' : '' }}>Picked</option>
                            <option value="in_transit" {{ $order->status == 'in_transit' ? 'selected' : '' }}>In Transit</option>
                            <option value="delivered" {{ $order->status == 'delivered' ? 'selected' : '' }}>Delivered</option>
                            <option value="cancelled" {{ $order->status == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="notes" class="form-label">Notes (Optional)</label>
                        <textarea class="form-control" id="notes" name="notes" rows="3" placeholder="Add any notes about this status update...">{{ $order->notes }}</textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Update Status</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Assign Agent Modal -->
@if(!$order->assignedAgent)
    <div class="modal fade" id="assignModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Assign Agent</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form method="POST" action="{{ route('admin.orders.assign-agent', $order) }}">
                    @csrf
                    @method('PUT')
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="agent" class="form-label">Select Agent</label>
                            <select class="form-select" id="agent" name="agent_id" required>
                                <option value="">Choose an agent...</option>
                                @foreach(\App\Models\Agent::with('user')->where('is_active', true)->get() as $agent)
                                    <option value="{{ $agent->id }}">
                                        {{ $agent->user->name }} ({{ $agent->agent_code }}) - {{ $agent->vehicle_type }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Assign Agent</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endif
@endsection

@push('styles')
<style>
    .timeline {
        position: relative;
        padding-left: 30px;
    }
    
    .timeline::before {
        content: '';
        position: absolute;
        left: 15px;
        top: 0;
        bottom: 0;
        width: 2px;
        background: #dee2e6;
    }
    
    .timeline-item {
        position: relative;
        margin-bottom: 30px;
    }
    
    .timeline-item.completed::before {
        background: #28a745;
    }
    
    .timeline-marker {
        position: absolute;
        left: -22px;
        top: 0;
        width: 12px;
        height: 12px;
        border-radius: 50%;
        border: 2px solid #fff;
        box-shadow: 0 0 0 2px #dee2e6;
    }
    
    .timeline-item.completed .timeline-marker {
        box-shadow: 0 0 0 2px #28a745;
    }
    
    .timeline-content {
        padding-left: 20px;
    }
    
    .card {
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        border: 1px solid #e3e6f0;
    }
    
    .card-header {
        background-color: #f8f9fa;
        border-bottom: 1px solid #e3e6f0;
    }
</style>
@endpush