@extends('layouts.app')

@section('title', 'Admin Reports')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">
                <i class="bi bi-graph-up text-primary"></i> Reports & Analytics
            </h1>
            <p class="text-muted mb-0">Business insights and performance metrics</p>
        </div>
        <div>
            <a href="{{ route('admin.dashboard') }}" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left"></i> Back to Dashboard
            </a>
        </div>
    </div>
    
    <!-- Date Range Filter -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="bi bi-calendar-range"></i> Date Range Filter
            </h6>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('admin.reports') }}">
                <div class="row g-3">
                    <div class="col-md-3">
                        <label for="start_date" class="form-label">Start Date</label>
                        <input type="date" class="form-control" id="start_date" name="start_date" 
                               value="{{ $startDate }}">
                    </div>
                    <div class="col-md-3">
                        <label for="end_date" class="form-label">End Date</label>
                        <input type="date" class="form-control" id="end_date" name="end_date" 
                               value="{{ $endDate }}">
                    </div>
                    <div class="col-md-3">
                        <label for="period" class="form-label">Period</label>
                        <select class="form-select" id="period" name="period">
                            <option value="day" {{ $period == 'day' ? 'selected' : '' }}>Daily</option>
                            <option value="week" {{ $period == 'week' ? 'selected' : '' }}>Weekly</option>
                            <option value="month" {{ $period == 'month' ? 'selected' : '' }}>Monthly</option>
                        </select>
                    </div>
                    <div class="col-md-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary me-2">
                            <i class="bi bi-funnel"></i> Apply Filter
                        </button>
                        <button type="button" class="btn btn-outline-success" onclick="exportReports()">
                            <i class="bi bi-download"></i> Export
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Revenue Chart -->
    <div class="row g-4 mb-4">
        <div class="col-xl-8">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="bi bi-currency-dollar"></i> Revenue Trend
                    </h6>
                </div>
                <div class="card-body">
                    @if($revenue_data->count() > 0)
                        <div class="chart-container" style="height: 400px;">
                            <canvas id="revenueChart"></canvas>
                        </div>
                        <div class="mt-3">
                            <div class="row text-center">
                                <div class="col-md-4">
                                    <div class="border-end">
                                        <div class="h4 text-primary mb-1">PKR {{ number_format($revenue_data->sum('revenue'), 2) }}</div>
                                        <small class="text-muted">Total Revenue</small>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="border-end">
                                        <div class="h4 text-success mb-1">{{ number_format($revenue_data->sum('orders')) }}</div>
                                        <small class="text-muted">Total Orders</small>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="h4 text-info mb-1">PKR {{ $revenue_data->count() > 0 ? number_format($revenue_data->sum('revenue') / $revenue_data->sum('orders'), 2) : '0.00' }}</div>
                                    <small class="text-muted">Average Order Value</small>
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="bi bi-graph-up text-muted" style="font-size: 3rem;"></i>
                            <p class="text-muted mt-2">No revenue data available for selected period</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
        
        <!-- Order Status Distribution -->
        <div class="col-xl-4">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="bi bi-pie-chart"></i> Order Status Distribution
                    </h6>
                </div>
                <div class="card-body">
                    @if($status_data->count() > 0)
                        <div class="chart-container" style="height: 300px;">
                            <canvas id="statusChart"></canvas>
                        </div>
                        <div class="mt-3">
                            @foreach($status_data as $status)
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <div class="d-flex align-items-center">
                                        <div class="status-indicator bg-{{ 
                                            $status->status === 'delivered' ? 'success' : 
                                            ($status->status === 'in_transit' ? 'info' : 
                                            ($status->status === 'picked' ? 'warning' : 
                                            ($status->status === 'cancelled' ? 'danger' : 'secondary')))
                                        }} me-2"></div>
                                        <small>{{ ucfirst(str_replace('_', ' ', $status->status)) }}</small>
                                    </div>
                                    <strong>{{ $status->count }}</strong>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="bi bi-pie-chart text-muted" style="font-size: 3rem;"></i>
                            <p class="text-muted mt-2">No status data available</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
    
    <!-- Top Districts & Agent Performance -->
    <div class="row g-4">
        <!-- Top Districts -->
        <div class="col-xl-6">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="bi bi-geo-alt"></i> Top Districts (Most Active)
                    </h6>
                </div>
                <div class="card-body">
                    @if($district_data->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-borderless">
                                <thead>
                                    <tr>
                                        <th>Rank</th>
                                        <th>District</th>
                                        <th>Orders</th>
                                        <th>Activity</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($district_data->take(10) as $district => $count)
                                        <tr>
                                            <td>
                                                <span class="badge bg-{{ $loop->iteration <= 3 ? 'warning' : 'secondary' }}">
                                                    #{{ $loop->iteration }}
                                                </span>
                                            </td>
                                            <td><strong>{{ $district }}</strong></td>
                                            <td>{{ $count }}</td>
                                            <td>
                                                <div class="progress" style="height: 8px;">
                                                    <div class="progress-bar bg-primary" 
                                                         style="width: {{ ($count / $district_data->max()) * 100 }}%"></div>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-4">
                            <i class="bi bi-geo-alt text-muted" style="font-size: 3rem;"></i>
                            <p class="text-muted mt-2">No district data available</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
        
        <!-- Agent Performance -->
        <div class="col-xl-6">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="bi bi-person-badge"></i> Top Performing Agents
                    </h6>
                </div>
                <div class="card-body">
                    @if($agent_performance->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-borderless">
                                <thead>
                                    <tr>
                                        <th>Rank</th>
                                        <th>Agent</th>
                                        <th>Orders</th>
                                        <th>Performance</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($agent_performance as $agent)
                                        <tr>
                                            <td>
                                                <span class="badge bg-{{ $loop->iteration <= 3 ? 'success' : 'secondary' }}">
                                                    #{{ $loop->iteration }}
                                                </span>
                                            </td>
                                            <td>
                                                <div>
                                                    <strong>{{ $agent->user->name }}</strong>
                                                    <br><small class="text-muted">{{ $agent->agent_code }}</small>
                                                </div>
                                            </td>
                                            <td>{{ $agent->assigned_orders_count }}</td>
                                            <td>
                                                <div class="progress" style="height: 8px;">
                                                    <div class="progress-bar bg-success" 
                                                         style="width: {{ ($agent->assigned_orders_count / $agent_performance->max('assigned_orders_count')) * 100 }}%"></div>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-4">
                            <i class="bi bi-person-badge text-muted" style="font-size: 3rem;"></i>
                            <p class="text-muted mt-2">No agent performance data available</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
    
    <!-- Summary Cards -->
    <div class="row g-4 mt-2">
        <div class="col-md-3">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Revenue (Period)
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                PKR {{ number_format($revenue_data->sum('revenue'), 2) }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="bi bi-currency-dollar fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Total Orders (Period)
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ number_format($revenue_data->sum('orders')) }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="bi bi-box-seam fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Average Order Value
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                PKR {{ $revenue_data->sum('orders') > 0 ? number_format($revenue_data->sum('revenue') / $revenue_data->sum('orders'), 2) : '0.00' }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="bi bi-calculator fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Active Agents
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $agent_performance->count() }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="bi bi-people fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .border-left-primary {
        border-left: 0.25rem solid #4e73df !important;
    }
    .border-left-success {
        border-left: 0.25rem solid #1cc88a !important;
    }
    .border-left-info {
        border-left: 0.25rem solid #36b9cc !important;
    }
    .border-left-warning {
        border-left: 0.25rem solid #f6c23e !important;
    }
    .text-xs {
        font-size: 0.7rem;
    }
    .fa-2x {
        font-size: 2em;
    }
    .text-gray-300 {
        color: #dddfeb !important;
    }
    .text-gray-800 {
        color: #5a5c69 !important;
    }
    .status-indicator {
        width: 12px;
        height: 12px;
        border-radius: 50%;
    }
    .card {
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        border: 1px solid #e3e6f0;
    }
    .card-header {
        background-color: #f8f9fa;
        border-bottom: 1px solid #e3e6f0;
    }
    .chart-container {
        position: relative;
    }
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Revenue Chart
    @if($revenue_data->count() > 0)
        const revenueCtx = document.getElementById('revenueChart').getContext('2d');
        const revenueChart = new Chart(revenueCtx, {
            type: 'line',
            data: {
                labels: [
                    @foreach($revenue_data as $data)
                        '{{ $data->date }}',
                    @endforeach
                ],
                datasets: [{
                    label: 'Revenue (PKR)',
                    data: [
                        @foreach($revenue_data as $data)
                            {{ $data->revenue }},
                        @endforeach
                    ],
                    borderColor: '#4e73df',
                    backgroundColor: 'rgba(78, 115, 223, 0.1)',
                    borderWidth: 3,
                    fill: true,
                    tension: 0.4
                }, {
                    label: 'Orders',
                    data: [
                        @foreach($revenue_data as $data)
                            {{ $data->orders }},
                        @endforeach
                    ],
                    borderColor: '#1cc88a',
                    backgroundColor: 'rgba(28, 200, 138, 0.1)',
                    borderWidth: 2,
                    fill: false,
                    yAxisID: 'y1'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        type: 'linear',
                        display: true,
                        position: 'left',
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return 'PKR ' + value.toLocaleString();
                            }
                        }
                    },
                    y1: {
                        type: 'linear',
                        display: true,
                        position: 'right',
                        beginAtZero: true,
                        grid: {
                            drawOnChartArea: false,
                        },
                    }
                },
                plugins: {
                    legend: {
                        display: true,
                        position: 'top'
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                if (context.datasetIndex === 0) {
                                    return 'Revenue: PKR ' + context.parsed.y.toLocaleString();
                                } else {
                                    return 'Orders: ' + context.parsed.y;
                                }
                            }
                        }
                    }
                }
            }
        });
    @endif
    
    // Status Chart
    @if($status_data->count() > 0)
        const statusCtx = document.getElementById('statusChart').getContext('2d');
        const statusChart = new Chart(statusCtx, {
            type: 'doughnut',
            data: {
                labels: [
                    @foreach($status_data as $status)
                        '{{ ucfirst(str_replace("_", " ", $status->status)) }}',
                    @endforeach
                ],
                datasets: [{
                    data: [
                        @foreach($status_data as $status)
                            {{ $status->count }},
                        @endforeach
                    ],
                    backgroundColor: [
                        @foreach($status_data as $status)
                            '{{ $status->status === "delivered" ? "#1cc88a" : 
                                ($status->status === "in_transit" ? "#36b9cc" : 
                                ($status->status === "picked" ? "#f6c23e" : 
                                ($status->status === "cancelled" ? "#e74a3b" : "#858796"))) }}',
                        @endforeach
                    ],
                    borderWidth: 2,
                    borderColor: '#fff'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                return context.label + ': ' + context.parsed + ' orders';
                            }
                        }
                    }
                }
            }
        });
    @endif
    
    function exportReports() {
        // Implement export functionality
        alert('Export functionality will be implemented soon!');
    }
</script>
@endpush