@extends('layouts.app')

@section('title', 'My Orders')

@section('content')
<div class="container py-4">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h2 class="fw-bold text-primary">
                    <i class="bi bi-box-seam"></i> My Orders
                </h2>
                <a href="{{ route('courier.create') }}" class="btn btn-primary">
                    <i class="bi bi-plus-circle"></i> New Order
                </a>
            </div>
            
            @if($orders->count() > 0)
                <div class="row g-4">
                    @foreach($orders as $order)
                        <div class="col-lg-6 col-xl-4">
                            <div class="card h-100 shadow-sm">
                                <div class="card-header bg-{{ $order->status_badge }} text-white">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <h6 class="mb-0">
                                            <i class="bi bi-truck"></i> 
                                            {{ $order->tracking_code }}
                                        </h6>
                                        <span class="badge bg-light text-dark">
                                            {{ ucfirst(str_replace('_', ' ', $order->status)) }}
                                        </span>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <!-- Route Information -->
                                    <div class="mb-3">
                                        <div class="d-flex align-items-center mb-2">
                                            <i class="bi bi-geo-alt text-primary me-2"></i>
                                            <small class="text-muted">From:</small>
                                        </div>
                                        <p class="mb-1 fw-bold">{{ $order->pickupDistrict->name }}</p>
                                        <small class="text-muted">{{ $order->pickupDistrict->province }}</small>
                                        
                                        <div class="text-center my-2">
                                            <i class="bi bi-arrow-down text-secondary"></i>
                                        </div>
                                        
                                        <div class="d-flex align-items-center mb-2">
                                            <i class="bi bi-geo-alt-fill text-success me-2"></i>
                                            <small class="text-muted">To:</small>
                                        </div>
                                        <p class="mb-1 fw-bold">{{ $order->dropDistrict->name }}</p>
                                        <small class="text-muted">{{ $order->dropDistrict->province }}</small>
                                    </div>
                                    
                                    <!-- Package Details -->
                                    <div class="mb-3">
                                        <div class="row g-2">
                                            <div class="col-6">
                                                <div class="text-center p-2 bg-light rounded">
                                                    <i class="bi bi-speedometer2 text-primary d-block mb-1"></i>
                                                    <small class="text-muted">Weight</small>
                                                    <div class="fw-bold small">{{ $order->weight }}kg</div>
                                                </div>
                                            </div>
                                            <div class="col-6">
                                                <div class="text-center p-2 bg-light rounded">
                                                    <i class="bi bi-tag text-warning d-block mb-1"></i>
                                                    <small class="text-muted">Category</small>
                                                    <div class="fw-bold small">{{ $order->category }}</div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Receiver Info -->
                                    <div class="mb-3">
                                        <small class="text-muted">Receiver:</small>
                                        <p class="mb-1 fw-bold">{{ $order->receiver_name }}</p>
                                        <small class="text-muted">{{ $order->receiver_phone }}</small>
                                    </div>
                                    
                                    <!-- Price & Payment -->
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <div>
                                            <small class="text-muted">Total Amount</small>
                                            <div class="fw-bold text-primary">PKR {{ number_format($order->final_price, 2) }}</div>
                                        </div>
                                        <div class="text-end">
                                            <small class="text-muted">Payment</small>
                                            <div class="small">
                                                <span class="badge bg-{{ $order->payment_status === 'paid' ? 'success' : ($order->payment_status === 'failed' ? 'danger' : 'warning') }}">
                                                    {{ ucfirst($order->payment_status) }}
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Order Date -->
                                    <div class="mb-3">
                                        <small class="text-muted">
                                            <i class="bi bi-calendar"></i> 
                                            Ordered: {{ $order->created_at->format('M d, Y - h:i A') }}
                                        </small>
                                    </div>
                                </div>
                                
                                <div class="card-footer bg-transparent">
                                    <div class="d-flex gap-2">
                                        <a href="{{ route('orders.show', $order) }}" class="btn btn-outline-primary btn-sm flex-fill">
                                            <i class="bi bi-eye"></i> View Details
                                        </a>
                                        <a href="{{ route('tracking.search') }}" 
                                           onclick="event.preventDefault(); document.getElementById('track-form-{{ $order->id }}').submit();" 
                                           class="btn btn-outline-success btn-sm flex-fill">
                                            <i class="bi bi-search"></i> Track
                                        </a>
                                        <form id="track-form-{{ $order->id }}" action="{{ route('tracking.search') }}" method="POST" style="display: none;">
                                            @csrf
                                            <input type="hidden" name="tracking_code" value="{{ $order->tracking_code }}">
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                
                <!-- Pagination -->
                <div class="d-flex justify-content-center mt-4">
                    {{ $orders->links() }}
                </div>
                
            @else
                <!-- Empty State -->
                <div class="text-center py-5">
                    <div class="mb-4">
                        <i class="bi bi-box-seam text-muted" style="font-size: 4rem;"></i>
                    </div>
                    <h4 class="text-muted mb-3">No Orders Yet</h4>
                    <p class="text-muted mb-4">You haven't placed any courier orders yet. Start by booking your first delivery!</p>
                    <a href="{{ route('courier.create') }}" class="btn btn-primary btn-lg">
                        <i class="bi bi-plus-circle"></i> Book Your First Order
                    </a>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .card {
        transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
    }
    .card:hover {
        transform: translateY(-2px);
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important;
    }
    .badge {
        font-size: 0.7rem;
    }
</style>
@endpush