@extends('layouts.app')

@section('title', 'Track Your Order')

@section('content')
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="text-center mb-5">
                <h1 class="display-5 fw-bold text-primary">
                    <i class="bi bi-search"></i> Track Your Order
                </h1>
                <p class="lead text-muted">Enter your tracking code to get real-time updates on your package delivery</p>
            </div>
            
            <div class="card shadow-lg">
                <div class="card-body p-5">
                    <form action="{{ route('tracking.search') }}" method="POST">
                        @csrf
                        <div class="mb-4">
                            <label for="tracking_code" class="form-label h5">Tracking Code</label>
                            <div class="input-group input-group-lg">
                                <span class="input-group-text bg-primary text-white">
                                    <i class="bi bi-qr-code"></i>
                                </span>
                                <input type="text" 
                                       class="form-control @error('tracking_code') is-invalid @enderror" 
                                       id="tracking_code" 
                                       name="tracking_code" 
                                       value="{{ old('tracking_code') }}"
                                       placeholder="Enter tracking code (e.g., TCS20250916001)" 
                                       required>
                                @error('tracking_code')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="form-text">
                                <i class="bi bi-info-circle"></i> 
                                Your tracking code was provided when you placed your order
                            </div>
                        </div>
                        
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="bi bi-search"></i> Track Package
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            
            <!-- Sample Tracking Codes for Demo -->
            <div class="card mt-4">
                <div class="card-header bg-light">
                    <h6 class="mb-0"><i class="bi bi-lightbulb"></i> Demo Tracking Codes</h6>
                </div>
                <div class="card-body">
                    <p class="small text-muted mb-2">For testing purposes, you can use these sample tracking codes:</p>
                    <div class="row">
                        <div class="col-md-6">
                            <code class="text-primary">TCS20250916001</code> - Sample Order 1<br>
                            <code class="text-primary">TCS20250916002</code> - Sample Order 2
                        </div>
                        <div class="col-md-6">
                            <code class="text-primary">TCS20250916003</code> - Sample Order 3<br>
                            <code class="text-primary">TCS20250916004</code> - Sample Order 4
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- How to Track Section -->
    <div class="row mt-5">
        <div class="col-lg-12">
            <div class="text-center mb-4">
                <h3 class="fw-bold">How to Track Your Package</h3>
            </div>
            
            <div class="row g-4">
                <div class="col-md-4">
                    <div class="card h-100 text-center border-0">
                        <div class="card-body">
                            <div class="mb-3">
                                <i class="bi bi-1-circle-fill text-primary" style="font-size: 3rem;"></i>
                            </div>
                            <h5 class="card-title">Enter Tracking Code</h5>
                            <p class="card-text text-muted">Input the tracking code you received via SMS or email when you placed your order.</p>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="card h-100 text-center border-0">
                        <div class="card-body">
                            <div class="mb-3">
                                <i class="bi bi-2-circle-fill text-success" style="font-size: 3rem;"></i>
                            </div>
                            <h5 class="card-title">View Status</h5>
                            <p class="card-text text-muted">Get real-time updates on your package location and delivery status.</p>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="card h-100 text-center border-0">
                        <div class="card-body">
                            <div class="mb-3">
                                <i class="bi bi-3-circle-fill text-warning" style="font-size: 3rem;"></i>
                            </div>
                            <h5 class="card-title">Stay Updated</h5>
                            <p class="card-text text-muted">Receive notifications via SMS and email for every status change.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .card {
        transition: transform 0.2s ease-in-out;
    }
    .card:hover {
        transform: translateY(-2px);
    }
</style>
@endpush