@extends('layouts.app')

@section('title', 'Tracking Result')

@section('content')
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <!-- Header -->
            <div class="text-center mb-4">
                <h2 class="fw-bold text-primary">
                    <i class="bi bi-box-seam"></i> Package Tracking Details
                </h2>
                <p class="text-muted">Tracking Code: <strong class="text-primary">{{ $order->tracking_code }}</strong></p>
            </div>
            
            <!-- Order Status Card -->
            <div class="card shadow-lg mb-4">
                <div class="card-header bg-{{ $order->status_badge }} text-white">
                    <div class="row align-items-center">
                        <div class="col">
                            <h4 class="mb-0">
                                <i class="bi bi-truck"></i> 
                                Status: {{ ucfirst(str_replace('_', ' ', $order->status)) }}
                            </h4>
                        </div>
                        <div class="col-auto">
                            <span class="badge bg-light text-dark fs-6">
                                {{ $order->payment_method === 'cod' ? 'Cash on Delivery' : ucfirst($order->payment_method) }}
                            </span>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Progress Timeline -->
                    <div class="row">
                        <div class="col-12">
                            <div class="timeline">
                                <div class="timeline-item {{ $order->status === 'created' || $order->status === 'picked' || $order->status === 'in_transit' || $order->status === 'delivered' ? 'completed' : '' }}">
                                    <div class="timeline-marker bg-success"></div>
                                    <div class="timeline-content">
                                        <h6 class="mb-1">Order Created</h6>
                                        <small class="text-muted">{{ $order->created_at->format('M d, Y - h:i A') }}</small>
                                    </div>
                                </div>
                                
                                <div class="timeline-item {{ $order->status === 'picked' || $order->status === 'in_transit' || $order->status === 'delivered' ? 'completed' : '' }}">
                                    <div class="timeline-marker {{ $order->picked_at ? 'bg-success' : 'bg-secondary' }}"></div>
                                    <div class="timeline-content">
                                        <h6 class="mb-1">Package Picked Up</h6>
                                        <small class="text-muted">
                                            {{ $order->picked_at ? $order->picked_at->format('M d, Y - h:i A') : 'Pending pickup' }}
                                        </small>
                                    </div>
                                </div>
                                
                                <div class="timeline-item {{ $order->status === 'in_transit' || $order->status === 'delivered' ? 'completed' : '' }}">
                                    <div class="timeline-marker {{ $order->status === 'in_transit' || $order->status === 'delivered' ? 'bg-success' : 'bg-secondary' }}"></div>
                                    <div class="timeline-content">
                                        <h6 class="mb-1">In Transit</h6>
                                        <small class="text-muted">
                                            {{ $order->status === 'in_transit' || $order->status === 'delivered' ? 'Package is on the way' : 'Waiting for pickup' }}
                                        </small>
                                    </div>
                                </div>
                                
                                <div class="timeline-item {{ $order->status === 'delivered' ? 'completed' : '' }}">
                                    <div class="timeline-marker {{ $order->delivered_at ? 'bg-success' : 'bg-secondary' }}"></div>
                                    <div class="timeline-content">
                                        <h6 class="mb-1">Delivered</h6>
                                        <small class="text-muted">
                                            {{ $order->delivered_at ? $order->delivered_at->format('M d, Y - h:i A') : 'Pending delivery' }}
                                        </small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Order Details -->
            <div class="row g-4">
                <!-- Sender & Receiver Info -->
                <div class="col-lg-6">
                    <div class="card h-100">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="bi bi-people"></i> Sender & Receiver</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12 mb-3">
                                    <h6 class="text-primary">Sender Information</h6>
                                    <p class="mb-1"><strong>{{ $order->sender_name }}</strong></p>
                                    <p class="mb-1"><i class="bi bi-telephone"></i> {{ $order->sender_phone }}</p>
                                    <p class="mb-0 text-muted"><i class="bi bi-geo-alt"></i> {{ $order->sender_address }}</p>
                                </div>
                                <div class="col-12">
                                    <h6 class="text-success">Receiver Information</h6>
                                    <p class="mb-1"><strong>{{ $order->receiver_name }}</strong></p>
                                    <p class="mb-1"><i class="bi bi-telephone"></i> {{ $order->receiver_phone }}</p>
                                    <p class="mb-0 text-muted"><i class="bi bi-geo-alt"></i> {{ $order->receiver_address }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Package Details -->
                <div class="col-lg-6">
                    <div class="card h-100">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="bi bi-box"></i> Package Details</h5>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-6">
                                    <div class="border rounded p-2 text-center">
                                        <i class="bi bi-speedometer2 text-primary d-block mb-1"></i>
                                        <small class="text-muted">Weight</small>
                                        <div class="fw-bold">{{ $order->weight }} kg</div>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="border rounded p-2 text-center">
                                        <i class="bi bi-arrows-fullscreen text-info d-block mb-1"></i>
                                        <small class="text-muted">Size</small>
                                        <div class="fw-bold">{{ $order->size }}</div>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="border rounded p-2 text-center">
                                        <i class="bi bi-tag text-warning d-block mb-1"></i>
                                        <small class="text-muted">Category</small>
                                        <div class="fw-bold">{{ $order->category }}</div>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="border rounded p-2 text-center">
                                        <i class="bi bi-truck text-success d-block mb-1"></i>
                                        <small class="text-muted">Vehicle</small>
                                        <div class="fw-bold">{{ ucfirst($order->vehicle_type) }}</div>
                                    </div>
                                </div>
                            </div>
                            
                            @if($order->description)
                                <div class="mt-3">
                                    <small class="text-muted">Description:</small>
                                    <p class="mb-0">{{ $order->description }}</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Route & Pricing -->
            <div class="row g-4 mt-2">
                <div class="col-lg-8">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="bi bi-map"></i> Delivery Route</h5>
                        </div>
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-md-5 text-center">
                                    <div class="p-3 bg-light rounded">
                                        <i class="bi bi-geo-alt-fill text-primary fs-3"></i>
                                        <h6 class="mt-2 mb-1">Pickup Location</h6>
                                        <p class="mb-0 fw-bold">{{ $order->pickupDistrict->name }}</p>
                                        <small class="text-muted">{{ $order->pickupDistrict->province }}</small>
                                    </div>
                                </div>
                                <div class="col-md-2 text-center">
                                    <i class="bi bi-arrow-right text-primary fs-2"></i>
                                </div>
                                <div class="col-md-5 text-center">
                                    <div class="p-3 bg-light rounded">
                                        <i class="bi bi-geo-alt-fill text-success fs-3"></i>
                                        <h6 class="mt-2 mb-1">Drop Location</h6>
                                        <p class="mb-0 fw-bold">{{ $order->dropDistrict->name }}</p>
                                        <small class="text-muted">{{ $order->dropDistrict->province }}</small>
                                    </div>
                                </div>
                            </div>
                            
                            @if($order->assignedOffice)
                                <div class="mt-3 p-2 bg-info bg-opacity-10 rounded">
                                    <small class="text-muted">Assigned Office:</small>
                                    <strong class="d-block">{{ $order->assignedOffice->name }}</strong>
                                    <small>{{ $order->assignedOffice->address }}</small>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-4">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="bi bi-currency-dollar"></i> Pricing</h5>
                        </div>
                        <div class="card-body">
                            <div class="d-flex justify-content-between mb-2">
                                <span>Delivery Type:</span>
                                <span class="fw-bold">{{ ucfirst(str_replace('_', ' ', $order->delivery_type)) }}</span>
                            </div>
                            <div class="d-flex justify-content-between mb-2">
                                <span>Payment Method:</span>
                                <span class="fw-bold">{{ $order->payment_method === 'cod' ? 'COD' : ucfirst($order->payment_method) }}</span>
                            </div>
                            <div class="d-flex justify-content-between mb-2">
                                <span>Payment Status:</span>
                                <span class="badge bg-{{ $order->payment_status === 'paid' ? 'success' : ($order->payment_status === 'failed' ? 'danger' : 'warning') }}">
                                    {{ ucfirst($order->payment_status) }}
                                </span>
                            </div>
                            <hr>
                            <div class="d-flex justify-content-between">
                                <span class="fw-bold">Total Amount:</span>
                                <span class="fw-bold text-primary fs-5">PKR {{ number_format($order->final_price, 2) }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Actions -->
            <div class="text-center mt-4">
                <a href="{{ route('tracking') }}" class="btn btn-outline-primary me-2">
                    <i class="bi bi-arrow-left"></i> Track Another Package
                </a>
                @auth
                    @if($order->user_id === auth()->id())
                        <a href="{{ route('orders.show', $order) }}" class="btn btn-primary">
                            <i class="bi bi-eye"></i> View Full Details
                        </a>
                    @endif
                @endauth
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .timeline {
        position: relative;
        padding-left: 30px;
    }
    
    .timeline::before {
        content: '';
        position: absolute;
        left: 15px;
        top: 0;
        bottom: 0;
        width: 2px;
        background: #dee2e6;
    }
    
    .timeline-item {
        position: relative;
        margin-bottom: 30px;
    }
    
    .timeline-item.completed::before {
        background: #28a745;
    }
    
    .timeline-marker {
        position: absolute;
        left: -22px;
        top: 0;
        width: 12px;
        height: 12px;
        border-radius: 50%;
        border: 2px solid #fff;
        box-shadow: 0 0 0 2px #dee2e6;
    }
    
    .timeline-item.completed .timeline-marker {
        box-shadow: 0 0 0 2px #28a745;
    }
    
    .timeline-content {
        padding-left: 20px;
    }
</style>
@endpush