<?php $__env->startSection('title', 'Tracking Result'); ?>

<?php $__env->startSection('content'); ?>
<!-- Tracking Header -->
<div class="mobile-card">
    <div class="mobile-card-header text-center">
        <h2 class="mb-2">
            <i class="bi bi-box-seam me-2"></i>
            Package Tracking
        </h2>
        <p class="mb-0 opacity-75"><?php echo e($order->tracking_code); ?></p>
    </div>
    <div class="mobile-card-body text-center">
        <div class="mb-3">
            <span class="badge bg-<?php echo e($order->status === 'delivered' ? 'success' : ($order->status === 'in_transit' ? 'info' : ($order->status === 'picked' ? 'warning' : 'secondary'))); ?> fs-5 px-4 py-2">
                <?php echo e(ucfirst(str_replace('_', ' ', $order->status))); ?>

            </span>
        </div>
        
        <?php if($order->status === 'delivered'): ?>
            <div class="alert alert-success alert-mobile">
                <i class="bi bi-check-circle me-2"></i>
                <strong>Package Delivered Successfully!</strong>
            </div>
        <?php elseif($order->status === 'in_transit'): ?>
            <div class="alert alert-info alert-mobile">
                <i class="bi bi-truck me-2"></i>
                <strong>Package is on the way!</strong>
            </div>
        <?php elseif($order->status === 'picked'): ?>
            <div class="alert alert-warning alert-mobile">
                <i class="bi bi-box-arrow-up me-2"></i>
                <strong>Package picked up from sender</strong>
            </div>
        <?php else: ?>
            <div class="alert alert-secondary alert-mobile">
                <i class="bi bi-clock me-2"></i>
                <strong>Package created, waiting for pickup</strong>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Package Details -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <h5 class="mb-4">
            <i class="bi bi-info-circle text-primary me-2"></i>
            Package Information
        </h5>
        
        <div class="row g-3 mb-4">
            <div class="col-6">
                <div class="bg-light rounded-3 p-3">
                    <small class="text-muted d-block mb-1">
                        <i class="bi bi-archive text-warning me-1"></i>Type
                    </small>
                    <strong><?php echo e(ucfirst($order->package_type)); ?></strong>
                </div>
            </div>
            <div class="col-6">
                <div class="bg-light rounded-3 p-3">
                    <small class="text-muted d-block mb-1">
                        <i class="bi bi-speedometer text-info me-1"></i>Weight
                    </small>
                    <strong><?php echo e($order->weight); ?> kg</strong>
                </div>
            </div>
        </div>
        
        <div class="row g-3 mb-4">
            <div class="col-6">
                <div class="bg-light rounded-3 p-3">
                    <small class="text-muted d-block mb-1">
                        <i class="bi bi-calendar text-secondary me-1"></i>Booked
                    </small>
                    <strong class="small"><?php echo e($order->created_at->format('M d, Y')); ?></strong>
                    <div class="text-muted small"><?php echo e($order->created_at->format('h:i A')); ?></div>
                </div>
            </div>
            <div class="col-6">
                <div class="bg-light rounded-3 p-3">
                    <small class="text-muted d-block mb-1">
                        <i class="bi bi-credit-card text-success me-1"></i>Amount
                    </small>
                    <strong class="text-success">Rs. <?php echo e(number_format($order->final_price)); ?></strong>
                    <div class="text-muted small"><?php echo e(ucfirst($order->payment_method)); ?></div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Route Information -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <h5 class="mb-4">
            <i class="bi bi-geo-alt text-danger me-2"></i>
            Delivery Route
        </h5>
        
        <div class="row g-3">
            <div class="col-12">
                <div class="d-flex align-items-start">
                    <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px; flex-shrink: 0;">
                        <i class="bi bi-geo-alt"></i>
                    </div>
                    <div class="flex-grow-1">
                        <h6 class="mb-1">Pickup Location</h6>
                        <strong><?php echo e($order->pickupDistrict->name); ?></strong>
                        <div class="text-muted small mt-1"><?php echo e($order->pickup_address); ?></div>
                    </div>
                </div>
            </div>
            
            <div class="col-12">
                <div class="d-flex justify-content-center">
                    <div class="border-start border-2 border-primary" style="height: 30px; margin-left: 20px;"></div>
                </div>
            </div>
            
            <div class="col-12">
                <div class="d-flex align-items-start">
                    <div class="bg-danger text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px; flex-shrink: 0;">
                        <i class="bi bi-geo-alt-fill"></i>
                    </div>
                    <div class="flex-grow-1">
                        <h6 class="mb-1">Delivery Location</h6>
                        <strong><?php echo e($order->dropDistrict->name); ?></strong>
                        <div class="text-muted small mt-1"><?php echo e($order->drop_address); ?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Recipient Information -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <h5 class="mb-4">
            <i class="bi bi-person text-info me-2"></i>
            Recipient Details
        </h5>
        
        <div class="row g-3">
            <div class="col-12">
                <div class="d-flex align-items-center p-3 bg-light rounded-3">
                    <div class="bg-info text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                        <i class="bi bi-person"></i>
                    </div>
                    <div>
                        <h6 class="mb-1"><?php echo e($order->recipient_name); ?></h6>
                        <div class="text-muted">
                            <i class="bi bi-telephone me-1"></i>
                            <?php echo e($order->recipient_phone); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php if($order->assignedAgent): ?>
<!-- Agent Information -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <h5 class="mb-4">
            <i class="bi bi-person-badge text-warning me-2"></i>
            Delivery Agent
        </h5>
        
        <div class="row g-3">
            <div class="col-12">
                <div class="d-flex align-items-center p-3 bg-light rounded-3">
                    <div class="bg-warning text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                        <i class="bi bi-person-badge"></i>
                    </div>
                    <div class="flex-grow-1">
                        <h6 class="mb-1"><?php echo e($order->assignedAgent->user->name); ?></h6>
                        <div class="text-muted small">
                            <i class="bi bi-telephone me-1"></i>
                            <?php echo e($order->assignedAgent->user->phone ?? 'Contact through office'); ?>

                        </div>
                        <div class="text-muted small">
                            <i class="bi bi-geo-alt me-1"></i>
                            Agent ID: <?php echo e($order->assignedAgent->agent_id); ?>

                        </div>
                    </div>
                    <div>
                        <a href="tel:<?php echo e($order->assignedAgent->user->phone); ?>" class="btn btn-sm btn-outline-warning">
                            <i class="bi bi-telephone"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php if($order->special_instructions): ?>
<!-- Special Instructions -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <h5 class="mb-3">
            <i class="bi bi-chat-text text-secondary me-2"></i>
            Special Instructions
        </h5>
        <div class="bg-light rounded-3 p-3">
            <p class="mb-0"><?php echo e($order->special_instructions); ?></p>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Tracking Timeline -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <h5 class="mb-4">
            <i class="bi bi-clock-history text-secondary me-2"></i>
            Tracking Timeline
        </h5>
        
        <div class="timeline">
            <div class="timeline-item <?php echo e($order->status === 'delivered' ? 'completed' : ($order->status === 'in_transit' ? 'active' : ($order->status === 'picked' ? 'completed' : ($order->status === 'created' ? 'active' : '')))); ?>">
                <div class="timeline-marker">
                    <i class="bi bi-plus-circle"></i>
                </div>
                <div class="timeline-content">
                    <h6>Order Created</h6>
                    <p class="text-muted small mb-1">Package booking confirmed</p>
                    <small class="text-muted"><?php echo e($order->created_at->format('M d, Y h:i A')); ?></small>
                </div>
            </div>
            
            <div class="timeline-item <?php echo e($order->status === 'delivered' ? 'completed' : ($order->status === 'in_transit' ? 'completed' : ($order->status === 'picked' ? 'active' : ''))); ?>">
                <div class="timeline-marker">
                    <i class="bi bi-box-arrow-up"></i>
                </div>
                <div class="timeline-content">
                    <h6>Package Picked Up</h6>
                    <p class="text-muted small mb-1">Collected from sender</p>
                    <?php if($order->status !== 'created'): ?>
                        <small class="text-muted"><?php echo e($order->updated_at->format('M d, Y h:i A')); ?></small>
                    <?php else: ?>
                        <small class="text-muted">Pending</small>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="timeline-item <?php echo e($order->status === 'delivered' ? 'completed' : ($order->status === 'in_transit' ? 'active' : '')); ?>">
                <div class="timeline-marker">
                    <i class="bi bi-truck"></i>
                </div>
                <div class="timeline-content">
                    <h6>In Transit</h6>
                    <p class="text-muted small mb-1">On the way to destination</p>
                    <?php if(in_array($order->status, ['in_transit', 'delivered'])): ?>
                        <small class="text-muted"><?php echo e($order->updated_at->format('M d, Y h:i A')); ?></small>
                    <?php else: ?>
                        <small class="text-muted">Pending</small>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="timeline-item <?php echo e($order->status === 'delivered' ? 'completed active' : ''); ?>">
                <div class="timeline-marker">
                    <i class="bi bi-check-circle"></i>
                </div>
                <div class="timeline-content">
                    <h6>Delivered</h6>
                    <p class="text-muted small mb-1">Package delivered successfully</p>
                    <?php if($order->status === 'delivered'): ?>
                        <small class="text-muted"><?php echo e($order->updated_at->format('M d, Y h:i A')); ?></small>
                    <?php else: ?>
                        <small class="text-muted">Pending</small>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Actions -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <div class="row g-3">
            <div class="col-6">
                <a href="<?php echo e(route('tracking')); ?>" class="btn btn-mobile btn-mobile-secondary w-100">
                    <i class="bi bi-arrow-left me-2"></i>
                    Track Another
                </a>
            </div>
            <div class="col-6">
                <button class="btn btn-mobile btn-mobile-primary w-100" onclick="shareTracking()">
                    <i class="bi bi-share me-2"></i>
                    Share
                </button>
            </div>
        </div>
        
        <?php if(auth()->guard()->check()): ?>
            <?php if($order->user_id === auth()->id()): ?>
                <div class="row g-3 mt-2">
                    <div class="col-6">
                        <a href="<?php echo e(route('orders.show', $order)); ?>" class="btn btn-outline-info w-100">
                            <i class="bi bi-eye me-2"></i>
                            View Details
                        </a>
                    </div>
                    <div class="col-6">
                        <a href="<?php echo e(route('orders.index')); ?>" class="btn btn-outline-success w-100">
                            <i class="bi bi-box-seam me-2"></i>
                            My Orders
                        </a>
                    </div>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<!-- Support -->
<div class="mobile-card">
    <div class="mobile-card-body text-center">
        <h6 class="mb-3">
            <i class="bi bi-headset text-primary me-2"></i>
            Need Help?
        </h6>
        <div class="row g-2">
            <div class="col-6">
                <a href="tel:+923001234567" class="btn btn-outline-success w-100">
                    <i class="bi bi-telephone"></i>
                    <br>
                    <small>Call Support</small>
                </a>
            </div>
            <div class="col-6">
                <a href="mailto:support@tcscourier.com" class="btn btn-outline-info w-100">
                    <i class="bi bi-envelope"></i>
                    <br>
                    <small>Email Support</small>
                </a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .timeline {
        position: relative;
        padding-left: 30px;
    }
    
    .timeline::before {
        content: '';
        position: absolute;
        left: 20px;
        top: 0;
        bottom: 0;
        width: 2px;
        background: var(--gray-300);
    }
    
    .timeline-item {
        position: relative;
        margin-bottom: 30px;
    }
    
    .timeline-item:last-child {
        margin-bottom: 0;
    }
    
    .timeline-marker {
        position: absolute;
        left: -30px;
        top: 0;
        width: 40px;
        height: 40px;
        background: var(--gray-300);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 1rem;
        z-index: 1;
    }
    
    .timeline-item.completed .timeline-marker {
        background: var(--success-color);
    }
    
    .timeline-item.active .timeline-marker {
        background: var(--primary-color);
        animation: pulse 2s infinite;
    }
    
    .timeline-content h6 {
        margin-bottom: 5px;
        color: var(--dark-color);
    }
    
    .timeline-item.completed .timeline-content h6 {
        color: var(--success-color);
    }
    
    .timeline-item.active .timeline-content h6 {
        color: var(--primary-color);
        font-weight: 600;
    }
    
    @keyframes  pulse {
        0% {
            box-shadow: 0 0 0 0 rgba(78, 115, 223, 0.7);
        }
        70% {
            box-shadow: 0 0 0 10px rgba(78, 115, 223, 0);
        }
        100% {
            box-shadow: 0 0 0 0 rgba(78, 115, 223, 0);
        }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Share tracking information
    function shareTracking() {
        const trackingCode = '<?php echo e($order->tracking_code); ?>';
        const status = '<?php echo e(ucfirst(str_replace("_", " ", $order->status))); ?>';
        const shareText = `Track my TCS Courier package: ${trackingCode}\nStatus: ${status}\n\nTrack at: ${window.location.origin}/tracking`;
        
        if (navigator.share) {
            navigator.share({
                title: 'TCS Courier Tracking',
                text: shareText,
                url: window.location.href
            }).catch(err => {
                console.log('Error sharing:', err);
                fallbackShare(shareText);
            });
        } else {
            fallbackShare(shareText);
        }
    }
    
    function fallbackShare(text) {
        if (navigator.clipboard) {
            navigator.clipboard.writeText(text).then(() => {
                alert('Tracking information copied to clipboard!');
            }).catch(() => {
                promptShare(text);
            });
        } else {
            promptShare(text);
        }
    }
    
    function promptShare(text) {
        const textarea = document.createElement('textarea');
        textarea.value = text;
        document.body.appendChild(textarea);
        textarea.select();
        document.execCommand('copy');
        document.body.removeChild(textarea);
        alert('Tracking information copied to clipboard!');
    }
    
    // Auto-refresh tracking status every 30 seconds
    let refreshInterval;
    
    function startAutoRefresh() {
        refreshInterval = setInterval(() => {
            if ('<?php echo e($order->status); ?>' !== 'delivered') {
                // Only refresh if not delivered
                window.location.reload();
            } else {
                clearInterval(refreshInterval);
            }
        }, 30000); // 30 seconds
    }
    
    // Start auto-refresh when page loads
    document.addEventListener('DOMContentLoaded', function() {
        if ('<?php echo e($order->status); ?>' !== 'delivered') {
            startAutoRefresh();
        }
    });
    
    // Stop auto-refresh when page is hidden
    document.addEventListener('visibilitychange', function() {
        if (document.hidden) {
            clearInterval(refreshInterval);
        } else if ('<?php echo e($order->status); ?>' !== 'delivered') {
            startAutoRefresh();
        }
    });
    
    // Add haptic feedback to buttons
    document.querySelectorAll('.btn').forEach(button => {
        button.addEventListener('click', function() {
            if ('vibrate' in navigator) {
                navigator.vibrate(50);
            }
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.mobile', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\ASC\Desktop\Trae Projects\TCS Web app\resources\views/mobile/tracking/result.blade.php ENDPATH**/ ?>