<?php $__env->startSection('title', 'Edit Agent'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">
                <i class="bi bi-person-gear text-primary"></i> Edit Agent
            </h1>
            <p class="text-muted mb-0">Update agent information and settings</p>
        </div>
        <div>
            <a href="<?php echo e(route('admin.agents')); ?>" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left"></i> Back to Agents
            </a>
        </div>
    </div>
    
    <!-- Agent Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <div class="text-white-50 small">Agent Code</div>
                            <div class="h5 mb-0"><?php echo e($agent->agent_code); ?></div>
                        </div>
                        <div class="align-self-center">
                            <i class="bi bi-person-badge fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <div class="text-white-50 small">Status</div>
                            <div class="h5 mb-0"><?php echo e($agent->is_active ? 'Active' : 'Inactive'); ?></div>
                        </div>
                        <div class="align-self-center">
                            <i class="bi bi-<?php echo e($agent->is_active ? 'check-circle' : 'x-circle'); ?> fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <div class="text-white-50 small">Office</div>
                            <div class="h6 mb-0"><?php echo e($agent->office->name ?? 'N/A'); ?></div>
                        </div>
                        <div class="align-self-center">
                            <i class="bi bi-building fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <div class="text-white-50 small">Vehicle</div>
                            <div class="h6 mb-0"><?php echo e(ucfirst($agent->vehicle_type)); ?></div>
                        </div>
                        <div class="align-self-center">
                            <i class="bi bi-truck fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Edit Agent Form -->
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card shadow">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-person-gear"></i> Agent Information</h5>
                </div>
                <div class="card-body">
                    <form method="POST" action="<?php echo e(route('admin.agents.update', $agent)); ?>">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        
                        <!-- User Information (Read-only) -->
                        <div class="mb-4">
                            <label class="form-label">Agent User</label>
                            <div class="form-control-plaintext bg-light p-3 rounded">
                                <strong><?php echo e($agent->user->name); ?></strong> (<?php echo e($agent->user->email); ?>)
                                <br><small class="text-muted">User information cannot be changed</small>
                            </div>
                        </div>
                        
                        <!-- Office Information (Read-only) -->
                        <div class="mb-4">
                            <label class="form-label">Assigned Office</label>
                            <div class="form-control-plaintext bg-light p-3 rounded">
                                <strong><?php echo e($agent->office->name ?? 'N/A'); ?></strong>
                                <?php if($agent->office): ?>
                                    - <?php echo e($agent->office->district->name ?? ''); ?>

                                    <br><small class="text-muted"><?php echo e($agent->office->address ?? ''); ?></small>
                                <?php endif; ?>
                                <br><small class="text-muted">Office assignment cannot be changed here</small>
                            </div>
                        </div>
                        
                        <!-- Agent Code (Read-only) -->
                        <div class="mb-4">
                            <label class="form-label">Agent Code</label>
                            <div class="form-control-plaintext bg-light p-3 rounded">
                                <strong><?php echo e($agent->agent_code); ?></strong>
                                <br><small class="text-muted">Agent code cannot be modified</small>
                            </div>
                        </div>
                        
                        <div class="row">
                            <!-- Phone -->
                            <div class="col-md-6 mb-3">
                                <label for="phone" class="form-label">Phone Number <span class="text-danger">*</span></label>
                                <input type="tel" class="form-control <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="phone" name="phone" value="<?php echo e(old('phone', $agent->phone)); ?>" 
                                       placeholder="+92-300-1234567" required>
                                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            
                            <!-- Vehicle Type -->
                            <div class="col-md-6 mb-3">
                                <label for="vehicle_type" class="form-label">Vehicle Type <span class="text-danger">*</span></label>
                                <select class="form-select <?php $__errorArgs = ['vehicle_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="vehicle_type" name="vehicle_type" required>
                                    <option value="">Select vehicle type...</option>
                                    <option value="bike" <?php echo e(old('vehicle_type', $agent->vehicle_type) == 'bike' ? 'selected' : ''); ?>>Bike</option>
                                    <option value="car" <?php echo e(old('vehicle_type', $agent->vehicle_type) == 'car' ? 'selected' : ''); ?>>Car</option>
                                    <option value="van" <?php echo e(old('vehicle_type', $agent->vehicle_type) == 'van' ? 'selected' : ''); ?>>Van</option>
                                    <option value="truck" <?php echo e(old('vehicle_type', $agent->vehicle_type) == 'truck' ? 'selected' : ''); ?>>Truck</option>
                                </select>
                                <?php $__errorArgs = ['vehicle_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <!-- Address -->
                        <div class="mb-3">
                            <label for="address" class="form-label">Address <span class="text-danger">*</span></label>
                            <textarea class="form-control <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      id="address" name="address" rows="3" 
                                      placeholder="Complete address of the agent" required><?php echo e(old('address', $agent->address)); ?></textarea>
                            <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <!-- License Number -->
                        <div class="mb-3">
                            <label for="license_number" class="form-label">License Number <span class="text-danger">*</span></label>
                            <input type="text" class="form-control <?php $__errorArgs = ['license_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="license_number" name="license_number" value="<?php echo e(old('license_number', $agent->license_number)); ?>" 
                                   placeholder="e.g., LHR-123456" required>
                            <?php $__errorArgs = ['license_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <!-- Status -->
                        <div class="mb-4">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="is_active" name="is_active" 
                                       <?php echo e(old('is_active', $agent->is_active) ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="is_active">
                                    <strong>Active Agent</strong>
                                    <small class="text-muted d-block">Agent can receive order assignments</small>
                                </label>
                            </div>
                        </div>
                        
                        <!-- Submit Buttons -->
                        <div class="d-flex justify-content-end gap-2">
                            <a href="<?php echo e(route('admin.agents')); ?>" class="btn btn-secondary">
                                <i class="bi bi-x-circle"></i> Cancel
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-check-circle"></i> Update Agent
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            
            <!-- Quick Actions -->
            <div class="card shadow mt-4">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-lightning"></i> Quick Actions</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <a href="#" class="btn btn-outline-info w-100 mb-2">
                                <i class="bi bi-eye"></i> View Orders
                            </a>
                        </div>
                        <div class="col-md-4">
                            <a href="#" class="btn btn-outline-warning w-100 mb-2">
                                <i class="bi bi-graph-up"></i> Performance
                            </a>
                        </div>
                        <div class="col-md-4">
                            <button type="button" class="btn btn-outline-danger w-100 mb-2" onclick="confirmDeactivate()">
                                <i class="bi bi-person-x"></i> Deactivate
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .card {
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        border: 1px solid #e3e6f0;
    }
    
    .card-header {
        background-color: #f8f9fa;
        border-bottom: 1px solid #e3e6f0;
    }
    
    .form-label {
        font-weight: 600;
        color: #5a5c69;
    }
    
    .text-danger {
        font-size: 0.9rem;
    }
    
    .form-text {
        font-size: 0.8rem;
    }
    
    .btn {
        font-weight: 500;
    }
    
    .form-control-plaintext {
        border: 1px solid #e3e6f0;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Phone number formatting
    document.getElementById('phone').addEventListener('input', function(e) {
        let value = e.target.value.replace(/\D/g, '');
        if (value.length > 0) {
            if (value.startsWith('92')) {
                value = '+' + value;
            } else if (!value.startsWith('+92')) {
                value = '+92' + value;
            }
        }
        e.target.value = value;
    });
    
    // Form validation
    document.querySelector('form').addEventListener('submit', function(e) {
        const requiredFields = ['phone', 'address', 'vehicle_type', 'license_number'];
        let isValid = true;
        
        requiredFields.forEach(field => {
            const input = document.getElementById(field);
            if (!input.value.trim()) {
                input.classList.add('is-invalid');
                isValid = false;
            } else {
                input.classList.remove('is-invalid');
            }
        });
        
        if (!isValid) {
            e.preventDefault();
            alert('Please fill in all required fields.');
        }
    });
    
    // Confirm deactivation
    function confirmDeactivate() {
        if (confirm('Are you sure you want to deactivate this agent? They will no longer receive order assignments.')) {
            // Add deactivation logic here
            document.getElementById('is_active').checked = false;
            alert('Agent status updated. Please save the form to apply changes.');
        }
    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/khanozai/portal.topcourierservice.com.pk/resources/views/admin/agents/edit.blade.php ENDPATH**/ ?>