<?php $__env->startSection('title', 'Edit User - ' . $user->name); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">
                <i class="bi bi-person-gear text-primary"></i> Edit User
            </h1>
            <p class="text-muted mb-0">Update user information and assign roles: <strong><?php echo e($user->name); ?></strong></p>
        </div>
        <div>
            <a href="<?php echo e(route('admin.users')); ?>" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left"></i> Back to Users
            </a>
        </div>
    </div>
    
    <!-- Edit User Form -->
    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-person"></i> User Information & Role Assignment</h5>
                </div>
                <div class="card-body">
                    <form method="POST" action="<?php echo e(route('admin.users.update', $user)); ?>">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        
                        <!-- Name -->
                        <div class="mb-4">
                            <label for="name" class="form-label">Full Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="name" name="name" value="<?php echo e(old('name', $user->name)); ?>" required>
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <!-- Email -->
                        <div class="mb-4">
                            <label for="email" class="form-label">Email Address <span class="text-danger">*</span></label>
                            <input type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="email" name="email" value="<?php echo e(old('email', $user->email)); ?>" required>
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <!-- Phone -->
                        <div class="mb-4">
                            <label for="phone" class="form-label">Phone Number</label>
                            <input type="tel" class="form-control <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="phone" name="phone" value="<?php echo e(old('phone', $user->phone)); ?>" 
                                   placeholder="+92-300-1234567">
                            <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <!-- Role Assignment -->
                        <div class="mb-4">
                            <label for="role" class="form-label">User Role <span class="text-danger">*</span></label>
                            <select class="form-select <?php $__errorArgs = ['role'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="role" name="role" required>
                                <option value="">Select user role...</option>
                                <option value="customer" <?php echo e(old('role', $user->role) == 'customer' ? 'selected' : ''); ?>>Customer</option>
                                <option value="agent" <?php echo e(old('role', $user->role) == 'agent' ? 'selected' : ''); ?>>Agent</option>
                                <option value="admin" <?php echo e(old('role', $user->role) == 'admin' ? 'selected' : ''); ?>>Admin</option>
                            </select>
                            <?php $__errorArgs = ['role'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <small class="form-text text-muted">Choose the appropriate role for this user</small>
                        </div>
                        
                        <!-- Role Information -->
                        <div class="alert alert-info" role="alert" id="roleInfo" style="display: none;">
                            <h6 class="alert-heading">
                                <i class="bi bi-info-circle"></i> Role Information
                            </h6>
                            <div id="roleDescription"></div>
                        </div>
                        
                        <!-- Status -->
                        <div class="mb-4">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="is_active" name="is_active" 
                                       <?php echo e(old('is_active', $user->is_active) ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="is_active">
                                    <strong>Active User</strong>
                                    <small class="text-muted d-block">User can login and access the system</small>
                                </label>
                            </div>
                        </div>
                        
                        <!-- Warning for role changes -->
                        <?php if($user->role === 'agent' && $user->agent && $user->agent->assignedOrders()->count() > 0): ?>
                            <div class="alert alert-warning" role="alert">
                                <h6 class="alert-heading">
                                    <i class="bi bi-exclamation-triangle"></i> Agent Role Warning
                                </h6>
                                <p class="mb-2">This user is currently an agent with:</p>
                                <ul class="mb-2 small">
                                    <li><?php echo e($user->agent->assignedOrders()->count()); ?> assigned orders</li>
                                    <li>Agent Code: <?php echo e($user->agent->agent_code); ?></li>
                                    <li>Vehicle: <?php echo e(ucfirst($user->agent->vehicle_type)); ?></li>
                                </ul>
                                <p class="mb-0 small">Changing the role from 'Agent' may affect order assignments and delivery operations.</p>
                            </div>
                        <?php endif; ?>
                        
                        <!-- Submit Buttons -->
                        <div class="d-flex justify-content-end gap-2">
                            <a href="<?php echo e(route('admin.users')); ?>" class="btn btn-secondary">
                                <i class="bi bi-x-circle"></i> Cancel
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-check-circle"></i> Update User
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <!-- User Statistics -->
        <div class="col-lg-4">
            <div class="card shadow">
                <div class="card-header">
                    <h6 class="mb-0"><i class="bi bi-graph-up"></i> User Statistics</h6>
                </div>
                <div class="card-body text-center">
                    <div class="user-avatar-large bg-<?php echo e($user->role === 'admin' ? 'danger' : ($user->role === 'agent' ? 'warning' : 'primary')); ?> text-white mb-3">
                        <?php echo e(strtoupper(substr($user->name, 0, 2))); ?>

                    </div>
                    <h5 class="mb-1"><?php echo e($user->name); ?></h5>
                    <p class="text-muted mb-3"><?php echo e($user->email); ?></p>
                    
                    <div class="row text-center">
                        <div class="col-12 mb-3">
                            <div class="border rounded p-3">
                                <div class="h4 text-primary mb-1"><?php echo e($user->orders()->count()); ?></div>
                                <small class="text-muted">Total Orders</small>
                            </div>
                        </div>
                        <?php if($user->agent): ?>
                            <div class="col-6">
                                <div class="border rounded p-2">
                                    <div class="h6 text-success mb-1"><?php echo e($user->agent->assignedOrders()->count()); ?></div>
                                    <small class="text-muted">Assigned</small>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="border rounded p-2">
                                    <div class="h6 text-info mb-1"><?php echo e($user->agent->assignedOrders()->where('status', 'delivered')->count()); ?></div>
                                    <small class="text-muted">Delivered</small>
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="col-6">
                                <div class="border rounded p-2">
                                    <div class="h6 text-success mb-1"><?php echo e($user->orders()->where('status', 'delivered')->count()); ?></div>
                                    <small class="text-muted">Delivered</small>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="border rounded p-2">
                                    <div class="h6 text-warning mb-1"><?php echo e($user->orders()->whereIn('status', ['created', 'picked', 'in_transit'])->count()); ?></div>
                                    <small class="text-muted">Active</small>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            
            <!-- User Information -->
            <div class="card shadow mt-4">
                <div class="card-header">
                    <h6 class="mb-0"><i class="bi bi-info-circle"></i> Account Details</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <strong>Current Role:</strong>
                        <span class="badge bg-<?php echo e($user->role === 'admin' ? 'danger' : ($user->role === 'agent' ? 'warning' : 'primary')); ?> ms-2">
                            <?php echo e(ucfirst($user->role)); ?>

                        </span>
                    </div>
                    <div class="mb-3">
                        <strong>Status:</strong>
                        <span class="badge bg-<?php echo e($user->is_active ? 'success' : 'danger'); ?> ms-2">
                            <?php echo e($user->is_active ? 'Active' : 'Inactive'); ?>

                        </span>
                    </div>
                    <div class="mb-3">
                        <strong>Member Since:</strong>
                        <br><small class="text-muted"><?php echo e($user->created_at->format('M d, Y h:i A')); ?></small>
                    </div>
                    <div class="mb-3">
                        <strong>Last Updated:</strong>
                        <br><small class="text-muted"><?php echo e($user->updated_at->format('M d, Y h:i A')); ?></small>
                    </div>
                    <div class="mb-0">
                        <strong>User ID:</strong>
                        <br><small class="text-muted">#<?php echo e($user->id); ?></small>
                    </div>
                </div>
            </div>
            
            <!-- Quick Actions -->
            <div class="card shadow mt-4">
                <div class="card-header">
                    <h6 class="mb-0"><i class="bi bi-lightning"></i> Quick Actions</h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <?php if($user->orders()->count() > 0): ?>
                            <a href="<?php echo e(route('admin.orders')); ?>?search=<?php echo e($user->email); ?>" class="btn btn-outline-info btn-sm">
                                <i class="bi bi-box-seam"></i> View User Orders
                            </a>
                        <?php endif; ?>
                        <?php if($user->role === 'agent' && $user->agent): ?>
                            <a href="<?php echo e(route('admin.agents.edit', $user->agent)); ?>" class="btn btn-outline-warning btn-sm">
                                <i class="bi bi-person-badge"></i> Edit Agent Profile
                            </a>
                        <?php endif; ?>
                        <button type="button" class="btn btn-outline-<?php echo e($user->is_active ? 'warning' : 'success'); ?> btn-sm" 
                                onclick="toggleUserStatus(<?php echo e($user->id); ?>, <?php echo e($user->is_active ? 'false' : 'true'); ?>)">
                            <i class="bi bi-<?php echo e($user->is_active ? 'pause' : 'play'); ?>"></i> <?php echo e($user->is_active ? 'Deactivate' : 'Activate'); ?> User
                        </button>
                        <?php if($user->role !== 'admin' && $user->orders()->count() == 0): ?>
                            <button type="button" class="btn btn-outline-danger btn-sm" onclick="deleteUser(<?php echo e($user->id); ?>)">
                                <i class="bi bi-trash"></i> Delete User
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .user-avatar-large {
        width: 80px;
        height: 80px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 2rem;
        font-weight: bold;
        margin: 0 auto;
    }
    
    .card {
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        border: 1px solid #e3e6f0;
    }
    
    .card-header {
        background-color: #f8f9fa;
        border-bottom: 1px solid #e3e6f0;
    }
    
    .form-label {
        font-weight: 600;
        color: #5a5c69;
    }
    
    .text-danger {
        font-size: 0.9rem;
    }
    
    .form-text {
        font-size: 0.8rem;
    }
    
    .btn {
        font-weight: 500;
    }
    
    .alert {
        border-left: 4px solid #17a2b8;
    }
    
    .alert-warning {
        border-left-color: #f6c23e;
    }
    
    .alert-heading {
        font-size: 1rem;
        margin-bottom: 0.5rem;
    }
    
    .form-control:focus, .form-select:focus {
        border-color: #4e73df;
        box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Role information descriptions
    const roleDescriptions = {
        'customer': {
            title: 'Customer Role',
            description: '<ul class="mb-0 small"><li>Can book courier services</li><li>Can track their orders</li><li>Can view order history</li><li>Cannot access admin features</li></ul>'
        },
        'agent': {
            title: 'Agent Role',
            description: '<ul class="mb-0 small"><li>Can be assigned delivery orders</li><li>Can update order status</li><li>Requires agent profile setup</li><li>Cannot access admin features</li></ul>'
        },
        'admin': {
            title: 'Admin Role',
            description: '<ul class="mb-0 small"><li>Full system access</li><li>Can manage all users and roles</li><li>Can manage orders and agents</li><li>Can view reports and analytics</li></ul>'
        }
    };
    
    // Show role information
    function showRoleInfo(role) {
        const roleInfo = document.getElementById('roleInfo');
        const roleDescription = document.getElementById('roleDescription');
        
        if (role && roleDescriptions[role]) {
            roleDescription.innerHTML = `<strong>${roleDescriptions[role].title}:</strong><br>${roleDescriptions[role].description}`;
            roleInfo.style.display = 'block';
        } else {
            roleInfo.style.display = 'none';
        }
    }
    
    // Role change handler
    document.getElementById('role').addEventListener('change', function() {
        showRoleInfo(this.value);
    });
    
    // Show initial role info
    showRoleInfo(document.getElementById('role').value);
    
    // Form validation
    document.querySelector('form').addEventListener('submit', function(e) {
        const requiredFields = ['name', 'email', 'role'];
        let isValid = true;
        
        requiredFields.forEach(field => {
            const input = document.getElementById(field);
            if (!input.value.trim()) {
                input.classList.add('is-invalid');
                isValid = false;
            } else {
                input.classList.remove('is-invalid');
            }
        });
        
        if (!isValid) {
            e.preventDefault();
            alert('Please fill in all required fields.');
        }
    });
    
    // Real-time validation feedback
    document.querySelectorAll('input, select').forEach(field => {
        field.addEventListener('input', function() {
            if (this.value.trim()) {
                this.classList.remove('is-invalid');
                this.classList.add('is-valid');
            }
        });
        
        field.addEventListener('change', function() {
            if (this.value.trim()) {
                this.classList.remove('is-invalid');
                this.classList.add('is-valid');
            }
        });
    });
    
    // Auto-format phone number
    document.getElementById('phone').addEventListener('input', function(e) {
        let value = e.target.value.replace(/\D/g, '');
        if (value.length > 0) {
            if (value.startsWith('92')) {
                value = '+' + value;
            } else if (!value.startsWith('+92')) {
                value = '+92' + value;
            }
        }
        e.target.value = value;
    });
    
    // Toggle user status function
    function toggleUserStatus(userId, newStatus) {
        if (confirm('Are you sure you want to ' + (newStatus ? 'activate' : 'deactivate') + ' this user?')) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = '/admin/users/' + userId + '/toggle-status';
            
            const csrfToken = document.createElement('input');
            csrfToken.type = 'hidden';
            csrfToken.name = '_token';
            csrfToken.value = '<?php echo e(csrf_token()); ?>';
            form.appendChild(csrfToken);
            
            const methodField = document.createElement('input');
            methodField.type = 'hidden';
            methodField.name = '_method';
            methodField.value = 'PATCH';
            form.appendChild(methodField);
            
            const statusField = document.createElement('input');
            statusField.type = 'hidden';
            statusField.name = 'is_active';
            statusField.value = newStatus;
            form.appendChild(statusField);
            
            document.body.appendChild(form);
            form.submit();
        }
    }
    
    // Delete user function
    function deleteUser(userId) {
        if (confirm('Are you sure you want to delete this user? This action cannot be undone.')) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = '/admin/users/' + userId;
            
            const csrfToken = document.createElement('input');
            csrfToken.type = 'hidden';
            csrfToken.name = '_token';
            csrfToken.value = '<?php echo e(csrf_token()); ?>';
            form.appendChild(csrfToken);
            
            const methodField = document.createElement('input');
            methodField.type = 'hidden';
            methodField.name = '_method';
            methodField.value = 'DELETE';
            form.appendChild(methodField);
            
            document.body.appendChild(form);
            form.submit();
        }
    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/khanozai/portal.topcourierservice.com.pk/resources/views/admin/users/edit.blade.php ENDPATH**/ ?>