<?php $__env->startSection('title', 'Admin Reports'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">
                <i class="bi bi-graph-up text-primary"></i> Reports & Analytics
            </h1>
            <p class="text-muted mb-0">Business insights and performance metrics</p>
        </div>
        <div>
            <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left"></i> Back to Dashboard
            </a>
        </div>
    </div>
    
    <!-- Date Range Filter -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="bi bi-calendar-range"></i> Date Range Filter
            </h6>
        </div>
        <div class="card-body">
            <form method="GET" action="<?php echo e(route('admin.reports')); ?>">
                <div class="row g-3">
                    <div class="col-md-3">
                        <label for="start_date" class="form-label">Start Date</label>
                        <input type="date" class="form-control" id="start_date" name="start_date" 
                               value="<?php echo e($startDate); ?>">
                    </div>
                    <div class="col-md-3">
                        <label for="end_date" class="form-label">End Date</label>
                        <input type="date" class="form-control" id="end_date" name="end_date" 
                               value="<?php echo e($endDate); ?>">
                    </div>
                    <div class="col-md-3">
                        <label for="period" class="form-label">Period</label>
                        <select class="form-select" id="period" name="period">
                            <option value="day" <?php echo e($period == 'day' ? 'selected' : ''); ?>>Daily</option>
                            <option value="week" <?php echo e($period == 'week' ? 'selected' : ''); ?>>Weekly</option>
                            <option value="month" <?php echo e($period == 'month' ? 'selected' : ''); ?>>Monthly</option>
                        </select>
                    </div>
                    <div class="col-md-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary me-2">
                            <i class="bi bi-funnel"></i> Apply Filter
                        </button>
                        <button type="button" class="btn btn-outline-success" onclick="exportReports()">
                            <i class="bi bi-download"></i> Export
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Revenue Chart -->
    <div class="row g-4 mb-4">
        <div class="col-xl-8">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="bi bi-currency-dollar"></i> Revenue Trend
                    </h6>
                </div>
                <div class="card-body">
                    <?php if($revenue_data->count() > 0): ?>
                        <div class="chart-container" style="height: 400px;">
                            <canvas id="revenueChart"></canvas>
                        </div>
                        <div class="mt-3">
                            <div class="row text-center">
                                <div class="col-md-4">
                                    <div class="border-end">
                                        <div class="h4 text-primary mb-1">PKR <?php echo e(number_format($revenue_data->sum('revenue'), 2)); ?></div>
                                        <small class="text-muted">Total Revenue</small>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="border-end">
                                        <div class="h4 text-success mb-1"><?php echo e(number_format($revenue_data->sum('orders'))); ?></div>
                                        <small class="text-muted">Total Orders</small>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="h4 text-info mb-1">PKR <?php echo e($revenue_data->count() > 0 ? number_format($revenue_data->sum('revenue') / $revenue_data->sum('orders'), 2) : '0.00'); ?></div>
                                    <small class="text-muted">Average Order Value</small>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-5">
                            <i class="bi bi-graph-up text-muted" style="font-size: 3rem;"></i>
                            <p class="text-muted mt-2">No revenue data available for selected period</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <!-- Order Status Distribution -->
        <div class="col-xl-4">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="bi bi-pie-chart"></i> Order Status Distribution
                    </h6>
                </div>
                <div class="card-body">
                    <?php if($status_data->count() > 0): ?>
                        <div class="chart-container" style="height: 300px;">
                            <canvas id="statusChart"></canvas>
                        </div>
                        <div class="mt-3">
                            <?php $__currentLoopData = $status_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <div class="d-flex align-items-center">
                                        <div class="status-indicator bg-<?php echo e($status->status === 'delivered' ? 'success' : 
                                            ($status->status === 'in_transit' ? 'info' : 
                                            ($status->status === 'picked' ? 'warning' : 
                                            ($status->status === 'cancelled' ? 'danger' : 'secondary')))); ?> me-2"></div>
                                        <small><?php echo e(ucfirst(str_replace('_', ' ', $status->status))); ?></small>
                                    </div>
                                    <strong><?php echo e($status->count); ?></strong>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-5">
                            <i class="bi bi-pie-chart text-muted" style="font-size: 3rem;"></i>
                            <p class="text-muted mt-2">No status data available</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Top Districts & Agent Performance -->
    <div class="row g-4">
        <!-- Top Districts -->
        <div class="col-xl-6">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="bi bi-geo-alt"></i> Top Districts (Most Active)
                    </h6>
                </div>
                <div class="card-body">
                    <?php if($district_data->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-borderless">
                                <thead>
                                    <tr>
                                        <th>Rank</th>
                                        <th>District</th>
                                        <th>Orders</th>
                                        <th>Activity</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $district_data->take(10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district => $count): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <span class="badge bg-<?php echo e($loop->iteration <= 3 ? 'warning' : 'secondary'); ?>">
                                                    #<?php echo e($loop->iteration); ?>

                                                </span>
                                            </td>
                                            <td><strong><?php echo e($district); ?></strong></td>
                                            <td><?php echo e($count); ?></td>
                                            <td>
                                                <div class="progress" style="height: 8px;">
                                                    <div class="progress-bar bg-primary" 
                                                         style="width: <?php echo e(($count / $district_data->max()) * 100); ?>%"></div>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-4">
                            <i class="bi bi-geo-alt text-muted" style="font-size: 3rem;"></i>
                            <p class="text-muted mt-2">No district data available</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <!-- Agent Performance -->
        <div class="col-xl-6">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="bi bi-person-badge"></i> Top Performing Agents
                    </h6>
                </div>
                <div class="card-body">
                    <?php if($agent_performance->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-borderless">
                                <thead>
                                    <tr>
                                        <th>Rank</th>
                                        <th>Agent</th>
                                        <th>Orders</th>
                                        <th>Performance</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $agent_performance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <span class="badge bg-<?php echo e($loop->iteration <= 3 ? 'success' : 'secondary'); ?>">
                                                    #<?php echo e($loop->iteration); ?>

                                                </span>
                                            </td>
                                            <td>
                                                <div>
                                                    <strong><?php echo e($agent->user->name); ?></strong>
                                                    <br><small class="text-muted"><?php echo e($agent->agent_code); ?></small>
                                                </div>
                                            </td>
                                            <td><?php echo e($agent->assigned_orders_count); ?></td>
                                            <td>
                                                <div class="progress" style="height: 8px;">
                                                    <div class="progress-bar bg-success" 
                                                         style="width: <?php echo e(($agent->assigned_orders_count / $agent_performance->max('assigned_orders_count')) * 100); ?>%"></div>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-4">
                            <i class="bi bi-person-badge text-muted" style="font-size: 3rem;"></i>
                            <p class="text-muted mt-2">No agent performance data available</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Summary Cards -->
    <div class="row g-4 mt-2">
        <div class="col-md-3">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Revenue (Period)
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                PKR <?php echo e(number_format($revenue_data->sum('revenue'), 2)); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="bi bi-currency-dollar fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Total Orders (Period)
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?php echo e(number_format($revenue_data->sum('orders'))); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="bi bi-box-seam fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Average Order Value
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                PKR <?php echo e($revenue_data->sum('orders') > 0 ? number_format($revenue_data->sum('revenue') / $revenue_data->sum('orders'), 2) : '0.00'); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="bi bi-calculator fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Active Agents
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?php echo e($agent_performance->count()); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="bi bi-people fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .border-left-primary {
        border-left: 0.25rem solid #4e73df !important;
    }
    .border-left-success {
        border-left: 0.25rem solid #1cc88a !important;
    }
    .border-left-info {
        border-left: 0.25rem solid #36b9cc !important;
    }
    .border-left-warning {
        border-left: 0.25rem solid #f6c23e !important;
    }
    .text-xs {
        font-size: 0.7rem;
    }
    .fa-2x {
        font-size: 2em;
    }
    .text-gray-300 {
        color: #dddfeb !important;
    }
    .text-gray-800 {
        color: #5a5c69 !important;
    }
    .status-indicator {
        width: 12px;
        height: 12px;
        border-radius: 50%;
    }
    .card {
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        border: 1px solid #e3e6f0;
    }
    .card-header {
        background-color: #f8f9fa;
        border-bottom: 1px solid #e3e6f0;
    }
    .chart-container {
        position: relative;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Revenue Chart
    <?php if($revenue_data->count() > 0): ?>
        const revenueCtx = document.getElementById('revenueChart').getContext('2d');
        const revenueChart = new Chart(revenueCtx, {
            type: 'line',
            data: {
                labels: [
                    <?php $__currentLoopData = $revenue_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        '<?php echo e($data->date); ?>',
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ],
                datasets: [{
                    label: 'Revenue (PKR)',
                    data: [
                        <?php $__currentLoopData = $revenue_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php echo e($data->revenue); ?>,
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    borderColor: '#4e73df',
                    backgroundColor: 'rgba(78, 115, 223, 0.1)',
                    borderWidth: 3,
                    fill: true,
                    tension: 0.4
                }, {
                    label: 'Orders',
                    data: [
                        <?php $__currentLoopData = $revenue_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php echo e($data->orders); ?>,
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    borderColor: '#1cc88a',
                    backgroundColor: 'rgba(28, 200, 138, 0.1)',
                    borderWidth: 2,
                    fill: false,
                    yAxisID: 'y1'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        type: 'linear',
                        display: true,
                        position: 'left',
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return 'PKR ' + value.toLocaleString();
                            }
                        }
                    },
                    y1: {
                        type: 'linear',
                        display: true,
                        position: 'right',
                        beginAtZero: true,
                        grid: {
                            drawOnChartArea: false,
                        },
                    }
                },
                plugins: {
                    legend: {
                        display: true,
                        position: 'top'
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                if (context.datasetIndex === 0) {
                                    return 'Revenue: PKR ' + context.parsed.y.toLocaleString();
                                } else {
                                    return 'Orders: ' + context.parsed.y;
                                }
                            }
                        }
                    }
                }
            }
        });
    <?php endif; ?>
    
    // Status Chart
    <?php if($status_data->count() > 0): ?>
        const statusCtx = document.getElementById('statusChart').getContext('2d');
        const statusChart = new Chart(statusCtx, {
            type: 'doughnut',
            data: {
                labels: [
                    <?php $__currentLoopData = $status_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        '<?php echo e(ucfirst(str_replace("_", " ", $status->status))); ?>',
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ],
                datasets: [{
                    data: [
                        <?php $__currentLoopData = $status_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php echo e($status->count); ?>,
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    backgroundColor: [
                        <?php $__currentLoopData = $status_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            '<?php echo e($status->status === "delivered" ? "#1cc88a" : 
                                ($status->status === "in_transit" ? "#36b9cc" : 
                                ($status->status === "picked" ? "#f6c23e" : 
                                ($status->status === "cancelled" ? "#e74a3b" : "#858796")))); ?>',
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    borderWidth: 2,
                    borderColor: '#fff'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                return context.label + ': ' + context.parsed + ' orders';
                            }
                        }
                    }
                }
            }
        });
    <?php endif; ?>
    
    function exportReports() {
        // Implement export functionality
        alert('Export functionality will be implemented soon!');
    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/khanozai/portal.topcourierservice.com.pk/resources/views/admin/reports.blade.php ENDPATH**/ ?>