<?php $__env->startSection('title', 'Home'); ?>

<?php $__env->startSection('content'); ?>
<!-- Hero Section -->
<section class="hero-section">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <h1 class="display-4 fw-bold mb-4">Fast & Reliable Courier Service</h1>
                <p class="lead mb-4">Send your packages across Pakistan with confidence. Track in real-time, multiple payment options, and doorstep delivery.</p>
                <div class="d-flex gap-3">
                    <?php if(auth()->guard()->check()): ?>
                        <a href="<?php echo e(route('courier.create')); ?>" class="btn btn-light btn-lg">
                            <i class="bi bi-plus-circle"></i> Book Now
                        </a>
                    <?php else: ?>
                        <a href="<?php echo e(route('register')); ?>" class="btn btn-light btn-lg">
                            <i class="bi bi-person-plus"></i> Get Started
                        </a>
                    <?php endif; ?>
                    <a href="<?php echo e(route('tracking')); ?>" class="btn btn-outline-light btn-lg">
                        <i class="bi bi-search"></i> Track Order
                    </a>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="text-center">
                    <i class="bi bi-truck" style="font-size: 8rem; opacity: 0.8;"></i>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Quick Track Section -->
<section class="py-5 bg-light">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-body p-4">
                        <h3 class="text-center mb-4">Track Your Order</h3>
                        <form action="<?php echo e(route('tracking.search')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="input-group input-group-lg">
                                <input type="text" class="form-control" name="tracking_code" 
                                       placeholder="Enter tracking code (e.g., TCS20250916001)" required>
                                <button class="btn btn-primary" type="submit">
                                    <i class="bi bi-search"></i> Track
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Features Section -->
<section class="py-5">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="fw-bold">Why Choose TCS Courier?</h2>
            <p class="text-muted">Experience the best courier service in Pakistan</p>
        </div>
        
        <div class="row g-4">
            <div class="col-md-4">
                <div class="card h-100 text-center">
                    <div class="card-body">
                        <div class="mb-3">
                            <i class="bi bi-lightning-charge text-primary" style="font-size: 3rem;"></i>
                        </div>
                        <h5 class="card-title">Fast Delivery</h5>
                        <p class="card-text">Same-day, express, and standard delivery options available across all major cities.</p>
                    </div>
                </div>
            </div>
            
            <div class="col-md-4">
                <div class="card h-100 text-center">
                    <div class="card-body">
                        <div class="mb-3">
                            <i class="bi bi-shield-check text-success" style="font-size: 3rem;"></i>
                        </div>
                        <h5 class="card-title">Secure & Safe</h5>
                        <p class="card-text">Your packages are insured and handled with utmost care by our trained professionals.</p>
                    </div>
                </div>
            </div>
            
            <div class="col-md-4">
                <div class="card h-100 text-center">
                    <div class="card-body">
                        <div class="mb-3">
                            <i class="bi bi-geo-alt text-warning" style="font-size: 3rem;"></i>
                        </div>
                        <h5 class="card-title">Real-time Tracking</h5>
                        <p class="card-text">Track your package in real-time from pickup to delivery with SMS and email updates.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Services Section -->
<section class="py-5 bg-light">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="fw-bold">Our Services</h2>
            <p class="text-muted">Choose the service that fits your needs</p>
        </div>
        
        <div class="row g-4">
            <div class="col-lg-3 col-md-6">
                <div class="card h-100">
                    <div class="card-body text-center">
                        <i class="bi bi-bicycle text-primary mb-3" style="font-size: 2.5rem;"></i>
                        <h6 class="card-title">Bike Delivery</h6>
                        <p class="card-text small">Quick delivery for small packages within the city.</p>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3 col-md-6">
                <div class="card h-100">
                    <div class="card-body text-center">
                        <i class="bi bi-car-front text-info mb-3" style="font-size: 2.5rem;"></i>
                        <h6 class="card-title">Car Service</h6>
                        <p class="card-text small">Medium packages with faster intercity delivery.</p>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3 col-md-6">
                <div class="card h-100">
                    <div class="card-body text-center">
                        <i class="bi bi-truck text-success mb-3" style="font-size: 2.5rem;"></i>
                        <h6 class="card-title">Van Service</h6>
                        <p class="card-text small">Large packages and bulk deliveries.</p>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3 col-md-6">
                <div class="card h-100">
                    <div class="card-body text-center">
                        <i class="bi bi-truck-flatbed text-warning mb-3" style="font-size: 2.5rem;"></i>
                        <h6 class="card-title">Truck Service</h6>
                        <p class="card-text small">Heavy cargo and commercial deliveries.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Payment Methods -->
<section class="py-5">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="fw-bold">Payment Methods</h2>
            <p class="text-muted">Multiple convenient payment options</p>
        </div>
        
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="row g-4 text-center">
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-body">
                                <i class="bi bi-cash-coin text-success mb-2" style="font-size: 2rem;"></i>
                                <h6>Cash on Delivery</h6>
                                <small class="text-muted">Pay when you receive</small>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-body">
                                <i class="bi bi-phone text-primary mb-2" style="font-size: 2rem;"></i>
                                <h6>JazzCash</h6>
                                <small class="text-muted">Mobile wallet payment</small>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-body">
                                <i class="bi bi-wallet2 text-info mb-2" style="font-size: 2rem;"></i>
                                <h6>Easypaisa</h6>
                                <small class="text-muted">Digital wallet payment</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php if(!auth()->check()): ?>
<!-- CTA Section -->
<section class="py-5 bg-primary text-white">
    <div class="container text-center">
        <h2 class="fw-bold mb-3">Ready to Send Your Package?</h2>
        <p class="lead mb-4">Join thousands of satisfied customers who trust TCS Courier</p>
        <a href="<?php echo e(route('register')); ?>" class="btn btn-light btn-lg">
            <i class="bi bi-person-plus"></i> Create Account
        </a>
    </div>
</section>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/khanozai/portal.topcourierservice.com.pk/resources/views/home.blade.php ENDPATH**/ ?>