<?php $__env->startSection('title', 'Login'); ?>

<?php $__env->startSection('content'); ?>
<!-- Login Form -->
<div class="mobile-card">
    <div class="mobile-card-header text-center">
        <h2 class="mb-2">
            <i class="bi bi-box-arrow-in-right me-2"></i>
            <?php echo e(__('mobile.welcome_back')); ?>

        </h2>
        <p class="mb-0 opacity-75"><?php echo e(__('mobile.sign_in_account')); ?></p>
    </div>
    <div class="mobile-card-body">
        <?php if($errors->any()): ?>
            <div class="alert alert-danger alert-mobile">
                <i class="bi bi-exclamation-triangle me-2"></i>
                <strong>Login Failed</strong>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <br><?php echo e($error); ?>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
        
        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-mobile">
                <i class="bi bi-exclamation-triangle me-2"></i>
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>
        
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-mobile">
                <i class="bi bi-check-circle me-2"></i>
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>
        
        <form method="POST" action="<?php echo e(route('login')); ?>">
            <?php echo csrf_field(); ?>
            
            <!-- Email or Phone -->
            <div class="mb-4">
                <label for="login" class="form-label fw-bold">
                    <i class="bi bi-envelope me-2 text-primary"></i><?php echo e(__('mobile.email_or_phone')); ?>

                </label>
                <input type="text" class="form-control form-control-mobile <?php $__errorArgs = ['login'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                       id="login" name="login" value="<?php echo e(old('login')); ?>" 
                       placeholder="<?php echo e(__('mobile.enter_email_phone')); ?>" required autofocus>
                <?php $__errorArgs = ['login'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            
            <!-- Password -->
            <div class="mb-4">
                <label for="password" class="form-label fw-bold">
                    <i class="bi bi-lock me-2 text-primary"></i><?php echo e(__('mobile.password')); ?>

                </label>
                <div class="input-group">
                    <input type="password" class="form-control form-control-mobile <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                           id="password" name="password" placeholder="<?php echo e(__('mobile.enter_password')); ?>" required>
                    <button class="btn btn-outline-secondary" type="button" id="togglePassword">
                        <i class="bi bi-eye" id="toggleIcon"></i>
                    </button>
                </div>
                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            
            <!-- Remember Me -->
            <div class="mb-4">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="remember" name="remember" 
                           <?php echo e(old('remember') ? 'checked' : ''); ?>>
                    <label class="form-check-label" for="remember">
                        Keep me signed in
                    </label>
                </div>
            </div>
            
            <!-- Submit Button -->
            <div class="d-grid mb-4">
                <button type="submit" class="btn btn-mobile btn-mobile-primary">
                    <i class="bi bi-box-arrow-in-right me-2"></i>
                    Sign In
                </button>
            </div>
        </form>
        
        <!-- Forgot Password -->
        <div class="text-center mb-4">
            <a href="<?php echo e(route('password.request')); ?>" class="text-decoration-none">
                <i class="bi bi-key me-1"></i>
                Forgot your password?
            </a>
        </div>
    </div>
</div>

<!-- Social Login -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <div class="text-center mb-4">
            <p class="text-muted mb-3">Or continue with</p>
        </div>
        
        <div class="row g-3 mb-4">
            <div class="col-6">
                <a href="#" class="btn btn-mobile btn-mobile-danger w-100" onclick="alert('Google login coming soon!')">
                    <i class="bi bi-google me-2"></i>
                    Google
                </a>
            </div>
            <div class="col-6">
                <a href="#" class="btn btn-mobile btn-mobile-primary w-100" onclick="alert('Facebook login coming soon!')">
                    <i class="bi bi-facebook me-2"></i>
                    Facebook
                </a>
            </div>
        </div>
        
        <!-- Phone OTP Login -->
        <div class="d-grid mb-4">
            <a href="#" class="btn btn-mobile btn-mobile-success" onclick="alert('Phone OTP login coming soon!')">
                <i class="bi bi-phone me-2"></i>
                Login with Phone OTP
            </a>
        </div>
    </div>
</div>

<!-- Register Link -->
<div class="mobile-card">
    <div class="mobile-card-body text-center">
        <p class="text-muted mb-3">Don't have an account?</p>
        <a href="<?php echo e(route('register')); ?>" class="btn btn-mobile btn-mobile-warning w-100">
            <i class="bi bi-person-plus me-2"></i>
            Create New Account
        </a>
    </div>
</div>

<!-- Quick Access -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <h6 class="mb-3 text-center">
            <i class="bi bi-lightning-charge text-warning me-2"></i>
            Quick Access (No Login Required)
        </h6>
        <div class="row g-2">
            <div class="col-6">
                <a href="<?php echo e(route('tracking')); ?>" class="btn btn-outline-info w-100 btn-sm">
                    <i class="bi bi-search"></i>
                    <br>
                    <small>Track Package</small>
                </a>
            </div>
            <div class="col-6">
                <a href="<?php echo e(route('home')); ?>" class="btn btn-outline-secondary w-100 btn-sm">
                    <i class="bi bi-house"></i>
                    <br>
                    <small>Back to Home</small>
                </a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Toggle password visibility
    document.getElementById('togglePassword').addEventListener('click', function() {
        const passwordField = document.getElementById('password');
        const toggleIcon = document.getElementById('toggleIcon');
        
        if (passwordField.type === 'password') {
            passwordField.type = 'text';
            toggleIcon.className = 'bi bi-eye-slash';
        } else {
            passwordField.type = 'password';
            toggleIcon.className = 'bi bi-eye';
        }
    });
    
    // Form validation and loading state
    document.querySelector('form').addEventListener('submit', function(e) {
        const email = document.getElementById('login').value;
        const password = document.getElementById('password').value;
        
        if (!email || !password) {
            e.preventDefault();
            
            // Show mobile-friendly alert
            const alertDiv = document.createElement('div');
            alertDiv.className = 'alert alert-warning alert-mobile';
            alertDiv.innerHTML = '<i class="bi bi-exclamation-triangle me-2"></i>Please fill in all required fields.';
            
            const form = document.querySelector('form');
            form.insertBefore(alertDiv, form.firstChild);
            
            // Remove alert after 3 seconds
            setTimeout(() => {
                alertDiv.remove();
            }, 3000);
            
            return;
        }
        
        // Show loading state
        const submitBtn = document.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        submitBtn.innerHTML = '<i class="bi bi-hourglass-split me-2"></i>Signing In...';
        submitBtn.disabled = true;
        
        // Show loading overlay
        showLoading();
    });
    
    // Auto-focus on login field for desktop, but not mobile to avoid keyboard popup
    document.addEventListener('DOMContentLoaded', function() {
        if (!window.matchMedia('(max-width: 768px)').matches) {
            setTimeout(() => {
                document.getElementById('login').focus();
            }, 500);
        }
    });
    
    // Add haptic feedback for form submission
    document.querySelector('button[type="submit"]').addEventListener('click', function() {
        if ('vibrate' in navigator) {
            navigator.vibrate(100);
        }
    });
    
    // Real-time validation feedback
    document.querySelectorAll('input').forEach(input => {
        input.addEventListener('input', function() {
            if (this.value.trim()) {
                this.classList.remove('is-invalid');
                this.classList.add('is-valid');
            } else {
                this.classList.remove('is-valid');
            }
        });
    });
    
    // Auto-hide alerts after 5 seconds
    document.querySelectorAll('.alert').forEach(alert => {
        setTimeout(() => {
            alert.style.opacity = '0';
            alert.style.transform = 'translateY(-20px)';
            setTimeout(() => {
                alert.remove();
            }, 300);
        }, 5000);
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.mobile', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/khanozai/portal.topcourierservice.com.pk/resources/views/mobile/auth/login.blade.php ENDPATH**/ ?>