<?php $__env->startSection('title', 'Add New District Pricing'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">
                <i class="bi bi-plus-circle text-primary"></i> Add New District Pricing
            </h1>
            <p class="text-muted mb-0">Configure delivery rates for specific routes and service types</p>
        </div>
        <div>
            <a href="<?php echo e(route('admin.pricing')); ?>" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left"></i> Back to Pricing List
            </a>
        </div>
    </div>
    
    <!-- Pricing Form -->
    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="bi bi-gear"></i> Pricing Configuration
                    </h6>
                </div>
                <div class="card-body">
                    <form method="POST" action="<?php echo e(route('admin.pricing.store')); ?>" id="pricing-form">
                        <?php echo csrf_field(); ?>
                        
                        <!-- Route Configuration -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h5 class="text-primary mb-3">
                                    <i class="bi bi-geo-alt"></i> Route Configuration
                                </h5>
                            </div>
                            <div class="col-md-6">
                                <label for="pickup_district_id" class="form-label">Pickup District <span class="text-danger">*</span></label>
                                <select class="form-select <?php $__errorArgs = ['pickup_district_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="pickup_district_id" name="pickup_district_id" required>
                                    <option value="">Select Pickup District</option>
                                    <?php $__currentLoopData = $districts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($district->id); ?>" <?php echo e(old('pickup_district_id') == $district->id ? 'selected' : ''); ?>>
                                            <?php echo e($district->name); ?> (<?php echo e($district->province); ?>)
                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['pickup_district_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6">
                                <label for="drop_district_id" class="form-label">Drop District <span class="text-danger">*</span></label>
                                <select class="form-select <?php $__errorArgs = ['drop_district_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="drop_district_id" name="drop_district_id" required>
                                    <option value="">Select Drop District</option>
                                    <?php $__currentLoopData = $districts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($district->id); ?>" <?php echo e(old('drop_district_id') == $district->id ? 'selected' : ''); ?>>
                                            <?php echo e($district->name); ?> (<?php echo e($district->province); ?>)
                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['drop_district_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <!-- Service Type -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h5 class="text-primary mb-3">
                                    <i class="bi bi-truck"></i> Service Configuration
                                </h5>
                            </div>
                            <div class="col-md-6">
                                <label for="service_type" class="form-label">Service Type <span class="text-danger">*</span></label>
                                <select class="form-select <?php $__errorArgs = ['service_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="service_type" name="service_type" required>
                                    <option value="">Select Service Type</option>
                                    <?php $__currentLoopData = $serviceTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key); ?>" <?php echo e(old('service_type') == $key ? 'selected' : ''); ?>>
                                            <?php echo e($label); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['service_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6">
                                <label for="estimated_days" class="form-label">Estimated Delivery Days <span class="text-danger">*</span></label>
                                <input type="number" class="form-control <?php $__errorArgs = ['estimated_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="estimated_days" name="estimated_days" min="1" max="30" 
                                       value="<?php echo e(old('estimated_days', 1)); ?>" required>
                                <?php $__errorArgs = ['estimated_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <!-- Pricing Details -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h5 class="text-primary mb-3">
                                    <i class="bi bi-currency-dollar"></i> Pricing Details
                                </h5>
                            </div>
                            <div class="col-md-6">
                                <label for="base_rate" class="form-label">Base Rate (Rs.)</label>
                                <input type="number" class="form-control <?php $__errorArgs = ['base_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="base_rate" name="base_rate" step="0.01" min="0" 
                                       value="<?php echo e(old('base_rate')); ?>" disabled>
                                <div class="form-text">Fixed charge regardless of weight (Disabled)</div>
                                <?php $__errorArgs = ['base_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6">
                                <label for="per_kg_rate" class="form-label">Per KG Rate (Rs.) <span class="text-danger">*</span></label>
                                <input type="number" class="form-control <?php $__errorArgs = ['per_kg_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="per_kg_rate" name="per_kg_rate" step="0.01" min="0" 
                                       value="<?php echo e(old('per_kg_rate')); ?>" required>
                                <div class="form-text">Additional charge per kilogram</div>
                                <?php $__errorArgs = ['per_kg_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <!-- Min/Max Charges -->
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <label for="minimum_charge" class="form-label">Minimum Charge (Rs.)</label>
                                <input type="number" class="form-control <?php $__errorArgs = ['minimum_charge'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="minimum_charge" name="minimum_charge" step="0.01" min="0" 
                                       value="<?php echo e(old('minimum_charge')); ?>" disabled>
                                <div class="form-text">Minimum amount to charge for this route (Disabled)</div>
                                <?php $__errorArgs = ['minimum_charge'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6">
                                <label for="maximum_charge" class="form-label">Maximum Charge (Rs.)</label>
                                <input type="number" class="form-control <?php $__errorArgs = ['maximum_charge'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="maximum_charge" name="maximum_charge" step="0.01" min="0" 
                                       value="<?php echo e(old('maximum_charge')); ?>" disabled>
                                <div class="form-text">Optional maximum charge cap (Disabled)</div>
                                <?php $__errorArgs = ['maximum_charge'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <!-- Status and Notes -->
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="is_active" name="is_active" 
                                           value="1" <?php echo e(old('is_active', true) ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="is_active">
                                        <strong>Active Status</strong>
                                        <div class="form-text">Enable this pricing configuration</div>
                                    </label>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mb-4">
                            <div class="col-12">
                                <label for="notes" class="form-label">Notes</label>
                                <textarea class="form-control <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                          id="notes" name="notes" rows="3" 
                                          placeholder="Optional notes about this pricing configuration"><?php echo e(old('notes')); ?></textarea>
                                <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <!-- Submit Buttons -->
                        <div class="row">
                            <div class="col-12">
                                <hr>
                                <div class="d-flex justify-content-end gap-2">
                                    <a href="<?php echo e(route('admin.pricing')); ?>" class="btn btn-secondary">
                                        <i class="bi bi-x-circle"></i> Cancel
                                    </a>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-check-circle"></i> Create Pricing
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <!-- Pricing Calculator Preview -->
        <div class="col-lg-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="bi bi-calculator"></i> Pricing Preview
                    </h6>
                </div>
                <div class="card-body">
                    <div id="pricing-preview">
                        <div class="text-center text-muted py-4">
                            <i class="bi bi-calculator" style="font-size: 2rem;"></i>
                            <p class="mt-2">Fill in the pricing details to see a preview</p>
                        </div>
                    </div>
                    
                    <!-- Sample Calculation -->
                    <div class="mt-4">
                        <h6 class="text-primary">Test Calculation</h6>
                        <div class="input-group mb-3">
                            <span class="input-group-text">Weight (KG)</span>
                            <input type="number" class="form-control" id="test-weight" 
                                   placeholder="Enter weight" min="0.1" step="0.1" value="1">
                            <button class="btn btn-outline-primary" type="button" id="calculate-btn">
                                Calculate
                            </button>
                        </div>
                        <div id="calculation-result" class="alert alert-info d-none">
                            <strong>Total Cost: Rs. <span id="total-cost">0.00</span></strong>
                            <div class="mt-2 small">
                                <div>Base Rate: Rs. <span id="calc-base">0.00</span></div>
                                <div>Weight Charge: Rs. <span id="calc-weight">0.00</span></div>
                                <div>Final Amount: Rs. <span id="calc-final">0.00</span></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Tips -->
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-success">
                        <i class="bi bi-lightbulb"></i> Pricing Tips
                    </h6>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled mb-0">
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success me-2"></i>
                            Set competitive base rates for your market
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success me-2"></i>
                            Consider distance and delivery complexity
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success me-2"></i>
                            Use minimum charges to ensure profitability
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success me-2"></i>
                            Express services should cost more than standard
                        </li>
                        <li>
                            <i class="bi bi-check-circle text-success me-2"></i>
                            Review and update pricing regularly
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('pricing-form');
    const previewDiv = document.getElementById('pricing-preview');
    const calculateBtn = document.getElementById('calculate-btn');
    const testWeightInput = document.getElementById('test-weight');
    const resultDiv = document.getElementById('calculation-result');
    
    // Update preview when form values change
    function updatePreview() {
        const pickupDistrict = document.getElementById('pickup_district_id');
        const dropDistrict = document.getElementById('drop_district_id');
        const serviceType = document.getElementById('service_type');
        const baseRate = document.getElementById('base_rate').value;
        const perKgRate = document.getElementById('per_kg_rate').value;
        const minCharge = document.getElementById('minimum_charge').value;
        const maxCharge = document.getElementById('maximum_charge').value;
        const estimatedDays = document.getElementById('estimated_days').value;
        
        if (pickupDistrict.value && dropDistrict.value && serviceType.value) {
            const pickupText = pickupDistrict.options[pickupDistrict.selectedIndex].text;
            const dropText = dropDistrict.options[dropDistrict.selectedIndex].text;
            const serviceText = serviceType.options[serviceType.selectedIndex].text;
            
            previewDiv.innerHTML = `
                <div class="pricing-summary">
                    <h6 class="text-primary mb-3">Route Summary</h6>
                    <div class="route-display mb-3">
                        <div class="d-flex align-items-center mb-2">
                            <i class="bi bi-geo-alt text-success me-2"></i>
                            <strong>${pickupText}</strong>
                        </div>
                        <div class="d-flex align-items-center mb-2">
                            <i class="bi bi-arrow-down text-muted me-2"></i>
                        </div>
                        <div class="d-flex align-items-center">
                            <i class="bi bi-geo-alt-fill text-danger me-2"></i>
                            <strong>${dropText}</strong>
                        </div>
                    </div>
                    
                    <div class="service-info mb-3">
                        <span class="badge bg-primary fs-6">${serviceText}</span>
                        ${estimatedDays ? `<span class="badge bg-info fs-6 ms-2">${estimatedDays} days</span>` : ''}
                    </div>
                    
                    <div class="pricing-breakdown">
                        <h6 class="text-primary mb-2">Pricing Structure</h6>
                        ${perKgRate ? `<div><strong>Per KG Rate:</strong> Rs. ${parseFloat(perKgRate).toFixed(2)}</div>` : ''}
                        <div class="text-muted small">Base Rate, Minimum & Maximum charges are disabled</div>
                    </div>
                </div>
            `;
        } else {
            previewDiv.innerHTML = `
                <div class="text-center text-muted py-4">
                    <i class="bi bi-calculator" style="font-size: 2rem;"></i>
                    <p class="mt-2">Fill in the pricing details to see a preview</p>
                </div>
            `;
        }
    }
    
    // Calculate pricing for test weight
    function calculateTestPrice() {
        const weight = parseFloat(testWeightInput.value) || 0;
        const perKgRate = parseFloat(document.getElementById('per_kg_rate').value) || 0;
        
        if (weight > 0 && perKgRate > 0) {
            const finalAmount = weight * perKgRate;
            
            document.getElementById('calc-base').textContent = '0.00';
            document.getElementById('calc-weight').textContent = finalAmount.toFixed(2);
            document.getElementById('calc-final').textContent = finalAmount.toFixed(2);
            document.getElementById('total-cost').textContent = finalAmount.toFixed(2);
            
            resultDiv.classList.remove('d-none');
        } else {
            resultDiv.classList.add('d-none');
        }
    }
    
    // Event listeners
    form.addEventListener('input', updatePreview);
    form.addEventListener('change', updatePreview);
    calculateBtn.addEventListener('click', calculateTestPrice);
    testWeightInput.addEventListener('input', calculateTestPrice);
    
    // Validation
    document.getElementById('pickup_district_id').addEventListener('change', updatePreview);
    document.getElementById('drop_district_id').addEventListener('change', updatePreview);
    
    // Minimum charge validation
    document.getElementById('minimum_charge').addEventListener('input', function() {
        const maxChargeInput = document.getElementById('maximum_charge');
        const minValue = parseFloat(this.value);
        const maxValue = parseFloat(maxChargeInput.value);
        
        if (maxValue > 0 && minValue > maxValue) {
            maxChargeInput.setCustomValidity('Maximum charge must be greater than minimum charge');
        } else {
            maxChargeInput.setCustomValidity('');
        }
    });
    
    document.getElementById('maximum_charge').addEventListener('input', function() {
        const minChargeInput = document.getElementById('minimum_charge');
        const maxValue = parseFloat(this.value);
        const minValue = parseFloat(minChargeInput.value);
        
        if (maxValue > 0 && minValue > maxValue) {
            this.setCustomValidity('Maximum charge must be greater than minimum charge');
        } else {
            this.setCustomValidity('');
        }
    });
});
</script>

<style>
.route-display {
    background: #f8f9fa;
    padding: 15px;
    border-radius: 8px;
    border-left: 4px solid #007bff;
}

.pricing-breakdown div {
    padding: 2px 0;
    border-bottom: 1px solid #eee;
}

.pricing-breakdown div:last-child {
    border-bottom: none;
}

.service-info .badge {
    font-size: 0.8rem;
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/khanozai/portal.topcourierservice.com.pk/resources/views/admin/pricing/create.blade.php ENDPATH**/ ?>