<?php $__env->startSection('title', 'Create District'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">
                <i class="bi bi-geo-alt-fill text-primary"></i> Create New District
            </h1>
            <p class="text-muted mb-0">Add a new service district to the system</p>
        </div>
        <div>
            <a href="<?php echo e(route('admin.districts')); ?>" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left"></i> Back to Districts
            </a>
        </div>
    </div>
    
    <!-- Create District Form -->
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card shadow">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-geo-alt"></i> District Information</h5>
                </div>
                <div class="card-body">
                    <form method="POST" action="<?php echo e(route('admin.districts.store')); ?>">
                        <?php echo csrf_field(); ?>
                        
                        <!-- District Name -->
                        <div class="mb-4">
                            <label for="name" class="form-label">District Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="name" name="name" value="<?php echo e(old('name')); ?>" 
                                   placeholder="e.g., Lahore, Karachi, Islamabad" required>
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <small class="form-text text-muted">Enter the official district name</small>
                        </div>
                        
                        <!-- Province -->
                        <div class="mb-4">
                            <label for="province" class="form-label">Province <span class="text-danger">*</span></label>
                            <select class="form-select <?php $__errorArgs = ['province'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="province" name="province" required>
                                <option value="">Select province...</option>
                                <option value="Punjab" <?php echo e(old('province') == 'Punjab' ? 'selected' : ''); ?>>Punjab</option>
                                <option value="Sindh" <?php echo e(old('province') == 'Sindh' ? 'selected' : ''); ?>>Sindh</option>
                                <option value="Khyber Pakhtunkhwa" <?php echo e(old('province') == 'Khyber Pakhtunkhwa' ? 'selected' : ''); ?>>Khyber Pakhtunkhwa</option>
                                <option value="Balochistan" <?php echo e(old('province') == 'Balochistan' ? 'selected' : ''); ?>>Balochistan</option>
                                <option value="Gilgit-Baltistan" <?php echo e(old('province') == 'Gilgit-Baltistan' ? 'selected' : ''); ?>>Gilgit-Baltistan</option>
                                <option value="Azad Kashmir" <?php echo e(old('province') == 'Azad Kashmir' ? 'selected' : ''); ?>>Azad Kashmir</option>
                                <option value="Islamabad Capital Territory" <?php echo e(old('province') == 'Islamabad Capital Territory' ? 'selected' : ''); ?>>Islamabad Capital Territory</option>
                            </select>
                            <?php $__errorArgs = ['province'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <small class="form-text text-muted">Select the province where this district is located</small>
                        </div>
                        
                        <!-- Status -->
                        <div class="mb-4">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="is_active" name="is_active" 
                                       <?php echo e(old('is_active', true) ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="is_active">
                                    <strong>Active District</strong>
                                    <small class="text-muted d-block">District is available for courier services</small>
                                </label>
                            </div>
                        </div>
                        
                        <!-- Information Alert -->
                        <div class="alert alert-info" role="alert">
                            <h6 class="alert-heading">
                                <i class="bi bi-info-circle"></i> Important Information
                            </h6>
                            <ul class="mb-0 small">
                                <li>District names must be unique across the system</li>
                                <li>Make sure to select the correct province</li>
                                <li>Active districts will be available for order booking</li>
                                <li>You can add offices to this district after creation</li>
                                <li>Districts with existing orders cannot be deleted</li>
                            </ul>
                        </div>
                        
                        <!-- Submit Buttons -->
                        <div class="d-flex justify-content-end gap-2">
                            <a href="<?php echo e(route('admin.districts')); ?>" class="btn btn-secondary">
                                <i class="bi bi-x-circle"></i> Cancel
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-check-circle"></i> Create District
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            
            <!-- Preview Card -->
            <div class="card shadow mt-4" id="previewCard" style="display: none;">
                <div class="card-header bg-light">
                    <h6 class="mb-0"><i class="bi bi-eye"></i> District Preview</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="d-flex align-items-center mb-3">
                                <div class="district-preview-icon bg-primary text-white me-3">
                                    <i class="bi bi-geo-alt"></i>
                                </div>
                                <div>
                                    <h6 class="mb-0" id="previewName">District Name</h6>
                                    <small class="text-muted" id="previewProvince">Province</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="text-end">
                                <span class="badge bg-success" id="previewStatus">Active</span>
                            </div>
                        </div>
                    </div>
                    <div class="row text-center mt-3">
                        <div class="col-4">
                            <div class="border rounded p-2">
                                <div class="h6 text-muted mb-0">0</div>
                                <small class="text-muted">Orders</small>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="border rounded p-2">
                                <div class="h6 text-muted mb-0">0</div>
                                <small class="text-muted">Offices</small>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="border rounded p-2">
                                <div class="h6 text-muted mb-0">New</div>
                                <small class="text-muted">Status</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .card {
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        border: 1px solid #e3e6f0;
    }
    
    .card-header {
        background-color: #f8f9fa;
        border-bottom: 1px solid #e3e6f0;
    }
    
    .form-label {
        font-weight: 600;
        color: #5a5c69;
    }
    
    .text-danger {
        font-size: 0.9rem;
    }
    
    .form-text {
        font-size: 0.8rem;
    }
    
    .btn {
        font-weight: 500;
    }
    
    .alert {
        border-left: 4px solid #17a2b8;
    }
    
    .alert-heading {
        font-size: 1rem;
        margin-bottom: 0.5rem;
    }
    
    .district-preview-icon {
        width: 40px;
        height: 40px;
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 18px;
    }
    
    .form-control:focus, .form-select:focus {
        border-color: #4e73df;
        box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Real-time preview update
    function updatePreview() {
        const name = document.getElementById('name').value;
        const province = document.getElementById('province').value;
        const isActive = document.getElementById('is_active').checked;
        const previewCard = document.getElementById('previewCard');
        
        if (name || province) {
            previewCard.style.display = 'block';
            
            document.getElementById('previewName').textContent = name || 'District Name';
            document.getElementById('previewProvince').textContent = province || 'Province';
            
            const statusBadge = document.getElementById('previewStatus');
            if (isActive) {
                statusBadge.className = 'badge bg-success';
                statusBadge.textContent = 'Active';
            } else {
                statusBadge.className = 'badge bg-secondary';
                statusBadge.textContent = 'Inactive';
            }
        } else {
            previewCard.style.display = 'none';
        }
    }
    
    // Add event listeners
    document.getElementById('name').addEventListener('input', updatePreview);
    document.getElementById('province').addEventListener('change', updatePreview);
    document.getElementById('is_active').addEventListener('change', updatePreview);
    
    // Form validation
    document.querySelector('form').addEventListener('submit', function(e) {
        const requiredFields = ['name', 'province'];
        let isValid = true;
        
        requiredFields.forEach(field => {
            const input = document.getElementById(field);
            if (!input.value.trim()) {
                input.classList.add('is-invalid');
                isValid = false;
            } else {
                input.classList.remove('is-invalid');
            }
        });
        
        if (!isValid) {
            e.preventDefault();
            alert('Please fill in all required fields.');
        }
    });
    
    // Real-time validation feedback
    document.querySelectorAll('input, select').forEach(field => {
        field.addEventListener('input', function() {
            if (this.value.trim()) {
                this.classList.remove('is-invalid');
                this.classList.add('is-valid');
            }
        });
        
        field.addEventListener('change', function() {
            if (this.value.trim()) {
                this.classList.remove('is-invalid');
                this.classList.add('is-valid');
            }
        });
    });
    
    // Auto-capitalize district name
    document.getElementById('name').addEventListener('input', function(e) {
        const words = e.target.value.split(' ');
        const capitalizedWords = words.map(word => {
            return word.charAt(0).toUpperCase() + word.slice(1).toLowerCase();
        });
        e.target.value = capitalizedWords.join(' ');
        updatePreview();
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\ASC\Desktop\Trae Projects\TCS Web app\resources\views/admin/districts/create.blade.php ENDPATH**/ ?>