<?php $__env->startSection('title', 'Book Courier'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0"><i class="bi bi-plus-circle"></i> Book Courier Service</h4>
                </div>
                <div class="card-body">
                    <form method="POST" action="<?php echo e(route('courier.store')); ?>" id="courierForm">
                        <?php echo csrf_field(); ?>
                        
                        <!-- Pickup & Drop Districts -->
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <label for="pickup_district_id" class="form-label">Pickup District</label>
                                <select class="form-select <?php $__errorArgs = ['pickup_district_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="pickup_district_id" name="pickup_district_id" required>
                                    <option value="">Select Pickup District</option>
                                    <?php $__currentLoopData = $districts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($district->id); ?>" <?php echo e(old('pickup_district_id') == $district->id ? 'selected' : ''); ?>>
                                            <?php echo e($district->name); ?>, <?php echo e($district->province); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['pickup_district_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6">
                                <label for="drop_district_id" class="form-label">Drop District</label>
                                <select class="form-select <?php $__errorArgs = ['drop_district_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="drop_district_id" name="drop_district_id" required>
                                    <option value="">Select Drop District</option>
                                    <?php $__currentLoopData = $districts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($district->id); ?>" <?php echo e(old('drop_district_id') == $district->id ? 'selected' : ''); ?>>
                                            <?php echo e($district->name); ?>, <?php echo e($district->province); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['drop_district_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <!-- Sender Information -->
                        <h5 class="mb-3"><i class="bi bi-person"></i> Sender Information</h5>
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <label for="sender_name" class="form-label">Sender Name</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['sender_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="sender_name" name="sender_name" value="<?php echo e(old('sender_name', auth()->user()->name)); ?>" required>
                                <?php $__errorArgs = ['sender_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6">
                                <label for="sender_phone" class="form-label">Sender Phone</label>
                                <input type="tel" class="form-control <?php $__errorArgs = ['sender_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="sender_phone" name="sender_phone" value="<?php echo e(old('sender_phone', auth()->user()->phone)); ?>" required>
                                <?php $__errorArgs = ['sender_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="mb-4">
                            <label for="sender_address" class="form-label">Sender Address</label>
                            <textarea class="form-control <?php $__errorArgs = ['sender_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      id="sender_address" name="sender_address" rows="2" required><?php echo e(old('sender_address')); ?></textarea>
                            <?php $__errorArgs = ['sender_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <!-- Receiver Information -->
                        <h5 class="mb-3"><i class="bi bi-person-check"></i> Receiver Information</h5>
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <label for="receiver_name" class="form-label">Receiver Name</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['receiver_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="receiver_name" name="receiver_name" value="<?php echo e(old('receiver_name')); ?>" required>
                                <?php $__errorArgs = ['receiver_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6">
                                <label for="receiver_phone" class="form-label">Receiver Phone</label>
                                <input type="tel" class="form-control <?php $__errorArgs = ['receiver_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="receiver_phone" name="receiver_phone" value="<?php echo e(old('receiver_phone')); ?>" required>
                                <?php $__errorArgs = ['receiver_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="mb-4">
                            <label for="receiver_address" class="form-label">Receiver Address</label>
                            <textarea class="form-control <?php $__errorArgs = ['receiver_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      id="receiver_address" name="receiver_address" rows="2" required><?php echo e(old('receiver_address')); ?></textarea>
                            <?php $__errorArgs = ['receiver_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <!-- Parcel Details -->
                        <h5 class="mb-3"><i class="bi bi-box"></i> Parcel Details</h5>
                        <div class="row mb-4">
                            <div class="col-md-4">
                                <label for="weight" class="form-label">Weight (kg)</label>
                                <input type="number" class="form-control <?php $__errorArgs = ['weight'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="weight" name="weight" value="<?php echo e(old('weight')); ?>" 
                                       step="0.1" min="0.1" required>
                                <?php $__errorArgs = ['weight'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-4">
                                <label for="size" class="form-label">Size</label>
                                <select class="form-select <?php $__errorArgs = ['size'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="size" name="size" required>
                                    <option value="">Select Size</option>
                                    <option value="Small" <?php echo e(old('size') == 'Small' ? 'selected' : ''); ?>>Small (up to 30cm)</option>
                                    <option value="Medium" <?php echo e(old('size') == 'Medium' ? 'selected' : ''); ?>>Medium (30-60cm)</option>
                                    <option value="Large" <?php echo e(old('size') == 'Large' ? 'selected' : ''); ?>>Large (60cm+)</option>
                                </select>
                                <?php $__errorArgs = ['size'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-4">
                                <label for="category" class="form-label">Category</label>
                                <select class="form-select <?php $__errorArgs = ['category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="category" name="category" required>
                                    <option value="">Select Category</option>
                                    <option value="Documents" <?php echo e(old('category') == 'Documents' ? 'selected' : ''); ?>>Documents</option>
                                    <option value="Electronics" <?php echo e(old('category') == 'Electronics' ? 'selected' : ''); ?>>Electronics</option>
                                    <option value="Clothing" <?php echo e(old('category') == 'Clothing' ? 'selected' : ''); ?>>Clothing</option>
                                    <option value="Food" <?php echo e(old('category') == 'Food' ? 'selected' : ''); ?>>Food Items</option>
                                    <option value="Fragile" <?php echo e(old('category') == 'Fragile' ? 'selected' : ''); ?>>Fragile Items</option>
                                    <option value="Other" <?php echo e(old('category') == 'Other' ? 'selected' : ''); ?>>Other</option>
                                </select>
                                <?php $__errorArgs = ['category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="mb-4">
                            <label for="description" class="form-label">Description (Optional)</label>
                            <textarea class="form-control" id="description" name="description" 
                                      rows="2" placeholder="Brief description of the package"><?php echo e(old('description')); ?></textarea>
                        </div>
                        
                        <!-- Delivery Options -->
                        <h5 class="mb-3"><i class="bi bi-truck"></i> Delivery Options</h5>
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <label for="delivery_type" class="form-label">Delivery Type</label>
                                <select class="form-select <?php $__errorArgs = ['delivery_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="delivery_type" name="delivery_type" required>
                                    <option value="">Select Delivery Type</option>
                                    <option value="standard" <?php echo e(old('delivery_type') == 'standard' ? 'selected' : ''); ?>>Standard (3-5 days)</option>
                                    <option value="express" <?php echo e(old('delivery_type') == 'express' ? 'selected' : ''); ?>>Express (1-2 days)</option>
                                    <option value="same_day" <?php echo e(old('delivery_type') == 'same_day' ? 'selected' : ''); ?>>Same Day</option>
                                </select>
                                <?php $__errorArgs = ['delivery_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6">
                                <label for="vehicle_type" class="form-label">Vehicle Type</label>
                                <select class="form-select <?php $__errorArgs = ['vehicle_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="vehicle_type" name="vehicle_type" required>
                                    <option value="">Select Vehicle</option>
                                    <option value="bike" <?php echo e(old('vehicle_type') == 'bike' ? 'selected' : ''); ?>>Bike</option>
                                    <option value="car" <?php echo e(old('vehicle_type') == 'car' ? 'selected' : ''); ?>>Car</option>
                                    <option value="van" <?php echo e(old('vehicle_type') == 'van' ? 'selected' : ''); ?>>Van</option>
                                    <option value="truck" <?php echo e(old('vehicle_type') == 'truck' ? 'selected' : ''); ?>>Truck</option>
                                </select>
                                <?php $__errorArgs = ['vehicle_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <!-- Payment Method -->
                        <h5 class="mb-3"><i class="bi bi-credit-card"></i> Payment Method</h5>
                        <div class="mb-4">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="payment_method" 
                                               id="cod" value="cod" <?php echo e(old('payment_method', 'cod') == 'cod' ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="cod">
                                            <i class="bi bi-cash-coin"></i> Cash on Delivery
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="payment_method" 
                                               id="jazzcash" value="jazzcash" <?php echo e(old('payment_method') == 'jazzcash' ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="jazzcash">
                                            <i class="bi bi-phone"></i> JazzCash
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="payment_method" 
                                               id="easypaisa" value="easypaisa" <?php echo e(old('payment_method') == 'easypaisa' ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="easypaisa">
                                            <i class="bi bi-wallet2"></i> Easypaisa
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Submit Button -->
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="bi bi-check-circle"></i> Calculate Price & Book
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <!-- Price Estimation Sidebar -->
        <div class="col-lg-4">
            <div class="card shadow">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0"><i class="bi bi-calculator"></i> Price Estimation</h5>
                </div>
                <div class="card-body">
                    <div id="priceEstimation">
                        <p class="text-muted">Fill the form to get price estimation</p>
                    </div>
                </div>
            </div>
            
            <!-- Service Info -->
            <div class="card shadow mt-4">
                <div class="card-header">
                    <h6 class="mb-0"><i class="bi bi-info-circle"></i> Service Information</h6>
                </div>
                <div class="card-body">
                    <small>
                        <ul class="list-unstyled mb-0">
                            <li class="mb-2"><i class="bi bi-check-circle text-success"></i> Free pickup from your location</li>
                            <li class="mb-2"><i class="bi bi-check-circle text-success"></i> Real-time tracking</li>
                            <li class="mb-2"><i class="bi bi-check-circle text-success"></i> SMS & Email notifications</li>
                            <li class="mb-2"><i class="bi bi-check-circle text-success"></i> Insurance coverage</li>
                            <li><i class="bi bi-check-circle text-success"></i> 24/7 customer support</li>
                        </ul>
                    </small>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Real-time price calculation
    function calculatePrice() {
        const weight = parseFloat(document.getElementById('weight').value) || 0;
        const deliveryType = document.getElementById('delivery_type').value;
        const vehicleType = document.getElementById('vehicle_type').value;
        
        if (weight > 0 && deliveryType && vehicleType) {
            // Base price calculation (matching the Order model logic)
            let basePrice = 100;
            let weightMultiplier = weight * 10;
            
            const deliveryMultiplier = {
                'standard': 1,
                'express': 1.5,
                'same_day': 2
            };
            
            const vehicleMultiplier = {
                'bike': 1,
                'car': 1.2,
                'van': 1.5,
                'truck': 2
            };
            
            let price = basePrice + weightMultiplier;
            price *= deliveryMultiplier[deliveryType] || 1;
            price *= vehicleMultiplier[vehicleType] || 1;
            
            const finalPrice = Math.round(price * 100) / 100;
            
            document.getElementById('priceEstimation').innerHTML = `
                <div class="text-center">
                    <h3 class="text-success mb-3">PKR ${finalPrice}</h3>
                    <div class="small text-muted">
                        <div>Base Price: PKR ${basePrice}</div>
                        <div>Weight (${weight}kg): PKR ${weightMultiplier}</div>
                        <div>Delivery: ${deliveryType} (${deliveryMultiplier[deliveryType]}x)</div>
                        <div>Vehicle: ${vehicleType} (${vehicleMultiplier[vehicleType]}x)</div>
                    </div>
                </div>
            `;
        } else {
            document.getElementById('priceEstimation').innerHTML = '<p class="text-muted">Fill the form to get price estimation</p>';
        }
    }
    
    // Add event listeners for real-time calculation
    document.getElementById('weight').addEventListener('input', calculatePrice);
    document.getElementById('delivery_type').addEventListener('change', calculatePrice);
    document.getElementById('vehicle_type').addEventListener('change', calculatePrice);
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\ASC\Desktop\Trae Projects\TCS Web app\resources\views/courier/create.blade.php ENDPATH**/ ?>