<?php $__env->startSection('title', 'Edit District - ' . $district->name); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">
                <i class="bi bi-pencil-square text-primary"></i> Edit District
            </h1>
            <p class="text-muted mb-0">Update district information: <strong><?php echo e($district->name); ?></strong></p>
        </div>
        <div>
            <a href="<?php echo e(route('admin.districts')); ?>" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left"></i> Back to Districts
            </a>
        </div>
    </div>
    
    <!-- Edit District Form -->
    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-geo-alt"></i> District Information</h5>
                </div>
                <div class="card-body">
                    <form method="POST" action="<?php echo e(route('admin.districts.update', $district)); ?>">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        
                        <!-- District Name -->
                        <div class="mb-4">
                            <label for="name" class="form-label">District Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="name" name="name" value="<?php echo e(old('name', $district->name)); ?>" 
                                   placeholder="e.g., Lahore, Karachi, Islamabad" required>
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <small class="form-text text-muted">Enter the official district name</small>
                        </div>
                        
                        <!-- Province -->
                        <div class="mb-4">
                            <label for="province" class="form-label">Province <span class="text-danger">*</span></label>
                            <select class="form-select <?php $__errorArgs = ['province'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="province" name="province" required>
                                <option value="">Select province...</option>
                                <option value="Punjab" <?php echo e(old('province', $district->province) == 'Punjab' ? 'selected' : ''); ?>>Punjab</option>
                                <option value="Sindh" <?php echo e(old('province', $district->province) == 'Sindh' ? 'selected' : ''); ?>>Sindh</option>
                                <option value="Khyber Pakhtunkhwa" <?php echo e(old('province', $district->province) == 'Khyber Pakhtunkhwa' ? 'selected' : ''); ?>>Khyber Pakhtunkhwa</option>
                                <option value="Balochistan" <?php echo e(old('province', $district->province) == 'Balochistan' ? 'selected' : ''); ?>>Balochistan</option>
                                <option value="Gilgit-Baltistan" <?php echo e(old('province', $district->province) == 'Gilgit-Baltistan' ? 'selected' : ''); ?>>Gilgit-Baltistan</option>
                                <option value="Azad Kashmir" <?php echo e(old('province', $district->province) == 'Azad Kashmir' ? 'selected' : ''); ?>>Azad Kashmir</option>
                                <option value="Islamabad Capital Territory" <?php echo e(old('province', $district->province) == 'Islamabad Capital Territory' ? 'selected' : ''); ?>>Islamabad Capital Territory</option>
                            </select>
                            <?php $__errorArgs = ['province'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <small class="form-text text-muted">Select the province where this district is located</small>
                        </div>
                        
                        <!-- Status -->
                        <div class="mb-4">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="is_active" name="is_active" 
                                       <?php echo e(old('is_active', $district->is_active) ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="is_active">
                                    <strong>Active District</strong>
                                    <small class="text-muted d-block">District is available for courier services</small>
                                </label>
                            </div>
                        </div>
                        
                        <!-- Warning for districts with data -->
                        <?php if($district->pickupOrders()->count() > 0 || $district->dropOrders()->count() > 0 || $district->offices()->count() > 0): ?>
                            <div class="alert alert-warning" role="alert">
                                <h6 class="alert-heading">
                                    <i class="bi bi-exclamation-triangle"></i> Important Notice
                                </h6>
                                <p class="mb-2">This district has associated data:</p>
                                <ul class="mb-2 small">
                                    <?php if($district->pickupOrders()->count() > 0): ?>
                                        <li><?php echo e($district->pickupOrders()->count()); ?> pickup orders</li>
                                    <?php endif; ?>
                                    <?php if($district->dropOrders()->count() > 0): ?>
                                        <li><?php echo e($district->dropOrders()->count()); ?> drop orders</li>
                                    <?php endif; ?>
                                    <?php if($district->offices()->count() > 0): ?>
                                        <li><?php echo e($district->offices()->count()); ?> offices</li>
                                    <?php endif; ?>
                                </ul>
                                <p class="mb-0 small">Please be careful when making changes as they may affect existing orders and offices.</p>
                            </div>
                        <?php endif; ?>
                        
                        <!-- Submit Buttons -->
                        <div class="d-flex justify-content-end gap-2">
                            <a href="<?php echo e(route('admin.districts')); ?>" class="btn btn-secondary">
                                <i class="bi bi-x-circle"></i> Cancel
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-check-circle"></i> Update District
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <!-- District Statistics -->
        <div class="col-lg-4">
            <div class="card shadow">
                <div class="card-header">
                    <h6 class="mb-0"><i class="bi bi-graph-up"></i> District Statistics</h6>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-12 mb-3">
                            <div class="border rounded p-3">
                                <div class="h4 text-primary mb-1"><?php echo e($district->pickupOrders()->count()); ?></div>
                                <small class="text-muted">Pickup Orders</small>
                            </div>
                        </div>
                        <div class="col-12 mb-3">
                            <div class="border rounded p-3">
                                <div class="h4 text-success mb-1"><?php echo e($district->dropOrders()->count()); ?></div>
                                <small class="text-muted">Drop Orders</small>
                            </div>
                        </div>
                        <div class="col-12 mb-3">
                            <div class="border rounded p-3">
                                <div class="h4 text-info mb-1"><?php echo e($district->offices()->count()); ?></div>
                                <small class="text-muted">Service Offices</small>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="border rounded p-3">
                                <div class="h4 text-warning mb-1"><?php echo e($district->pickupOrders()->count() + $district->dropOrders()->count()); ?></div>
                                <small class="text-muted">Total Orders</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- District Information -->
            <div class="card shadow mt-4">
                <div class="card-header">
                    <h6 class="mb-0"><i class="bi bi-info-circle"></i> District Details</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <strong>Current Status:</strong>
                        <span class="badge bg-<?php echo e($district->is_active ? 'success' : 'danger'); ?> ms-2">
                            <?php echo e($district->is_active ? 'Active' : 'Inactive'); ?>

                        </span>
                    </div>
                    <div class="mb-3">
                        <strong>Created:</strong>
                        <br><small class="text-muted"><?php echo e($district->created_at->format('M d, Y h:i A')); ?></small>
                    </div>
                    <div class="mb-3">
                        <strong>Last Updated:</strong>
                        <br><small class="text-muted"><?php echo e($district->updated_at->format('M d, Y h:i A')); ?></small>
                    </div>
                    <div class="mb-0">
                        <strong>District ID:</strong>
                        <br><small class="text-muted">#<?php echo e($district->id); ?></small>
                    </div>
                </div>
            </div>
            
            <!-- Quick Actions -->
            <div class="card shadow mt-4">
                <div class="card-header">
                    <h6 class="mb-0"><i class="bi bi-lightning"></i> Quick Actions</h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="<?php echo e(route('admin.offices.create')); ?>?district_id=<?php echo e($district->id); ?>" class="btn btn-outline-primary btn-sm">
                            <i class="bi bi-building-add"></i> Add Office to District
                        </a>
                        <a href="<?php echo e(route('admin.orders')); ?>?district=<?php echo e($district->name); ?>" class="btn btn-outline-info btn-sm">
                            <i class="bi bi-box-seam"></i> View District Orders
                        </a>
                        <?php if($district->pickupOrders()->count() == 0 && $district->dropOrders()->count() == 0 && $district->offices()->count() == 0): ?>
                            <button type="button" class="btn btn-outline-danger btn-sm" onclick="deleteDistrict(<?php echo e($district->id); ?>)">
                                <i class="bi bi-trash"></i> Delete District
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .card {
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        border: 1px solid #e3e6f0;
    }
    
    .card-header {
        background-color: #f8f9fa;
        border-bottom: 1px solid #e3e6f0;
    }
    
    .form-label {
        font-weight: 600;
        color: #5a5c69;
    }
    
    .text-danger {
        font-size: 0.9rem;
    }
    
    .form-text {
        font-size: 0.8rem;
    }
    
    .btn {
        font-weight: 500;
    }
    
    .alert {
        border-left: 4px solid #f6c23e;
    }
    
    .alert-heading {
        font-size: 1rem;
        margin-bottom: 0.5rem;
    }
    
    .form-control:focus, .form-select:focus {
        border-color: #4e73df;
        box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Form validation
    document.querySelector('form').addEventListener('submit', function(e) {
        const requiredFields = ['name', 'province'];
        let isValid = true;
        
        requiredFields.forEach(field => {
            const input = document.getElementById(field);
            if (!input.value.trim()) {
                input.classList.add('is-invalid');
                isValid = false;
            } else {
                input.classList.remove('is-invalid');
            }
        });
        
        if (!isValid) {
            e.preventDefault();
            alert('Please fill in all required fields.');
        }
    });
    
    // Real-time validation feedback
    document.querySelectorAll('input, select').forEach(field => {
        field.addEventListener('input', function() {
            if (this.value.trim()) {
                this.classList.remove('is-invalid');
                this.classList.add('is-valid');
            }
        });
        
        field.addEventListener('change', function() {
            if (this.value.trim()) {
                this.classList.remove('is-invalid');
                this.classList.add('is-valid');
            }
        });
    });
    
    // Auto-capitalize district name
    document.getElementById('name').addEventListener('input', function(e) {
        const words = e.target.value.split(' ');
        const capitalizedWords = words.map(word => {
            return word.charAt(0).toUpperCase() + word.slice(1).toLowerCase();
        });
        e.target.value = capitalizedWords.join(' ');
    });
    
    // Delete district function
    function deleteDistrict(districtId) {
        if (confirm('Are you sure you want to delete this district? This action cannot be undone.')) {
            // Create a form and submit it
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = '/admin/districts/' + districtId;
            
            // Add CSRF token
            const csrfToken = document.createElement('input');
            csrfToken.type = 'hidden';
            csrfToken.name = '_token';
            csrfToken.value = '<?php echo e(csrf_token()); ?>';
            form.appendChild(csrfToken);
            
            // Add method override
            const methodField = document.createElement('input');
            methodField.type = 'hidden';
            methodField.name = '_method';
            methodField.value = 'DELETE';
            form.appendChild(methodField);
            
            document.body.appendChild(form);
            form.submit();
        }
    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\ASC\Desktop\Trae Projects\TCS Web app\resources\views/admin/districts/edit.blade.php ENDPATH**/ ?>