<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'TCS Courier')); ?> - <?php echo $__env->yieldContent('title', 'Home'); ?></title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    
    <!-- Custom CSS -->
    <style>
        /* Root Variables for Consistent Theming */
        :root {
            --primary-color: #007bff;
            --primary-dark: #0056b3;
            --primary-darker: #004085;
            --shadow-light: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
            --shadow-medium: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
            --border-radius: 0.375rem;
            --transition: all 0.3s ease;
        }

        /* Layout Structure Fixes */
        * {
            box-sizing: border-box;
        }

        html {
            scroll-behavior: smooth;
        }

        body {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            line-height: 1.6;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
        }

        main {
            flex: 1;
            width: 100%;
            overflow-x: hidden;
        }

        /* Container Improvements */
        .container, .container-fluid {
            padding-left: 15px;
            padding-right: 15px;
        }

        @media (min-width: 576px) {
            .container, .container-fluid {
                padding-left: 20px;
                padding-right: 20px;
            }
        }

        /* Navigation Fixes */
        .navbar-brand {
            font-weight: bold;
            color: var(--primary-color) !important;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .navbar {
            box-shadow: var(--shadow-light);
            border-bottom: 1px solid rgba(0,0,0,0.1);
        }

        .navbar-collapse {
            flex-grow: 1;
        }

        /* Hero Section */
        .hero-section {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-dark) 100%);
            color: white;
            padding: 4rem 0;
            position: relative;
            overflow: hidden;
        }

        /* Card Improvements */
        .card {
            border: none;
            box-shadow: var(--shadow-light);
            transition: var(--transition);
            border-radius: var(--border-radius);
            overflow: hidden;
        }

        .card:hover {
            box-shadow: var(--shadow-medium);
            transform: translateY(-2px);
        }

        .card-header {
            border-bottom: 1px solid rgba(0,0,0,0.125);
            background-color: rgba(0,0,0,0.03);
        }

        /* Button Improvements */
        .btn {
            border-radius: var(--border-radius);
            transition: var(--transition);
            font-weight: 500;
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-dark) 100%);
            border: none;
            box-shadow: 0 2px 4px rgba(0, 123, 255, 0.3);
        }

        .btn-primary:hover {
            background: linear-gradient(135deg, var(--primary-dark) 0%, var(--primary-darker) 100%);
            box-shadow: 0 4px 8px rgba(0, 123, 255, 0.4);
            transform: translateY(-1px);
        }

        /* Form Improvements */
        .form-control, .form-select {
            border-radius: var(--border-radius);
            border: 1px solid #ced4da;
            transition: var(--transition);
        }

        .form-control:focus, .form-select:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
        }

        /* Alert Improvements */
        .alert {
            border-radius: var(--border-radius);
            border: none;
            box-shadow: var(--shadow-light);
        }

        /* Footer */
        .footer {
            background-color: #f8f9fa;
            padding: 2rem 0;
            margin-top: auto;
            border-top: 1px solid rgba(0,0,0,0.1);
        }

        /* Status Badge */
        .status-badge {
            font-size: 0.75rem;
            padding: 0.25rem 0.5rem;
            border-radius: 0.25rem;
        }

        /* Responsive Improvements */
        @media (max-width: 767.98px) {
            .container {
                padding-left: 10px;
                padding-right: 10px;
            }
            
            .card {
                margin-bottom: 1rem;
            }
            
            .btn {
                width: 100%;
                margin-bottom: 0.5rem;
            }
            
            .btn:last-child {
                margin-bottom: 0;
            }
            
            .d-flex.justify-content-between {
                flex-direction: column;
                gap: 1rem;
            }
            
            .d-flex.justify-content-between > div:last-child {
                display: flex;
                flex-direction: column;
                gap: 0.5rem;
            }
        }

        /* Grid System Fixes */
        .row {
            margin-left: -0.75rem;
            margin-right: -0.75rem;
        }

        .row > * {
            padding-left: 0.75rem;
            padding-right: 0.75rem;
        }

        /* Utility Classes */
        .shadow-custom {
            box-shadow: var(--shadow-medium) !important;
        }

        .border-radius-custom {
            border-radius: var(--border-radius) !important;
        }

        .transition-custom {
            transition: var(--transition) !important;
        }

        /* Loading States */
        .loading {
            opacity: 0.6;
            pointer-events: none;
        }

        /* Accessibility Improvements */
        .sr-only {
            position: absolute;
            width: 1px;
            height: 1px;
            padding: 0;
            margin: -1px;
            overflow: hidden;
            clip: rect(0, 0, 0, 0);
            white-space: nowrap;
            border: 0;
        }

        /* Focus Improvements */
        *:focus {
            outline: 2px solid var(--primary-color);
            outline-offset: 2px;
        }

        .btn:focus, .form-control:focus, .form-select:focus {
            outline: none;
        }
    </style>
    
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm">
        <div class="container">
            <a class="navbar-brand" href="<?php echo e(route('home')); ?>">
                <i class="bi bi-truck"></i> TCS Courier
            </a>
            
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('home')); ?>">Home</a>
                    </li>
                    <?php if(auth()->guard()->check()): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('courier.create')); ?>">Book Courier</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('orders.index')); ?>">My Orders</a>
                        </li>
                    <?php endif; ?>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('tracking')); ?>">Track Order</a>
                    </li>
                </ul>
                
                <ul class="navbar-nav">
                    <?php if(auth()->guard()->guest()): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('login')); ?>">Login</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('register')); ?>">Register</a>
                        </li>
                    <?php else: ?>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown">
                                <i class="bi bi-person-circle"></i> <?php echo e(Auth::user()->name); ?>

                            </a>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="<?php echo e(route('profile')); ?>">Profile</a></li>
                                <?php if(Auth::user()->isAdmin()): ?>
                                    <li><a class="dropdown-item" href="<?php echo e(route('admin.dashboard')); ?>">Admin Panel</a></li>
                                <?php endif; ?>
                                <li><hr class="dropdown-divider"></li>
                                <li>
                                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="dropdown-item">Logout</button>
                                    </form>
                                </li>
                            </ul>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main>
        <?php if(session('success')): ?>
            <div class="container mt-3">
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="container mt-3">
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            </div>
        <?php endif; ?>

        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <h5>TCS Courier Service</h5>
                    <p class="text-muted">Fast, reliable, and secure courier services across Pakistan.</p>
                </div>
                <div class="col-md-3">
                    <h6>Quick Links</h6>
                    <ul class="list-unstyled">
                        <li><a href="<?php echo e(route('home')); ?>" class="text-muted">Home</a></li>
                        <li><a href="<?php echo e(route('tracking')); ?>" class="text-muted">Track Order</a></li>
                        <li><a href="#" class="text-muted">Contact Us</a></li>
                    </ul>
                </div>
                <div class="col-md-3">
                    <h6>Contact Info</h6>
                    <p class="text-muted mb-1"><i class="bi bi-telephone"></i> +92-300-1234567</p>
                    <p class="text-muted mb-1"><i class="bi bi-envelope"></i> info@tcscourier.com</p>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="col-md-6 text-center text-md-start">
                    <p class="text-muted mb-0">&copy; <?php echo e(date('Y')); ?> TCS Courier Service. All rights reserved.</p>
                </div>
                <div class="col-md-6 text-center text-md-end">
                    <small class="text-muted">
                        <a href="<?php echo e(route('admin.login')); ?>" class="text-decoration-none text-danger">
                            <i class="bi bi-shield-lock me-1"></i>Admin Portal
                        </a>
                    </small>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH /home/khanozai/portal.topcourierservice.com.pk/resources/views/layouts/app.blade.php ENDPATH**/ ?>