<?php $__env->startSection('title', 'Home'); ?>

<?php $__env->startSection('content'); ?>
<!-- Welcome Section -->
<div class="mobile-card">
    <div class="mobile-card-header text-center">
        <h2 class="mb-2">
            <i class="bi bi-truck me-2"></i>
            <?php echo e(__('mobile.welcome_to_tcs')); ?>

        </h2>
        <p class="mb-0 opacity-75"><?php echo e(__('mobile.fast_reliable_service')); ?></p>
    </div>
    <div class="mobile-card-body text-center">
        <?php if(auth()->guard()->check()): ?>
            <h5 class="text-primary mb-3"><?php echo e(__('mobile.hello_user', ['name' => auth()->user()->name])); ?></h5>
            <p class="text-muted mb-4"><?php echo e(__('mobile.ready_to_send')); ?></p>
            <a href="<?php echo e(route('courier.create')); ?>" class="btn btn-mobile btn-mobile-primary w-100 mb-3">
                <i class="bi bi-plus-circle me-2"></i>
                <?php echo e(__('mobile.book_new_courier')); ?>

            </a>
        <?php else: ?>
            <h5 class="text-primary mb-3"><?php echo e(__('mobile.join_customers')); ?></h5>
            <div class="row g-2">
                <div class="col-6">
                    <a href="<?php echo e(route('register')); ?>" class="btn btn-mobile btn-mobile-success w-100">
                        <i class="bi bi-person-plus me-2"></i>
                        <?php echo e(__('mobile.create_account')); ?>

                    </a>
                </div>
                <div class="col-6">
                    <a href="<?php echo e(route('login')); ?>" class="btn btn-mobile btn-mobile-warning w-100">
                        <i class="bi bi-box-arrow-in-right me-2"></i>
                        <?php echo e(__('mobile.login')); ?>

                    </a>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Quick Actions -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <h5 class="mb-4">
            <i class="bi bi-lightning-charge text-warning me-2"></i>
            Quick Actions
        </h5>
        <div class="row g-3">
            <div class="col-6">
                <a href="<?php echo e(route('tracking')); ?>" class="btn btn-mobile btn-mobile-success w-100 h-100 d-flex flex-column align-items-center justify-content-center" style="min-height: 100px;">
                    <i class="bi bi-search" style="font-size: 2rem; margin-bottom: 8px;"></i>
                    <span>Track Package</span>
                </a>
            </div>
            <div class="col-6">
                <a href="<?php echo e(route('orders.index')); ?>" class="btn btn-mobile btn-mobile-warning w-100 h-100 d-flex flex-column align-items-center justify-content-center" style="min-height: 100px;">
                    <i class="bi bi-box-seam" style="font-size: 2rem; margin-bottom: 8px;"></i>
                    <span>My Orders</span>
                    <?php if(auth()->guard()->check()): ?>
                        <?php if(auth()->user()->orders()->count() > 0): ?>
                            <small class="badge bg-light text-dark mt-1"><?php echo e(auth()->user()->orders()->count()); ?></small>
                        <?php endif; ?>
                    <?php endif; ?>
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Quick Track -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <h5 class="mb-4">
            <i class="bi bi-search text-info me-2"></i>
            Quick Track
        </h5>
        <form action="<?php echo e(route('tracking.search')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="input-group mb-3">
                <input type="text" class="form-control form-control-mobile" 
                       name="tracking_code" 
                       placeholder="Enter tracking code" 
                       required>
                <button class="btn btn-mobile btn-mobile-primary" type="submit">
                    <i class="bi bi-search"></i>
                </button>
            </div>
        </form>
        <small class="text-muted">
            <i class="bi bi-info-circle me-1"></i>
            Example: TCS20250116001
        </small>
    </div>
</div>

<?php if(auth()->guard()->check()): ?>
<!-- Recent Orders -->
<?php if(auth()->user()->orders()->count() > 0): ?>
<div class="mobile-card">
    <div class="mobile-card-body">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h5 class="mb-0">
                <i class="bi bi-clock-history text-secondary me-2"></i>
                Recent Orders
            </h5>
            <a href="<?php echo e(route('orders.index')); ?>" class="btn btn-sm btn-outline-primary">
                View All
            </a>
        </div>
        
        <?php $__currentLoopData = auth()->user()->orders()->latest()->take(3)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="border rounded-3 p-3 mb-3 bg-light">
            <div class="d-flex justify-content-between align-items-start mb-2">
                <div>
                    <strong class="text-primary"><?php echo e($order->tracking_code); ?></strong>
                    <br>
                    <small class="text-muted">
                        <?php echo e($order->pickupDistrict->name); ?> → <?php echo e($order->dropDistrict->name); ?>

                    </small>
                </div>
                <span class="badge bg-<?php echo e($order->status === 'delivered' ? 'success' : ($order->status === 'in_transit' ? 'info' : 'warning')); ?>">
                    <?php echo e(ucfirst(str_replace('_', ' ', $order->status))); ?>

                </span>
            </div>
            <div class="d-flex justify-content-between align-items-center">
                <small class="text-muted">
                    <i class="bi bi-calendar me-1"></i>
                    <?php echo e($order->created_at->format('M d, Y')); ?>

                </small>
                <small class="text-success fw-bold">
                    Rs. <?php echo e(number_format($order->final_price)); ?>

                </small>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>
<?php endif; ?>
<?php endif; ?>

<!-- Features -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <h5 class="mb-4">
            <i class="bi bi-star text-warning me-2"></i>
            Why Choose TCS Courier?
        </h5>
        <div class="row g-3">
            <div class="col-12">
                <div class="d-flex align-items-center p-3 bg-light rounded-3">
                    <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                        <i class="bi bi-lightning-charge"></i>
                    </div>
                    <div>
                        <h6 class="mb-1">Fast Delivery</h6>
                        <small class="text-muted">Same day and next day delivery options</small>
                    </div>
                </div>
            </div>
            <div class="col-12">
                <div class="d-flex align-items-center p-3 bg-light rounded-3">
                    <div class="bg-success text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                        <i class="bi bi-shield-check"></i>
                    </div>
                    <div>
                        <h6 class="mb-1">Secure & Safe</h6>
                        <small class="text-muted">Your packages are insured and tracked</small>
                    </div>
                </div>
            </div>
            <div class="col-12">
                <div class="d-flex align-items-center p-3 bg-light rounded-3">
                    <div class="bg-info text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                        <i class="bi bi-geo-alt"></i>
                    </div>
                    <div>
                        <h6 class="mb-1">Real-time Tracking</h6>
                        <small class="text-muted">Track your package every step of the way</small>
                    </div>
                </div>
            </div>
            <div class="col-12">
                <div class="d-flex align-items-center p-3 bg-light rounded-3">
                    <div class="bg-warning text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                        <i class="bi bi-credit-card"></i>
                    </div>
                    <div>
                        <h6 class="mb-1">Multiple Payment Options</h6>
                        <small class="text-muted">COD, JazzCash, EasyPaisa, and more</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Contact Info -->
<div class="mobile-card">
    <div class="mobile-card-body text-center">
        <h5 class="mb-4">
            <i class="bi bi-headset text-primary me-2"></i>
            Need Help?
        </h5>
        <div class="row g-3">
            <div class="col-6">
                <a href="tel:+923001234567" class="btn btn-outline-success w-100">
                    <i class="bi bi-telephone"></i>
                    <br>
                    <small>Call Us</small>
                </a>
            </div>
            <div class="col-6">
                <a href="mailto:info@tcscourier.com" class="btn btn-outline-info w-100">
                    <i class="bi bi-envelope"></i>
                    <br>
                    <small>Email Us</small>
                </a>
            </div>
        </div>
        <p class="text-muted mt-3 mb-0">
            <small>24/7 Customer Support Available</small>
        </p>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Auto-focus on tracking input when page loads
    document.addEventListener('DOMContentLoaded', function() {
        const trackingInput = document.querySelector('input[name="tracking_code"]');
        if (trackingInput && !window.matchMedia('(max-width: 576px)').matches) {
            // Only auto-focus on larger screens to avoid keyboard popup on mobile
            setTimeout(() => {
                trackingInput.focus();
            }, 500);
        }
    });
    
    // Add haptic feedback for supported devices
    function addHapticFeedback(element) {
        element.addEventListener('click', function() {
            if ('vibrate' in navigator) {
                navigator.vibrate(50); // Short vibration
            }
        });
    }
    
    // Add haptic feedback to buttons
    document.querySelectorAll('.btn-mobile').forEach(addHapticFeedback);
    
    // Smooth scroll for anchor links
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.mobile', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/khanozai/portal.topcourierservice.com.pk/resources/views/mobile/home.blade.php ENDPATH**/ ?>