<?php $__env->startSection('title', 'Book Courier'); ?>

<?php $__env->startSection('content'); ?>
<!-- Booking Header -->
<div class="mobile-card">
    <div class="mobile-card-header text-center">
        <h2 class="mb-2">
            <i class="bi bi-plus-circle me-2"></i>
            <?php echo e(__('mobile.book_courier_service')); ?>

        </h2>
        <p class="mb-0 opacity-75"><?php echo e(__('mobile.fast_reliable_delivery')); ?></p>
    </div>
</div>

<!-- Booking Form -->
<form method="POST" action="<?php echo e(route('courier.store')); ?>" id="courierForm">
    <?php echo csrf_field(); ?>
    
    <!-- Pickup Details -->
    <div class="mobile-card">
        <div class="mobile-card-body">
            <h5 class="mb-4">
                <i class="bi bi-geo-alt text-primary me-2"></i>
                Pickup Details
            </h5>
            
            <div class="mb-4">
                <label for="pickup_district_id" class="form-label fw-bold">
                    <i class="bi bi-map text-primary me-2"></i>Pickup City/District
                </label>
                <select class="form-control form-control-mobile <?php $__errorArgs = ['pickup_district_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                        id="pickup_district_id" name="pickup_district_id" required>
                    <option value="">Select pickup location...</option>
                    <?php $__currentLoopData = $districts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $province => $provinceDistricts): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <optgroup label="<?php echo e($province); ?>">
                            <?php $__currentLoopData = $provinceDistricts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($district->id); ?>" <?php echo e(old('pickup_district_id') == $district->id ? 'selected' : ''); ?>>
                                    <?php echo e($district->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </optgroup>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['pickup_district_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            
            <div class="mb-4">
                <label for="pickup_address" class="form-label fw-bold">
                    <i class="bi bi-house text-primary me-2"></i>Pickup Address
                </label>
                <textarea class="form-control form-control-mobile <?php $__errorArgs = ['pickup_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                          id="pickup_address" name="pickup_address" rows="3" 
                          placeholder="Enter complete pickup address with landmarks" required><?php echo e(old('pickup_address')); ?></textarea>
                <?php $__errorArgs = ['pickup_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <small class="form-text text-muted">
                    <i class="bi bi-info-circle me-1"></i>
                    Include house number, street, and nearby landmarks
                </small>
            </div>
        </div>
    </div>
    
    <!-- Delivery Details -->
    <div class="mobile-card">
        <div class="mobile-card-body">
            <h5 class="mb-4">
                <i class="bi bi-geo-alt-fill text-danger me-2"></i>
                Delivery Details
            </h5>
            
            <div class="mb-4">
                <label for="drop_district_id" class="form-label fw-bold">
                    <i class="bi bi-map text-danger me-2"></i>Delivery City/District
                </label>
                <select class="form-control form-control-mobile <?php $__errorArgs = ['drop_district_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                        id="drop_district_id" name="drop_district_id" required>
                    <option value="">Select delivery location...</option>
                    <?php $__currentLoopData = $districts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $province => $provinceDistricts): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <optgroup label="<?php echo e($province); ?>">
                            <?php $__currentLoopData = $provinceDistricts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($district->id); ?>" <?php echo e(old('drop_district_id') == $district->id ? 'selected' : ''); ?>>
                                    <?php echo e($district->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </optgroup>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['drop_district_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            
            <div class="mb-4">
                <label for="drop_address" class="form-label fw-bold">
                    <i class="bi bi-house-fill text-danger me-2"></i>Delivery Address
                </label>
                <textarea class="form-control form-control-mobile <?php $__errorArgs = ['drop_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                          id="drop_address" name="drop_address" rows="3" 
                          placeholder="Enter complete delivery address with landmarks" required><?php echo e(old('drop_address')); ?></textarea>
                <?php $__errorArgs = ['drop_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            
            <div class="row g-3">
                <div class="col-12">
                    <label for="recipient_name" class="form-label fw-bold">
                        <i class="bi bi-person text-info me-2"></i>Recipient Name
                    </label>
                    <input type="text" class="form-control form-control-mobile <?php $__errorArgs = ['recipient_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                           id="recipient_name" name="recipient_name" value="<?php echo e(old('recipient_name')); ?>" 
                           placeholder="Full name of recipient" required>
                    <?php $__errorArgs = ['recipient_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div class="col-12">
                    <label for="recipient_phone" class="form-label fw-bold">
                        <i class="bi bi-telephone text-success me-2"></i>Recipient Phone
                    </label>
                    <input type="tel" class="form-control form-control-mobile <?php $__errorArgs = ['recipient_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                           id="recipient_phone" name="recipient_phone" value="<?php echo e(old('recipient_phone')); ?>" 
                           placeholder="+92-300-1234567" required>
                    <?php $__errorArgs = ['recipient_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Package Details -->
    <div class="mobile-card">
        <div class="mobile-card-body">
            <h5 class="mb-4">
                <i class="bi bi-box text-warning me-2"></i>
                Package Information
            </h5>
            
            <div class="mb-4">
                <label class="form-label fw-bold">
                    <i class="bi bi-archive text-warning me-2"></i>Package Type
                </label>
                <div class="row g-2">
                    <div class="col-4">
                        <input type="radio" class="btn-check" name="package_type" id="document" value="document" 
                               <?php echo e(old('package_type') == 'document' ? 'checked' : ''); ?> required>
                        <label class="btn btn-outline-primary w-100 d-flex flex-column align-items-center p-3" for="document">
                            <i class="bi bi-file-earmark" style="font-size: 1.5rem;"></i>
                            <small class="mt-1">Document</small>
                        </label>
                    </div>
                    <div class="col-4">
                        <input type="radio" class="btn-check" name="package_type" id="parcel" value="parcel" 
                               <?php echo e(old('package_type') == 'parcel' ? 'checked' : ''); ?> required>
                        <label class="btn btn-outline-success w-100 d-flex flex-column align-items-center p-3" for="parcel">
                            <i class="bi bi-box" style="font-size: 1.5rem;"></i>
                            <small class="mt-1">Parcel</small>
                        </label>
                    </div>
                    <div class="col-4">
                        <input type="radio" class="btn-check" name="package_type" id="fragile" value="fragile" 
                               <?php echo e(old('package_type') == 'fragile' ? 'checked' : ''); ?> required>
                        <label class="btn btn-outline-warning w-100 d-flex flex-column align-items-center p-3" for="fragile">
                            <i class="bi bi-exclamation-triangle" style="font-size: 1.5rem;"></i>
                            <small class="mt-1">Fragile</small>
                        </label>
                    </div>
                </div>
                <?php $__errorArgs = ['package_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="text-danger small mt-2"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            
            <div class="mb-4">
                <label for="weight" class="form-label fw-bold">
                    <i class="bi bi-speedometer text-info me-2"></i>Weight (kg)
                </label>
                <div class="input-group">
                    <input type="number" class="form-control form-control-mobile <?php $__errorArgs = ['weight'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                           id="weight" name="weight" value="<?php echo e(old('weight')); ?>" 
                           min="0.1" max="50" step="0.1" placeholder="0.5" required>
                    <span class="input-group-text">kg</span>
                </div>
                <?php $__errorArgs = ['weight'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <small class="form-text text-muted">
                    <i class="bi bi-info-circle me-1"></i>
                    Maximum weight: 50kg
                </small>
            </div>
            
            <div class="mb-4">
                <label for="special_instructions" class="form-label fw-bold">
                    <i class="bi bi-chat-text text-secondary me-2"></i>Special Instructions (Optional)
                </label>
                <textarea class="form-control form-control-mobile" id="special_instructions" 
                          name="special_instructions" rows="2" 
                          placeholder="Any special handling instructions..."><?php echo e(old('special_instructions')); ?></textarea>
            </div>
        </div>
    </div>
    
    <!-- Payment Method -->
    <div class="mobile-card">
        <div class="mobile-card-body">
            <h5 class="mb-4">
                <i class="bi bi-credit-card text-success me-2"></i>
                Payment Method
            </h5>
            
            <div class="row g-3">
                <div class="col-12">
                    <input type="radio" class="btn-check" name="payment_method" id="cod" value="cod" 
                           <?php echo e(old('payment_method', 'cod') == 'cod' ? 'checked' : ''); ?> required>
                    <label class="btn btn-outline-warning w-100 d-flex align-items-center p-3" for="cod">
                        <i class="bi bi-cash-coin me-3" style="font-size: 1.5rem;"></i>
                        <div class="text-start">
                            <strong>Cash on Delivery (COD)</strong>
                            <br><small class="text-muted">Pay when package is delivered</small>
                        </div>
                    </label>
                </div>
                <div class="col-6">
                    <input type="radio" class="btn-check" name="payment_method" id="jazzcash" value="jazzcash" 
                           <?php echo e(old('payment_method') == 'jazzcash' ? 'checked' : ''); ?> required>
                    <label class="btn btn-outline-danger w-100 d-flex flex-column align-items-center p-3" for="jazzcash">
                        <i class="bi bi-phone" style="font-size: 1.5rem;"></i>
                        <small class="mt-1">JazzCash</small>
                    </label>
                </div>
                <div class="col-6">
                    <input type="radio" class="btn-check" name="payment_method" id="easypaisa" value="easypaisa" 
                           <?php echo e(old('payment_method') == 'easypaisa' ? 'checked' : ''); ?> required>
                    <label class="btn btn-outline-success w-100 d-flex flex-column align-items-center p-3" for="easypaisa">
                        <i class="bi bi-wallet2" style="font-size: 1.5rem;"></i>
                        <small class="mt-1">EasyPaisa</small>
                    </label>
                </div>
            </div>
            <?php $__errorArgs = ['payment_method'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <div class="text-danger small mt-2"><?php echo e($message); ?></div>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
    </div>
    
    <!-- Price Estimate -->
    <div class="mobile-card" id="priceEstimate" style="display: none;">
        <div class="mobile-card-body">
            <h5 class="mb-4">
                <i class="bi bi-calculator text-info me-2"></i>
                Price Estimate
            </h5>
            
            <div class="bg-light rounded-3 p-3">
                <div class="d-flex justify-content-between mb-2">
                    <span>Base Price:</span>
                    <span id="basePrice">Rs. 200</span>
                </div>
                <div class="d-flex justify-content-between mb-2">
                    <span>Weight Charges:</span>
                    <span id="weightPrice">Rs. 0</span>
                </div>
                <hr>
                <div class="d-flex justify-content-between">
                    <strong>Total Estimate:</strong>
                    <strong class="text-success" id="totalPrice">Rs. 200</strong>
                </div>
            </div>
            
            <small class="text-muted mt-2 d-block">
                <i class="bi bi-info-circle me-1"></i>
                Final price may vary based on actual package dimensions
            </small>
        </div>
    </div>
    
    <!-- Submit Button -->
    <div class="mobile-card">
        <div class="mobile-card-body">
            <div class="d-grid">
                <button type="submit" class="btn btn-mobile btn-mobile-primary" id="submitBtn">
                    <i class="bi bi-check-circle me-2"></i>
                    Book Courier Service
                </button>
            </div>
            
            <div class="text-center mt-3">
                <small class="text-muted">
                    <i class="bi bi-shield-check me-1"></i>
                    Your package is insured up to Rs. 10,000
                </small>
            </div>
        </div>
    </div>
</form>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Auto-format phone number
    document.getElementById('recipient_phone').addEventListener('input', function(e) {
        let value = e.target.value.replace(/\D/g, '');
        if (value.length > 0) {
            if (value.startsWith('92')) {
                value = '+' + value;
            } else if (!value.startsWith('+92')) {
                value = '+92' + value;
            }
        }
        e.target.value = value;
    });
    
    // Calculate price estimate
    function calculatePrice() {
        const weight = parseFloat(document.getElementById('weight').value) || 0;
        const basePrice = 200;
        const weightPrice = weight * 50;
        const totalPrice = basePrice + weightPrice;
        
        document.getElementById('basePrice').textContent = `Rs. ${basePrice}`;
        document.getElementById('weightPrice').textContent = `Rs. ${weightPrice}`;
        document.getElementById('totalPrice').textContent = `Rs. ${totalPrice}`;
        
        if (weight > 0) {
            document.getElementById('priceEstimate').style.display = 'block';
        }
    }
    
    // Weight input change
    document.getElementById('weight').addEventListener('input', calculatePrice);
    
    // Prevent same pickup and drop district
    function validateDistricts() {
        const pickup = document.getElementById('pickup_district_id').value;
        const drop = document.getElementById('drop_district_id').value;
        
        if (pickup && drop && pickup === drop) {
            alert('Pickup and delivery locations cannot be the same.');
            document.getElementById('drop_district_id').value = '';
        }
    }
    
    document.getElementById('pickup_district_id').addEventListener('change', validateDistricts);
    document.getElementById('drop_district_id').addEventListener('change', validateDistricts);
    
    // Form validation and submission
    document.getElementById('courierForm').addEventListener('submit', function(e) {
        const requiredFields = [
            'pickup_district_id', 'pickup_address', 'drop_district_id', 
            'drop_address', 'recipient_name', 'recipient_phone', 'weight'
        ];
        
        let isValid = true;
        
        requiredFields.forEach(field => {
            const input = document.getElementById(field);
            if (!input.value.trim()) {
                input.classList.add('is-invalid');
                isValid = false;
            } else {
                input.classList.remove('is-invalid');
            }
        });
        
        // Check package type
        const packageType = document.querySelector('input[name="package_type"]:checked');
        if (!packageType) {
            isValid = false;
            alert('Please select a package type.');
        }
        
        // Check payment method
        const paymentMethod = document.querySelector('input[name="payment_method"]:checked');
        if (!paymentMethod) {
            isValid = false;
            alert('Please select a payment method.');
        }
        
        if (!isValid) {
            e.preventDefault();
            return;
        }
        
        // Show loading state
        const submitBtn = document.getElementById('submitBtn');
        submitBtn.innerHTML = '<i class="bi bi-hourglass-split me-2"></i>Booking...';
        submitBtn.disabled = true;
        
        showLoading();
    });
    
    // Add haptic feedback to radio buttons
    document.querySelectorAll('input[type="radio"]').forEach(radio => {
        radio.addEventListener('change', function() {
            if ('vibrate' in navigator) {
                navigator.vibrate(50);
            }
        });
    });
    
    // Real-time validation feedback
    document.querySelectorAll('input, select, textarea').forEach(field => {
        field.addEventListener('input', function() {
            if (this.value.trim()) {
                this.classList.remove('is-invalid');
                this.classList.add('is-valid');
            }
        });
        
        field.addEventListener('change', function() {
            if (this.value.trim()) {
                this.classList.remove('is-invalid');
                this.classList.add('is-valid');
            }
        });
    });
    
    // Auto-calculate price on page load if weight is set
    document.addEventListener('DOMContentLoaded', function() {
        calculatePrice();
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.mobile', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\ASC\Desktop\Trae Projects\TCS Web app\resources\views/mobile/courier/create.blade.php ENDPATH**/ ?>