<?php $__env->startSection('title', 'Manage Orders'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">
                <i class="bi bi-box-seam text-primary"></i> Order Management
            </h1>
            <p class="text-muted mb-0">Manage and track all courier orders</p>
        </div>
        <div>
            <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left"></i> Back to Dashboard
            </a>
        </div>
    </div>
    
    <!-- Filters -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="bi bi-funnel"></i> Filters
            </h6>
        </div>
        <div class="card-body">
            <form method="GET" action="<?php echo e(route('admin.orders')); ?>">
                <div class="row g-3">
                    <div class="col-md-3">
                        <label for="search" class="form-label">Search</label>
                        <input type="text" class="form-control" id="search" name="search" 
                               value="<?php echo e(request('search')); ?>" 
                               placeholder="Tracking code, name, phone...">
                    </div>
                    <div class="col-md-3">
                        <label for="status" class="form-label">Status</label>
                        <select class="form-select" id="status" name="status">
                            <option value="">All Statuses</option>
                            <option value="created" <?php echo e(request('status') == 'created' ? 'selected' : ''); ?>>Created</option>
                            <option value="picked" <?php echo e(request('status') == 'picked' ? 'selected' : ''); ?>>Picked</option>
                            <option value="in_transit" <?php echo e(request('status') == 'in_transit' ? 'selected' : ''); ?>>In Transit</option>
                            <option value="delivered" <?php echo e(request('status') == 'delivered' ? 'selected' : ''); ?>>Delivered</option>
                            <option value="cancelled" <?php echo e(request('status') == 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="payment_status" class="form-label">Payment Status</label>
                        <select class="form-select" id="payment_status" name="payment_status">
                            <option value="">All Payment Status</option>
                            <option value="pending" <?php echo e(request('payment_status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                            <option value="paid" <?php echo e(request('payment_status') == 'paid' ? 'selected' : ''); ?>>Paid</option>
                            <option value="failed" <?php echo e(request('payment_status') == 'failed' ? 'selected' : ''); ?>>Failed</option>
                        </select>
                    </div>
                    <div class="col-md-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary me-2">
                            <i class="bi bi-search"></i> Filter
                        </button>
                        <a href="<?php echo e(route('admin.orders')); ?>" class="btn btn-outline-secondary">
                            <i class="bi bi-x-circle"></i> Clear
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Orders Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="bi bi-list"></i> Orders List (<?php echo e($orders->total()); ?> total)
            </h6>
            <div class="dropdown">
                <button class="btn btn-sm btn-outline-primary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                    <i class="bi bi-download"></i> Export
                </button>
                <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="#"><i class="bi bi-file-earmark-excel"></i> Export to Excel</a></li>
                    <li><a class="dropdown-item" href="#"><i class="bi bi-file-earmark-pdf"></i> Export to PDF</a></li>
                </ul>
            </div>
        </div>
        <div class="card-body">
            <?php if($orders->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-bordered table-hover" width="100%" cellspacing="0">
                        <thead class="table-light">
                            <tr>
                                <th>Tracking Code</th>
                                <th>Customer</th>
                                <th>Route</th>
                                <th>Package</th>
                                <th>Status</th>
                                <th>Payment</th>
                                <th>Amount</th>
                                <th>Date</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <strong class="text-primary"><?php echo e($order->tracking_code); ?></strong>
                                        <?php if($order->assignedAgent): ?>
                                            <br><small class="text-muted">
                                                <i class="bi bi-person-badge"></i> <?php echo e($order->assignedAgent->agent_code); ?>

                                            </small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div>
                                            <strong><?php echo e($order->user->name); ?></strong>
                                            <br><small class="text-muted"><?php echo e($order->user->email); ?></small>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="small">
                                            <i class="bi bi-geo-alt text-primary"></i> <?php echo e($order->pickupDistrict->name); ?>

                                            <br><i class="bi bi-geo-alt-fill text-success"></i> <?php echo e($order->dropDistrict->name); ?>

                                        </div>
                                    </td>
                                    <td>
                                        <div class="small">
                                            <strong><?php echo e($order->weight); ?>kg</strong> - <?php echo e($order->size); ?>

                                            <br><?php echo e($order->category); ?>

                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?php echo e($order->status_badge); ?>">
                                            <?php echo e(ucfirst(str_replace('_', ' ', $order->status))); ?>

                                        </span>
                                        <?php if($order->status == 'delivered' && $order->delivered_at): ?>
                                            <br><small class="text-muted"><?php echo e($order->delivered_at->format('M d, Y')); ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?php echo e($order->payment_status === 'paid' ? 'success' : ($order->payment_status === 'failed' ? 'danger' : 'warning')); ?>">
                                            <?php echo e(ucfirst($order->payment_status)); ?>

                                        </span>
                                        <br><small class="text-muted"><?php echo e($order->payment_method === 'cod' ? 'COD' : ucfirst($order->payment_method)); ?></small>
                                    </td>
                                    <td>
                                        <strong>PKR <?php echo e(number_format($order->final_price, 2)); ?></strong>
                                    </td>
                                    <td>
                                        <div class="small">
                                            <?php echo e($order->created_at->format('M d, Y')); ?>

                                            <br><?php echo e($order->created_at->format('h:i A')); ?>

                                        </div>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="<?php echo e(route('admin.orders.show', $order)); ?>" 
                                               class="btn btn-sm btn-outline-primary" title="View Details">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                            <button type="button" class="btn btn-sm btn-outline-success" 
                                                    data-bs-toggle="modal" data-bs-target="#statusModal<?php echo e($order->id); ?>" 
                                                    title="Update Status">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <?php if(!$order->assignedAgent): ?>
                                                <button type="button" class="btn btn-sm btn-outline-warning" 
                                                        data-bs-toggle="modal" data-bs-target="#assignModal<?php echo e($order->id); ?>" 
                                                        title="Assign Agent">
                                                    <i class="bi bi-person-plus"></i>
                                                </button>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                                
                                <!-- Status Update Modal -->
                                <div class="modal fade" id="statusModal<?php echo e($order->id); ?>" tabindex="-1">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title">Update Order Status</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                            </div>
                                            <form method="POST" action="<?php echo e(route('admin.orders.update-status', $order)); ?>">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PATCH'); ?>
                                                <div class="modal-body">
                                                    <div class="mb-3">
                                                        <label for="status<?php echo e($order->id); ?>" class="form-label">Status</label>
                                                        <select class="form-select" id="status<?php echo e($order->id); ?>" name="status" required>
                                                            <option value="created" <?php echo e($order->status == 'created' ? 'selected' : ''); ?>>Created</option>
                                                            <option value="picked" <?php echo e($order->status == 'picked' ? 'selected' : ''); ?>>Picked</option>
                                                            <option value="in_transit" <?php echo e($order->status == 'in_transit' ? 'selected' : ''); ?>>In Transit</option>
                                                            <option value="delivered" <?php echo e($order->status == 'delivered' ? 'selected' : ''); ?>>Delivered</option>
                                                            <option value="cancelled" <?php echo e($order->status == 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                                                        </select>
                                                    </div>
                                                    <div class="mb-3">
                                                        <label for="notes<?php echo e($order->id); ?>" class="form-label">Notes (Optional)</label>
                                                        <textarea class="form-control" id="notes<?php echo e($order->id); ?>" name="notes" rows="3" placeholder="Add any notes about this status update..."><?php echo e($order->notes); ?></textarea>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                    <button type="submit" class="btn btn-primary">Update Status</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Assign Agent Modal -->
                                <?php if(!$order->assignedAgent): ?>
                                    <div class="modal fade" id="assignModal<?php echo e($order->id); ?>" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Assign Agent</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                </div>
                                                <form method="POST" action="<?php echo e(route('admin.orders.assign-agent', $order)); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <div class="modal-body">
                                                        <div class="mb-3">
                                                            <label for="agent<?php echo e($order->id); ?>" class="form-label">Select Agent</label>
                                                            <select class="form-select" id="agent<?php echo e($order->id); ?>" name="agent_id" required>
                                                                <option value="">Choose an agent...</option>
                                                                <?php $__currentLoopData = \App\Models\Agent::with('user')->where('is_active', true)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($agent->id); ?>">
                                                                        <?php echo e($agent->user->name); ?> (<?php echo e($agent->agent_code); ?>) - <?php echo e($agent->vehicle_type); ?>

                                                                    </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                        <button type="submit" class="btn btn-primary">Assign Agent</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <div class="d-flex justify-content-center mt-4">
                    <?php echo e($orders->appends(request()->query())->links()); ?>

                </div>
            <?php else: ?>
                <div class="text-center py-5">
                    <i class="bi bi-inbox text-muted" style="font-size: 4rem;"></i>
                    <h4 class="text-muted mt-3">No Orders Found</h4>
                    <p class="text-muted">No orders match your current filters.</p>
                    <a href="<?php echo e(route('admin.orders')); ?>" class="btn btn-primary">
                        <i class="bi bi-arrow-clockwise"></i> Reset Filters
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .table th {
        border-top: none;
        font-weight: 600;
        font-size: 0.85rem;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    .table td {
        vertical-align: middle;
        font-size: 0.9rem;
    }
    .btn-group .btn {
        border-radius: 0.25rem;
        margin-right: 2px;
    }
    .badge {
        font-size: 0.75rem;
    }
    .modal-header {
        background-color: #f8f9fa;
        border-bottom: 1px solid #dee2e6;
    }
    .card {
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        border: 1px solid #e3e6f0;
    }
    .card-header {
        background-color: #f8f9fa;
        border-bottom: 1px solid #e3e6f0;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Auto-refresh page every 30 seconds
    setTimeout(function() {
        location.reload();
    }, 30000);
    
    // Show success message if exists
    <?php if(session('success')): ?>
        const toast = document.createElement('div');
        toast.className = 'alert alert-success alert-dismissible fade show position-fixed';
        toast.style.top = '20px';
        toast.style.right = '20px';
        toast.style.zIndex = '9999';
        toast.innerHTML = `
            <i class="bi bi-check-circle"></i> <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        `;
        document.body.appendChild(toast);
        
        setTimeout(() => {
            toast.remove();
        }, 5000);
    <?php endif; ?>
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\ASC\Desktop\Trae Projects\TCS Web app\resources\views/admin/orders/index.blade.php ENDPATH**/ ?>