<?php $__env->startSection('title', 'Order Details'); ?>

<?php $__env->startSection('content'); ?>
<!-- Order Header -->
<div class="mobile-card">
    <div class="mobile-card-header text-center">
        <h2 class="mb-2">
            <i class="bi bi-box-seam me-2"></i>
            Order Details
        </h2>
        <p class="mb-0 opacity-75"><?php echo e($order->tracking_code); ?></p>
    </div>
    <div class="mobile-card-body text-center">
        <div class="mb-3">
            <span class="badge bg-<?php echo e($order->status === 'delivered' ? 'success' : ($order->status === 'in_transit' ? 'info' : ($order->status === 'picked' ? 'warning' : 'secondary'))); ?> fs-5 px-4 py-2">
                <?php echo e(ucfirst(str_replace('_', ' ', $order->status))); ?>

            </span>
        </div>
        
        <?php if($order->status === 'delivered'): ?>
            <div class="alert alert-success alert-mobile">
                <i class="bi bi-check-circle me-2"></i>
                <strong>Order Completed Successfully!</strong>
            </div>
        <?php elseif($order->status === 'in_transit'): ?>
            <div class="alert alert-info alert-mobile">
                <i class="bi bi-truck me-2"></i>
                <strong>Package is on the way!</strong>
            </div>
        <?php elseif($order->status === 'picked'): ?>
            <div class="alert alert-warning alert-mobile">
                <i class="bi bi-box-arrow-up me-2"></i>
                <strong>Package picked up from sender</strong>
            </div>
        <?php else: ?>
            <div class="alert alert-secondary alert-mobile">
                <i class="bi bi-clock me-2"></i>
                <strong>Order created, waiting for pickup</strong>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Order Information -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <h5 class="mb-4">
            <i class="bi bi-info-circle text-primary me-2"></i>
            Order Information
        </h5>
        
        <div class="row g-3 mb-4">
            <div class="col-6">
                <div class="bg-light rounded-3 p-3">
                    <small class="text-muted d-block mb-1">
                        <i class="bi bi-hash text-primary me-1"></i>Order ID
                    </small>
                    <strong>#<?php echo e($order->id); ?></strong>
                </div>
            </div>
            <div class="col-6">
                <div class="bg-light rounded-3 p-3">
                    <small class="text-muted d-block mb-1">
                        <i class="bi bi-qr-code text-info me-1"></i>Tracking
                    </small>
                    <strong class="small"><?php echo e($order->tracking_code); ?></strong>
                </div>
            </div>
        </div>
        
        <div class="row g-3 mb-4">
            <div class="col-6">
                <div class="bg-light rounded-3 p-3">
                    <small class="text-muted d-block mb-1">
                        <i class="bi bi-calendar text-secondary me-1"></i>Order Date
                    </small>
                    <strong class="small"><?php echo e($order->created_at->format('M d, Y')); ?></strong>
                    <div class="text-muted small"><?php echo e($order->created_at->format('h:i A')); ?></div>
                </div>
            </div>
            <div class="col-6">
                <div class="bg-light rounded-3 p-3">
                    <small class="text-muted d-block mb-1">
                        <i class="bi bi-credit-card text-success me-1"></i>Total Amount
                    </small>
                    <strong class="text-success">Rs. <?php echo e(number_format($order->final_price)); ?></strong>
                    <div class="text-muted small"><?php echo e(ucfirst($order->payment_method)); ?></div>
                </div>
            </div>
        </div>
        
        <div class="row g-3">
            <div class="col-6">
                <div class="bg-light rounded-3 p-3">
                    <small class="text-muted d-block mb-1">
                        <i class="bi bi-archive text-warning me-1"></i>Package Type
                    </small>
                    <strong><?php echo e(ucfirst($order->package_type)); ?></strong>
                </div>
            </div>
            <div class="col-6">
                <div class="bg-light rounded-3 p-3">
                    <small class="text-muted d-block mb-1">
                        <i class="bi bi-speedometer text-info me-1"></i>Weight
                    </small>
                    <strong><?php echo e($order->weight); ?> kg</strong>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Pickup & Delivery -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <h5 class="mb-4">
            <i class="bi bi-geo-alt text-danger me-2"></i>
            Pickup & Delivery
        </h5>
        
        <div class="row g-3">
            <div class="col-12">
                <div class="border rounded-3 p-3 mb-3">
                    <div class="d-flex align-items-start">
                        <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px; flex-shrink: 0;">
                            <i class="bi bi-geo-alt"></i>
                        </div>
                        <div class="flex-grow-1">
                            <h6 class="mb-1 text-primary">Pickup Location</h6>
                            <strong><?php echo e($order->pickupDistrict->name); ?></strong>
                            <div class="text-muted small mt-1"><?php echo e($order->pickup_address); ?></div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-12">
                <div class="d-flex justify-content-center mb-3">
                    <div class="border-start border-2 border-primary" style="height: 30px;"></div>
                </div>
            </div>
            
            <div class="col-12">
                <div class="border rounded-3 p-3">
                    <div class="d-flex align-items-start">
                        <div class="bg-danger text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px; flex-shrink: 0;">
                            <i class="bi bi-geo-alt-fill"></i>
                        </div>
                        <div class="flex-grow-1">
                            <h6 class="mb-1 text-danger">Delivery Location</h6>
                            <strong><?php echo e($order->dropDistrict->name); ?></strong>
                            <div class="text-muted small mt-1"><?php echo e($order->drop_address); ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Recipient Information -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <h5 class="mb-4">
            <i class="bi bi-person text-info me-2"></i>
            Recipient Information
        </h5>
        
        <div class="row g-3">
            <div class="col-12">
                <div class="d-flex align-items-center p-3 bg-light rounded-3">
                    <div class="bg-info text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                        <i class="bi bi-person"></i>
                    </div>
                    <div class="flex-grow-1">
                        <h6 class="mb-1"><?php echo e($order->recipient_name); ?></h6>
                        <div class="text-muted">
                            <i class="bi bi-telephone me-1"></i>
                            <?php echo e($order->recipient_phone); ?>

                        </div>
                    </div>
                    <div>
                        <a href="tel:<?php echo e($order->recipient_phone); ?>" class="btn btn-sm btn-outline-info">
                            <i class="bi bi-telephone"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php if($order->assignedAgent): ?>
<!-- Delivery Agent -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <h5 class="mb-4">
            <i class="bi bi-person-badge text-warning me-2"></i>
            Delivery Agent
        </h5>
        
        <div class="row g-3">
            <div class="col-12">
                <div class="d-flex align-items-center p-3 bg-light rounded-3">
                    <div class="bg-warning text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                        <i class="bi bi-person-badge"></i>
                    </div>
                    <div class="flex-grow-1">
                        <h6 class="mb-1"><?php echo e($order->assignedAgent->user->name); ?></h6>
                        <div class="text-muted small">
                            <i class="bi bi-telephone me-1"></i>
                            <?php echo e($order->assignedAgent->user->phone ?? 'Contact through office'); ?>

                        </div>
                        <div class="text-muted small">
                            <i class="bi bi-badge-cc me-1"></i>
                            Agent ID: <?php echo e($order->assignedAgent->agent_id); ?>

                        </div>
                    </div>
                    <?php if($order->assignedAgent->user->phone): ?>
                        <div>
                            <a href="tel:<?php echo e($order->assignedAgent->user->phone); ?>" class="btn btn-sm btn-outline-warning">
                                <i class="bi bi-telephone"></i>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php if($order->special_instructions): ?>
<!-- Special Instructions -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <h5 class="mb-3">
            <i class="bi bi-chat-text text-secondary me-2"></i>
            Special Instructions
        </h5>
        <div class="bg-light rounded-3 p-3">
            <p class="mb-0"><?php echo e($order->special_instructions); ?></p>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Payment Information -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <h5 class="mb-4">
            <i class="bi bi-credit-card text-success me-2"></i>
            Payment Information
        </h5>
        
        <div class="row g-3">
            <div class="col-6">
                <div class="bg-light rounded-3 p-3">
                    <small class="text-muted d-block mb-1">
                        <i class="bi bi-cash text-warning me-1"></i>Base Price
                    </small>
                    <strong>Rs. <?php echo e(number_format($order->base_price)); ?></strong>
                </div>
            </div>
            <div class="col-6">
                <div class="bg-light rounded-3 p-3">
                    <small class="text-muted d-block mb-1">
                        <i class="bi bi-plus-circle text-info me-1"></i>Final Price
                    </small>
                    <strong class="text-success">Rs. <?php echo e(number_format($order->final_price)); ?></strong>
                </div>
            </div>
        </div>
        
        <div class="row g-3 mt-2">
            <div class="col-6">
                <div class="bg-light rounded-3 p-3">
                    <small class="text-muted d-block mb-1">
                        <i class="bi bi-wallet text-primary me-1"></i>Method
                    </small>
                    <strong><?php echo e(ucfirst($order->payment_method)); ?></strong>
                </div>
            </div>
            <div class="col-6">
                <div class="bg-light rounded-3 p-3">
                    <small class="text-muted d-block mb-1">
                        <i class="bi bi-check-circle text-success me-1"></i>Status
                    </small>
                    <span class="badge bg-<?php echo e($order->payment_status === 'paid' ? 'success' : 'warning'); ?>">
                        <?php echo e(ucfirst($order->payment_status)); ?>

                    </span>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <div class="row g-3">
            <div class="col-6">
                <a href="<?php echo e(route('tracking')); ?>?code=<?php echo e($order->tracking_code); ?>" class="btn btn-mobile btn-mobile-primary w-100">
                    <i class="bi bi-search me-2"></i>
                    Track Package
                </a>
            </div>
            <div class="col-6">
                <button class="btn btn-mobile btn-mobile-success w-100" onclick="shareOrder()">
                    <i class="bi bi-share me-2"></i>
                    Share Order
                </button>
            </div>
        </div>
        
        <div class="row g-3 mt-2">
            <div class="col-6">
                <a href="<?php echo e(route('orders.index')); ?>" class="btn btn-outline-secondary w-100">
                    <i class="bi bi-arrow-left me-2"></i>
                    Back to Orders
                </a>
            </div>
            <div class="col-6">
                <button class="btn btn-outline-info w-100" onclick="printOrder()">
                    <i class="bi bi-printer me-2"></i>
                    Print Details
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Support -->
<div class="mobile-card">
    <div class="mobile-card-body text-center">
        <h6 class="mb-3">
            <i class="bi bi-headset text-primary me-2"></i>
            Need Help with this Order?
        </h6>
        <div class="row g-2">
            <div class="col-6">
                <a href="tel:+923001234567" class="btn btn-outline-success w-100">
                    <i class="bi bi-telephone"></i>
                    <br>
                    <small>Call Support</small>
                </a>
            </div>
            <div class="col-6">
                <a href="mailto:support@tcscourier.com?subject=Order Support - <?php echo e($order->tracking_code); ?>" class="btn btn-outline-info w-100">
                    <i class="bi bi-envelope"></i>
                    <br>
                    <small>Email Support</small>
                </a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Share order information
    function shareOrder() {
        const orderInfo = {
            trackingCode: '<?php echo e($order->tracking_code); ?>',
            status: '<?php echo e(ucfirst(str_replace("_", " ", $order->status))); ?>',
            amount: 'Rs. <?php echo e(number_format($order->final_price)); ?>',
            pickup: '<?php echo e($order->pickupDistrict->name); ?>',
            delivery: '<?php echo e($order->dropDistrict->name); ?>'
        };
        
        const shareText = `TCS Courier Order Details:\n\nTracking: ${orderInfo.trackingCode}\nStatus: ${orderInfo.status}\nAmount: ${orderInfo.amount}\nRoute: ${orderInfo.pickup} → ${orderInfo.delivery}\n\nTrack at: ${window.location.origin}/tracking`;
        
        if (navigator.share) {
            navigator.share({
                title: 'TCS Courier Order',
                text: shareText,
                url: window.location.href
            }).catch(err => {
                console.log('Error sharing:', err);
                fallbackShare(shareText);
            });
        } else {
            fallbackShare(shareText);
        }
    }
    
    function fallbackShare(text) {
        if (navigator.clipboard) {
            navigator.clipboard.writeText(text).then(() => {
                alert('Order details copied to clipboard!');
            }).catch(() => {
                promptShare(text);
            });
        } else {
            promptShare(text);
        }
    }
    
    function promptShare(text) {
        const textarea = document.createElement('textarea');
        textarea.value = text;
        document.body.appendChild(textarea);
        textarea.select();
        document.execCommand('copy');
        document.body.removeChild(textarea);
        alert('Order details copied to clipboard!');
    }
    
    // Print order details
    function printOrder() {
        const printContent = `
            <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
                <h2 style="text-align: center; color: #4e73df;">TCS Courier - Order Details</h2>
                <hr>
                <div style="margin: 20px 0;">
                    <h3>Order Information</h3>
                    <p><strong>Order ID:</strong> #<?php echo e($order->id); ?></p>
                    <p><strong>Tracking Code:</strong> <?php echo e($order->tracking_code); ?></p>
                    <p><strong>Status:</strong> <?php echo e(ucfirst(str_replace('_', ' ', $order->status))); ?></p>
                    <p><strong>Order Date:</strong> <?php echo e($order->created_at->format('M d, Y h:i A')); ?></p>
                </div>
                <div style="margin: 20px 0;">
                    <h3>Package Details</h3>
                    <p><strong>Type:</strong> <?php echo e(ucfirst($order->package_type)); ?></p>
                    <p><strong>Weight:</strong> <?php echo e($order->weight); ?> kg</p>
                    <p><strong>Amount:</strong> Rs. <?php echo e(number_format($order->final_price)); ?></p>
                    <p><strong>Payment Method:</strong> <?php echo e(ucfirst($order->payment_method)); ?></p>
                </div>
                <div style="margin: 20px 0;">
                    <h3>Pickup & Delivery</h3>
                    <p><strong>Pickup:</strong> <?php echo e($order->pickupDistrict->name); ?><br><?php echo e($order->pickup_address); ?></p>
                    <p><strong>Delivery:</strong> <?php echo e($order->dropDistrict->name); ?><br><?php echo e($order->drop_address); ?></p>
                </div>
                <div style="margin: 20px 0;">
                    <h3>Recipient</h3>
                    <p><strong>Name:</strong> <?php echo e($order->recipient_name); ?></p>
                    <p><strong>Phone:</strong> <?php echo e($order->recipient_phone); ?></p>
                </div>
                <?php if($order->special_instructions): ?>
                <div style="margin: 20px 0;">
                    <h3>Special Instructions</h3>
                    <p><?php echo e($order->special_instructions); ?></p>
                </div>
                <?php endif; ?>
                <hr>
                <p style="text-align: center; color: #666; font-size: 12px;">Generated on <?php echo e(now()->format('M d, Y h:i A')); ?></p>
            </div>
        `;
        
        const printWindow = window.open('', '_blank');
        printWindow.document.write(`
            <!DOCTYPE html>
            <html>
            <head>
                <title>Order Details - <?php echo e($order->tracking_code); ?></title>
                <style>
                    @media  print {
                        body { margin: 0; }
                        .no-print { display: none; }
                    }
                </style>
            </head>
            <body>
                ${printContent}
                <div class="no-print" style="text-align: center; margin: 20px;">
                    <button onclick="window.print()" style="padding: 10px 20px; background: #4e73df; color: white; border: none; border-radius: 5px; cursor: pointer;">Print</button>
                    <button onclick="window.close()" style="padding: 10px 20px; background: #6c757d; color: white; border: none; border-radius: 5px; cursor: pointer; margin-left: 10px;">Close</button>
                </div>
            </body>
            </html>
        `);
        printWindow.document.close();
    }
    
    // Add haptic feedback to buttons
    document.querySelectorAll('.btn').forEach(button => {
        button.addEventListener('click', function() {
            if ('vibrate' in navigator) {
                navigator.vibrate(50);
            }
        });
    });
    
    // Auto-refresh for non-delivered orders
    <?php if($order->status !== 'delivered'): ?>
    setInterval(() => {
        // Refresh page every 60 seconds for active orders
        window.location.reload();
    }, 60000);
    <?php endif; ?>
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.mobile', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\ASC\Desktop\Trae Projects\TCS Web app\resources\views/mobile/orders/show.blade.php ENDPATH**/ ?>