<?php $__env->startSection('title', __('mobile.my_profile')); ?>

<?php $__env->startSection('content'); ?>
<!-- Profile Header -->
<div class="mobile-card">
    <div class="mobile-card-header text-center">
        <div class="profile-avatar bg-primary text-white mb-3">
            <?php echo e(strtoupper(substr(auth()->user()->name, 0, 2))); ?>

        </div>
        <h3 class="mb-1"><?php echo e(auth()->user()->name); ?></h3>
        <p class="mb-0 opacity-75"><?php echo e(auth()->user()->email); ?></p>
    </div>
    <div class="mobile-card-body">
        <div class="row text-center">
            <div class="col-4">
                <div class="border rounded-3 p-3">
                    <div class="h4 text-primary mb-1"><?php echo e(auth()->user()->orders()->count()); ?></div>
                    <small class="text-muted">Total Orders</small>
                </div>
            </div>
            <div class="col-4">
                <div class="border rounded-3 p-3">
                    <div class="h4 text-success mb-1"><?php echo e(auth()->user()->orders()->where('status', 'delivered')->count()); ?></div>
                    <small class="text-muted">Delivered</small>
                </div>
            </div>
            <div class="col-4">
                <div class="border rounded-3 p-3">
                    <div class="h4 text-info mb-1"><?php echo e(auth()->user()->orders()->whereIn('status', ['created', 'picked', 'in_transit'])->count()); ?></div>
                    <small class="text-muted">Active</small>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <h5 class="mb-4">
            <i class="bi bi-lightning-charge text-warning me-2"></i>
            Quick Actions
        </h5>
        <div class="row g-3">
            <div class="col-6">
                <a href="<?php echo e(route('courier.create')); ?>" class="btn btn-mobile btn-mobile-primary w-100 h-100 d-flex flex-column align-items-center justify-content-center" style="min-height: 80px;">
                    <i class="bi bi-plus-circle" style="font-size: 1.5rem; margin-bottom: 8px;"></i>
                    <span>Book Courier</span>
                </a>
            </div>
            <div class="col-6">
                <a href="<?php echo e(route('orders.index')); ?>" class="btn btn-mobile btn-mobile-success w-100 h-100 d-flex flex-column align-items-center justify-content-center" style="min-height: 80px;">
                    <i class="bi bi-box-seam" style="font-size: 1.5rem; margin-bottom: 8px;"></i>
                    <span>My Orders</span>
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Personal Information -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h5 class="mb-0">
                <i class="bi bi-person text-primary me-2"></i>
                Personal Information
            </h5>
            <button class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#editProfileModal">
                <i class="bi bi-pencil"></i> Edit
            </button>
        </div>
        
        <div class="row g-3">
            <div class="col-12">
                <div class="bg-light rounded-3 p-3">
                    <label class="form-label text-muted small mb-1">Full Name</label>
                    <div class="fw-bold"><?php echo e(auth()->user()->name); ?></div>
                </div>
            </div>
            <div class="col-12">
                <div class="bg-light rounded-3 p-3">
                    <label class="form-label text-muted small mb-1">Email Address</label>
                    <div class="fw-bold"><?php echo e(auth()->user()->email); ?></div>
                </div>
            </div>
            <div class="col-12">
                <div class="bg-light rounded-3 p-3">
                    <label class="form-label text-muted small mb-1">Phone Number</label>
                    <div class="fw-bold"><?php echo e(auth()->user()->phone ?? 'Not provided'); ?></div>
                </div>
            </div>
            <div class="col-6">
                <div class="bg-light rounded-3 p-3">
                    <label class="form-label text-muted small mb-1">Account Type</label>
                    <div>
                        <span class="badge bg-<?php echo e(auth()->user()->role === 'admin' ? 'danger' : (auth()->user()->role === 'agent' ? 'warning' : 'primary')); ?>">
                            <?php echo e(ucfirst(auth()->user()->role)); ?>

                        </span>
                    </div>
                </div>
            </div>
            <div class="col-6">
                <div class="bg-light rounded-3 p-3">
                    <label class="form-label text-muted small mb-1">Member Since</label>
                    <div class="fw-bold small"><?php echo e(auth()->user()->created_at->format('M Y')); ?></div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Recent Orders -->
<?php if(auth()->user()->orders()->count() > 0): ?>
<div class="mobile-card">
    <div class="mobile-card-body">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h5 class="mb-0">
                <i class="bi bi-clock-history text-secondary me-2"></i>
                Recent Orders
            </h5>
            <a href="<?php echo e(route('orders.index')); ?>" class="btn btn-sm btn-outline-primary">
                View All
            </a>
        </div>
        
        <?php $__currentLoopData = auth()->user()->orders()->latest()->take(3)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="border rounded-3 p-3 mb-3 bg-light">
            <div class="d-flex justify-content-between align-items-start mb-2">
                <div>
                    <strong class="text-primary"><?php echo e($order->tracking_code); ?></strong>
                    <br>
                    <small class="text-muted">
                        <?php echo e($order->pickupDistrict->name); ?> → <?php echo e($order->dropDistrict->name); ?>

                    </small>
                </div>
                <span class="badge bg-<?php echo e($order->status === 'delivered' ? 'success' : ($order->status === 'in_transit' ? 'info' : 'warning')); ?>">
                    <?php echo e(ucfirst(str_replace('_', ' ', $order->status))); ?>

                </span>
            </div>
            <div class="d-flex justify-content-between align-items-center">
                <small class="text-muted">
                    <i class="bi bi-calendar me-1"></i>
                    <?php echo e($order->created_at->format('M d, Y')); ?>

                </small>
                <small class="text-success fw-bold">
                    Rs. <?php echo e(number_format($order->final_price)); ?>

                </small>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>
<?php endif; ?>

<!-- Account Settings -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <h5 class="mb-4">
            <i class="bi bi-gear text-secondary me-2"></i>
            Account Settings
        </h5>
        
        <div class="list-group list-group-flush">
            <button class="list-group-item list-group-item-action d-flex justify-content-between align-items-center" 
                    data-bs-toggle="modal" data-bs-target="#changePasswordModal">
                <div>
                    <i class="bi bi-key text-warning me-3"></i>
                    Change Password
                </div>
                <i class="bi bi-chevron-right text-muted"></i>
            </button>
            
            <a href="<?php echo e(route('orders.index')); ?>" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                <div>
                    <i class="bi bi-box-seam text-info me-3"></i>
                    Order History
                </div>
                <i class="bi bi-chevron-right text-muted"></i>
            </a>
            
            <a href="<?php echo e(route('tracking')); ?>" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                <div>
                    <i class="bi bi-search text-success me-3"></i>
                    Track Package
                </div>
                <i class="bi bi-chevron-right text-muted"></i>
            </a>
            
            <?php if(auth()->user()->role === 'admin'): ?>
            <a href="<?php echo e(route('admin.dashboard')); ?>" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                <div>
                    <i class="bi bi-speedometer2 text-danger me-3"></i>
                    Admin Dashboard
                </div>
                <i class="bi bi-chevron-right text-muted"></i>
            </a>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Support -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <h5 class="mb-4">
            <i class="bi bi-headset text-primary me-2"></i>
            Need Help?
        </h5>
        <div class="row g-3">
            <div class="col-6">
                <a href="tel:+923001234567" class="btn btn-outline-success w-100">
                    <i class="bi bi-telephone"></i>
                    <br>
                    <small>Call Support</small>
                </a>
            </div>
            <div class="col-6">
                <a href="mailto:info@tcscourier.com" class="btn btn-outline-info w-100">
                    <i class="bi bi-envelope"></i>
                    <br>
                    <small>Email Support</small>
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Edit Profile Modal -->
<div class="modal fade" id="editProfileModal" tabindex="-1">
    <div class="modal-dialog modal-fullscreen-sm-down">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Profile</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form method="POST" action="<?php echo e(route('profile.update')); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    
                    <div class="mb-3">
                        <label for="name" class="form-label">Full Name</label>
                        <input type="text" class="form-control form-control-mobile" id="name" name="name" 
                               value="<?php echo e(auth()->user()->name); ?>" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="email" class="form-label">Email Address</label>
                        <input type="email" class="form-control form-control-mobile" id="email" name="email" 
                               value="<?php echo e(auth()->user()->email); ?>" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="phone" class="form-label">Phone Number</label>
                        <input type="tel" class="form-control form-control-mobile" id="phone" name="phone" 
                               value="<?php echo e(auth()->user()->phone); ?>" placeholder="+92-300-1234567">
                    </div>
                    
                    <div class="d-grid">
                        <button type="submit" class="btn btn-mobile btn-mobile-primary">
                            <i class="bi bi-check-circle me-2"></i>
                            Update Profile
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Change Password Modal -->
<div class="modal fade" id="changePasswordModal" tabindex="-1">
    <div class="modal-dialog modal-fullscreen-sm-down">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Change Password</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form method="POST" action="<?php echo e(route('profile.update')); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    
                    <div class="mb-3">
                        <label for="current_password" class="form-label">Current Password</label>
                        <input type="password" class="form-control form-control-mobile" id="current_password" 
                               name="current_password" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="password" class="form-label">New Password</label>
                        <input type="password" class="form-control form-control-mobile" id="password" 
                               name="password" required>
                        <small class="form-text text-muted">Password must be at least 8 characters long</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="password_confirmation" class="form-label">Confirm New Password</label>
                        <input type="password" class="form-control form-control-mobile" id="password_confirmation" 
                               name="password_confirmation" required>
                    </div>
                    
                    <div class="d-grid">
                        <button type="submit" class="btn btn-mobile btn-mobile-warning">
                            <i class="bi bi-key me-2"></i>
                            Change Password
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .profile-avatar {
        width: 80px;
        height: 80px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 2rem;
        font-weight: bold;
        margin: 0 auto;
    }
    
    .list-group-item {
        border: none;
        border-radius: 8px !important;
        margin-bottom: 8px;
        background-color: var(--gray-100);
    }
    
    .list-group-item:hover {
        background-color: var(--gray-200);
        transform: translateX(5px);
        transition: all 0.3s ease;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Auto-format phone number
    document.getElementById('phone').addEventListener('input', function(e) {
        let value = e.target.value.replace(/\D/g, '');
        if (value.length > 0) {
            if (value.startsWith('92')) {
                value = '+' + value;
            } else if (!value.startsWith('+92')) {
                value = '+92' + value;
            }
        }
        e.target.value = value;
    });
    
    // Password confirmation validation
    document.getElementById('password_confirmation').addEventListener('input', function() {
        const password = document.getElementById('password').value;
        const confirmation = this.value;
        
        if (password !== confirmation) {
            this.setCustomValidity('Passwords do not match');
            this.classList.add('is-invalid');
        } else {
            this.setCustomValidity('');
            this.classList.remove('is-invalid');
            this.classList.add('is-valid');
        }
    });
    
    // Add haptic feedback to buttons
    document.querySelectorAll('.btn-mobile, .list-group-item-action').forEach(element => {
        element.addEventListener('click', function() {
            if ('vibrate' in navigator) {
                navigator.vibrate(50);
            }
        });
    });
    
    // Show success/error messages
    <?php if(session('success')): ?>
        const successAlert = document.createElement('div');
        successAlert.className = 'alert alert-success alert-mobile position-fixed';
        successAlert.style.top = '80px';
        successAlert.style.left = '15px';
        successAlert.style.right = '15px';
        successAlert.style.zIndex = '9999';
        successAlert.innerHTML = '<i class="bi bi-check-circle me-2"></i><?php echo e(session("success")); ?>';
        document.body.appendChild(successAlert);
        
        setTimeout(() => {
            successAlert.remove();
        }, 5000);
    <?php endif; ?>
    
    <?php if(session('error')): ?>
        const errorAlert = document.createElement('div');
        errorAlert.className = 'alert alert-danger alert-mobile position-fixed';
        errorAlert.style.top = '80px';
        errorAlert.style.left = '15px';
        errorAlert.style.right = '15px';
        errorAlert.style.zIndex = '9999';
        errorAlert.innerHTML = '<i class="bi bi-exclamation-triangle me-2"></i><?php echo e(session("error")); ?>';
        document.body.appendChild(errorAlert);
        
        setTimeout(() => {
            errorAlert.remove();
        }, 5000);
    <?php endif; ?>
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.mobile', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\ASC\Desktop\Trae Projects\TCS Web app\resources\views/mobile/profile/index.blade.php ENDPATH**/ ?>