<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice - <?php echo e($order->tracking_code); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        @media  print {
            .no-print {
                display: none !important;
            }
            body {
                -webkit-print-color-adjust: exact;
                color-adjust: exact;
            }
        }
        
        .invoice-header {
            border-bottom: 3px solid #007bff;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }
        
        .company-logo {
            font-size: 2rem;
            font-weight: bold;
            color: #007bff;
        }
        
        .invoice-title {
            font-size: 1.5rem;
            font-weight: bold;
            color: #333;
        }
        
        .invoice-details {
            background-color: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        
        .section-title {
            font-weight: bold;
            color: #007bff;
            border-bottom: 1px solid #dee2e6;
            padding-bottom: 5px;
            margin-bottom: 15px;
        }
        
        .info-row {
            margin-bottom: 8px;
        }
        
        .total-section {
            background-color: #e9ecef;
            padding: 15px;
            border-radius: 5px;
            border-left: 4px solid #007bff;
        }
        
        .status-badge {
            padding: 5px 10px;
            border-radius: 15px;
            font-size: 0.8rem;
            font-weight: bold;
        }
        
        .footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 1px solid #dee2e6;
            text-align: center;
            color: #6c757d;
        }
    </style>
</head>
<body>
    <div class="container mt-4">
        <!-- Print Button -->
        <div class="no-print mb-3">
            <button onclick="window.print()" class="btn btn-primary">
                <i class="bi bi-printer"></i> Print Invoice
            </button>
            <a href="<?php echo e(route('orders.show', $order)); ?>" class="btn btn-outline-secondary ms-2">
                <i class="bi bi-arrow-left"></i> Back to Order
            </a>
        </div>
        
        <!-- Invoice Header -->
        <div class="invoice-header">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="company-logo">
                        <i class="bi bi-truck"></i> TCS Courier Service
                    </div>
                    <p class="mb-0 text-muted">Fast, Reliable & Secure Delivery</p>
                </div>
                <div class="col-md-6 text-md-end">
                    <div class="invoice-title">INVOICE</div>
                    <p class="mb-0">Invoice #: <strong><?php echo e($order->tracking_code); ?></strong></p>
                    <p class="mb-0">Date: <strong><?php echo e($order->created_at->format('M d, Y')); ?></strong></p>
                </div>
            </div>
        </div>
        
        <!-- Order Status -->
        <div class="invoice-details">
            <div class="row">
                <div class="col-md-6">
                    <h6 class="section-title">Order Status</h6>
                    <div class="info-row">
                        <span class="status-badge bg-<?php echo e($order->status_badge); ?> text-white">
                            <?php echo e(ucfirst(str_replace('_', ' ', $order->status))); ?>

                        </span>
                    </div>
                    <div class="info-row">
                        <strong>Order Date:</strong> <?php echo e($order->created_at->format('M d, Y - h:i A')); ?>

                    </div>
                    <?php if($order->picked_at): ?>
                        <div class="info-row">
                            <strong>Picked Up:</strong> <?php echo e($order->picked_at->format('M d, Y - h:i A')); ?>

                        </div>
                    <?php endif; ?>
                    <?php if($order->delivered_at): ?>
                        <div class="info-row">
                            <strong>Delivered:</strong> <?php echo e($order->delivered_at->format('M d, Y - h:i A')); ?>

                        </div>
                    <?php endif; ?>
                </div>
                <div class="col-md-6">
                    <h6 class="section-title">Payment Information</h6>
                    <div class="info-row">
                        <strong>Payment Method:</strong> <?php echo e($order->payment_method === 'cod' ? 'Cash on Delivery' : ucfirst($order->payment_method)); ?>

                    </div>
                    <div class="info-row">
                        <strong>Payment Status:</strong> 
                        <span class="status-badge bg-<?php echo e($order->payment_status === 'paid' ? 'success' : ($order->payment_status === 'failed' ? 'danger' : 'warning')); ?> text-white">
                            <?php echo e(ucfirst($order->payment_status)); ?>

                        </span>
                    </div>
                    <?php if($order->payment_reference): ?>
                        <div class="info-row">
                            <strong>Reference:</strong> <?php echo e($order->payment_reference); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <!-- Delivery Information -->
        <div class="row mb-4">
            <div class="col-md-6">
                <h6 class="section-title">Pickup Information</h6>
                <div class="info-row">
                    <strong>Name:</strong> <?php echo e($order->sender_name); ?>

                </div>
                <div class="info-row">
                    <strong>Phone:</strong> <?php echo e($order->sender_phone); ?>

                </div>
                <div class="info-row">
                    <strong>Address:</strong> <?php echo e($order->sender_address); ?>

                </div>
                <div class="info-row">
                    <strong>District:</strong> <?php echo e($order->pickupDistrict->name); ?>, <?php echo e($order->pickupDistrict->province); ?>

                </div>
            </div>
            <div class="col-md-6">
                <h6 class="section-title">Delivery Information</h6>
                <div class="info-row">
                    <strong>Name:</strong> <?php echo e($order->receiver_name); ?>

                </div>
                <div class="info-row">
                    <strong>Phone:</strong> <?php echo e($order->receiver_phone); ?>

                </div>
                <div class="info-row">
                    <strong>Address:</strong> <?php echo e($order->receiver_address); ?>

                </div>
                <div class="info-row">
                    <strong>District:</strong> <?php echo e($order->dropDistrict->name); ?>, <?php echo e($order->dropDistrict->province); ?>

                </div>
            </div>
        </div>
        
        <!-- Package Details -->
        <div class="mb-4">
            <h6 class="section-title">Package Details</h6>
            <div class="row">
                <div class="col-md-3">
                    <div class="info-row">
                        <strong>Weight:</strong> <?php echo e($order->weight); ?> kg
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="info-row">
                        <strong>Size:</strong> <?php echo e($order->size); ?>

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="info-row">
                        <strong>Category:</strong> <?php echo e($order->category); ?>

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="info-row">
                        <strong>Vehicle:</strong> <?php echo e(ucfirst($order->vehicle_type)); ?>

                    </div>
                </div>
            </div>
            <div class="row mt-2">
                <div class="col-md-6">
                    <div class="info-row">
                        <strong>Delivery Type:</strong> <?php echo e(ucfirst(str_replace('_', ' ', $order->delivery_type))); ?>

                    </div>
                </div>
                <?php if($order->description): ?>
                    <div class="col-md-6">
                        <div class="info-row">
                            <strong>Description:</strong> <?php echo e($order->description); ?>

                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Service Provider Information -->
        <?php if($order->assignedOffice): ?>
            <div class="mb-4">
                <h6 class="section-title">Service Provider</h6>
                <div class="row">
                    <div class="col-md-6">
                        <div class="info-row">
                            <strong>Office:</strong> <?php echo e($order->assignedOffice->name); ?>

                        </div>
                        <div class="info-row">
                            <strong>Address:</strong> <?php echo e($order->assignedOffice->address); ?>

                        </div>
                        <div class="info-row">
                            <strong>Phone:</strong> <?php echo e($order->assignedOffice->phone); ?>

                        </div>
                    </div>
                    <?php if($order->assignedAgent): ?>
                        <div class="col-md-6">
                            <div class="info-row">
                                <strong>Agent:</strong> <?php echo e($order->assignedAgent->user->name); ?>

                            </div>
                            <div class="info-row">
                                <strong>Agent Code:</strong> <?php echo e($order->assignedAgent->agent_code); ?>

                            </div>
                            <div class="info-row">
                                <strong>Agent Phone:</strong> <?php echo e($order->assignedAgent->phone); ?>

                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
        
        <!-- Pricing Breakdown -->
        <div class="total-section">
            <h6 class="section-title mb-3">Pricing Details</h6>
            <div class="row">
                <div class="col-md-8">
                    <div class="info-row">
                        <strong>Service Charges:</strong>
                    </div>
                    <div class="info-row text-muted">
                        • Base delivery charge
                    </div>
                    <div class="info-row text-muted">
                        • Weight-based pricing (<?php echo e($order->weight); ?> kg)
                    </div>
                    <div class="info-row text-muted">
                        • <?php echo e(ucfirst(str_replace('_', ' ', $order->delivery_type))); ?> delivery
                    </div>
                    <div class="info-row text-muted">
                        • <?php echo e(ucfirst($order->vehicle_type)); ?> transportation
                    </div>
                </div>
                <div class="col-md-4 text-end">
                    <div class="info-row">
                        <strong>PKR <?php echo e(number_format($order->estimated_price, 2)); ?></strong>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="col-md-8">
                    <h5 class="mb-0"><strong>Total Amount:</strong></h5>
                </div>
                <div class="col-md-4 text-end">
                    <h5 class="mb-0 text-primary"><strong>PKR <?php echo e(number_format($order->final_price, 2)); ?></strong></h5>
                </div>
            </div>
        </div>
        
        <!-- Terms and Conditions -->
        <div class="mt-4">
            <h6 class="section-title">Terms & Conditions</h6>
            <div class="row">
                <div class="col-12">
                    <ul class="small text-muted">
                        <li>This invoice is generated electronically and is valid without signature.</li>
                        <li>Package insurance is included up to PKR 5,000 for standard deliveries.</li>
                        <li>Delivery time estimates are approximate and may vary due to weather or traffic conditions.</li>
                        <li>For COD orders, payment must be collected from the receiver before delivery.</li>
                        <li>Any disputes must be reported within 24 hours of delivery.</li>
                        <li>TCS Courier Service reserves the right to inspect packages for security purposes.</li>
                        <li>Prohibited items include hazardous materials, illegal substances, and perishable goods.</li>
                        <li>Customer support is available 24/7 at +92-300-1234567 or support@tcscourier.com</li>
                    </ul>
                </div>
            </div>
        </div>
        
        <?php if($order->notes): ?>
            <div class="mt-3">
                <h6 class="section-title">Additional Notes</h6>
                <p class="text-muted"><?php echo e($order->notes); ?></p>
            </div>
        <?php endif; ?>
        
        <!-- Footer -->
        <div class="footer">
            <div class="row">
                <div class="col-md-4">
                    <strong>TCS Courier Service</strong><br>
                    <small>
                        Email: info@tcscourier.com<br>
                        Phone: +92-300-1234567<br>
                        Website: www.tcscourier.com
                    </small>
                </div>
                <div class="col-md-4">
                    <strong>Customer Support</strong><br>
                    <small>
                        24/7 Helpline: +92-300-1234567<br>
                        Email: support@tcscourier.com<br>
                        Live Chat: Available on website
                    </small>
                </div>
                <div class="col-md-4">
                    <strong>Track Your Package</strong><br>
                    <small>
                        Tracking Code: <?php echo e($order->tracking_code); ?><br>
                        Visit: www.tcscourier.com/track<br>
                        SMS: Send tracking code to 8080
                    </small>
                </div>
            </div>
            <hr>
            <p class="small mb-0">
                <strong>Thank you for choosing TCS Courier Service!</strong><br>
                This invoice was generated on <?php echo e(now()->format('M d, Y \\a\\t h:i A')); ?>

            </p>
        </div>
    </div>
    
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    
    <script>
        // Auto-print functionality
        window.addEventListener('load', function() {
            // Check if opened in new tab for printing
            if (window.location.search.includes('print=1')) {
                setTimeout(() => {
                    window.print();
                }, 500);
            }
        });
        
        // Print function
        function printInvoice() {
            window.print();
        }
    </script>
</body>
</html><?php /**PATH /home/khanozai/portal.topcourierservice.com.pk/resources/views/orders/invoice.blade.php ENDPATH**/ ?>