<?php $__env->startSection('title', 'My Orders'); ?>

<?php $__env->startSection('content'); ?>
<!-- Orders Header -->
<div class="mobile-card">
    <div class="mobile-card-header text-center">
        <h2 class="mb-2">
            <i class="bi bi-box-seam me-2"></i>
            <?php echo e(__('mobile.my_orders')); ?>

        </h2>
        <p class="mb-0 opacity-75"><?php echo e(__('mobile.track_manage_orders')); ?></p>
    </div>
    <div class="mobile-card-body">
        <div class="row text-center">
            <div class="col-3">
                <div class="border rounded-3 p-2">
                    <div class="h5 text-primary mb-1"><?php echo e($orders->total()); ?></div>
                    <small class="text-muted">Total</small>
                </div>
            </div>
            <div class="col-3">
                <div class="border rounded-3 p-2">
                    <div class="h5 text-warning mb-1"><?php echo e($orders->where('status', 'created')->count() + $orders->where('status', 'picked')->count()); ?></div>
                    <small class="text-muted">Active</small>
                </div>
            </div>
            <div class="col-3">
                <div class="border rounded-3 p-2">
                    <div class="h5 text-info mb-1"><?php echo e($orders->where('status', 'in_transit')->count()); ?></div>
                    <small class="text-muted">Transit</small>
                </div>
            </div>
            <div class="col-3">
                <div class="border rounded-3 p-2">
                    <div class="h5 text-success mb-1"><?php echo e($orders->where('status', 'delivered')->count()); ?></div>
                    <small class="text-muted">Delivered</small>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <div class="row g-3">
            <div class="col-6">
                <a href="<?php echo e(route('courier.create')); ?>" class="btn btn-mobile btn-mobile-primary w-100">
                    <i class="bi bi-plus-circle me-2"></i>
                    Book New Order
                </a>
            </div>
            <div class="col-6">
                <a href="<?php echo e(route('tracking')); ?>" class="btn btn-mobile btn-mobile-success w-100">
                    <i class="bi bi-search me-2"></i>
                    Track Package
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Filter & Search -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <form method="GET" action="<?php echo e(route('orders.index')); ?>">
            <div class="row g-3">
                <div class="col-8">
                    <input type="text" class="form-control form-control-mobile" 
                           name="search" value="<?php echo e(request('search')); ?>" 
                           placeholder="Search by tracking code...">
                </div>
                <div class="col-4">
                    <button type="submit" class="btn btn-mobile btn-mobile-primary w-100">
                        <i class="bi bi-search"></i>
                    </button>
                </div>
            </div>
            <div class="row g-2 mt-2">
                <div class="col-6">
                    <select class="form-control form-control-mobile" name="status">
                        <option value="">All Status</option>
                        <option value="created" <?php echo e(request('status') == 'created' ? 'selected' : ''); ?>>Created</option>
                        <option value="picked" <?php echo e(request('status') == 'picked' ? 'selected' : ''); ?>>Picked</option>
                        <option value="in_transit" <?php echo e(request('status') == 'in_transit' ? 'selected' : ''); ?>>In Transit</option>
                        <option value="delivered" <?php echo e(request('status') == 'delivered' ? 'selected' : ''); ?>>Delivered</option>
                    </select>
                </div>
                <div class="col-6">
                    <a href="<?php echo e(route('orders.index')); ?>" class="btn btn-outline-secondary w-100">
                        <i class="bi bi-x-circle me-1"></i>Clear
                    </a>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Orders List -->
<?php if($orders->count() > 0): ?>
    <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="mobile-card">
        <div class="mobile-card-body">
            <div class="d-flex justify-content-between align-items-start mb-3">
                <div>
                    <h6 class="text-primary mb-1"><?php echo e($order->tracking_code); ?></h6>
                    <small class="text-muted">
                        <i class="bi bi-calendar me-1"></i>
                        <?php echo e($order->created_at->format('M d, Y h:i A')); ?>

                    </small>
                </div>
                <span class="badge bg-<?php echo e($order->status === 'delivered' ? 'success' : ($order->status === 'in_transit' ? 'info' : ($order->status === 'picked' ? 'warning' : 'secondary'))); ?> fs-6">
                    <?php echo e(ucfirst(str_replace('_', ' ', $order->status))); ?>

                </span>
            </div>
            
            <div class="row g-3 mb-3">
                <div class="col-6">
                    <div class="bg-light rounded-3 p-3">
                        <small class="text-muted d-block mb-1">
                            <i class="bi bi-geo-alt text-primary me-1"></i>From
                        </small>
                        <strong class="small"><?php echo e($order->pickupDistrict->name); ?></strong>
                        <div class="text-muted small mt-1"><?php echo e(Str::limit($order->pickup_address, 30)); ?></div>
                    </div>
                </div>
                <div class="col-6">
                    <div class="bg-light rounded-3 p-3">
                        <small class="text-muted d-block mb-1">
                            <i class="bi bi-geo-alt-fill text-danger me-1"></i>To
                        </small>
                        <strong class="small"><?php echo e($order->dropDistrict->name); ?></strong>
                        <div class="text-muted small mt-1"><?php echo e(Str::limit($order->drop_address, 30)); ?></div>
                    </div>
                </div>
            </div>
            
            <div class="row g-3 mb-3">
                <div class="col-4">
                    <div class="text-center">
                        <div class="text-muted small">Package</div>
                        <strong class="small"><?php echo e(ucfirst($order->package_type)); ?></strong>
                    </div>
                </div>
                <div class="col-4">
                    <div class="text-center">
                        <div class="text-muted small">Weight</div>
                        <strong class="small"><?php echo e($order->weight); ?> kg</strong>
                    </div>
                </div>
                <div class="col-4">
                    <div class="text-center">
                        <div class="text-muted small">Amount</div>
                        <strong class="text-success small">Rs. <?php echo e(number_format($order->final_price)); ?></strong>
                    </div>
                </div>
            </div>
            
            <div class="d-flex justify-content-between align-items-center">
                <div class="small text-muted">
                    <i class="bi bi-person me-1"></i>
                    <?php echo e($order->recipient_name); ?>

                    <br>
                    <i class="bi bi-telephone me-1"></i>
                    <?php echo e($order->recipient_phone); ?>

                </div>
                <div class="d-flex gap-2">
                    <a href="<?php echo e(route('orders.show', $order)); ?>" class="btn btn-sm btn-outline-primary">
                        <i class="bi bi-eye"></i>
                    </a>
                    <?php if($order->status !== 'delivered'): ?>
                        <a href="<?php echo e(route('tracking')); ?>?code=<?php echo e($order->tracking_code); ?>" class="btn btn-sm btn-outline-success">
                            <i class="bi bi-search"></i>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    
    <!-- Pagination -->
    <?php if($orders->hasPages()): ?>
    <div class="mobile-card">
        <div class="mobile-card-body text-center">
            <?php echo e($orders->appends(request()->query())->links()); ?>

        </div>
    </div>
    <?php endif; ?>
<?php else: ?>
    <!-- Empty State -->
    <div class="mobile-card">
        <div class="mobile-card-body text-center py-5">
            <i class="bi bi-box-seam text-muted" style="font-size: 4rem;"></i>
            <h4 class="text-muted mt-3">No Orders Found</h4>
            <p class="text-muted mb-4">
                <?php if(request('search') || request('status')): ?>
                    No orders match your search criteria.
                <?php else: ?>
                    You haven't placed any orders yet.
                <?php endif; ?>
            </p>
            <?php if(request('search') || request('status')): ?>
                <a href="<?php echo e(route('orders.index')); ?>" class="btn btn-mobile btn-mobile-secondary mb-3">
                    <i class="bi bi-arrow-clockwise me-2"></i>
                    Clear Filters
                </a>
            <?php endif; ?>
            <a href="<?php echo e(route('courier.create')); ?>" class="btn btn-mobile btn-mobile-primary">
                <i class="bi bi-plus-circle me-2"></i>
                Book Your First Order
            </a>
        </div>
    </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Auto-submit form on status change
    document.querySelector('select[name="status"]').addEventListener('change', function() {
        this.form.submit();
    });
    
    // Add haptic feedback to order cards
    document.querySelectorAll('.mobile-card').forEach(card => {
        card.addEventListener('click', function(e) {
            if (e.target.tagName !== 'A' && e.target.tagName !== 'BUTTON') {
                if ('vibrate' in navigator) {
                    navigator.vibrate(50);
                }
            }
        });
    });
    
    // Pull to refresh functionality
    let startY = 0;
    let currentY = 0;
    let pullDistance = 0;
    const pullThreshold = 100;
    
    document.addEventListener('touchstart', function(e) {
        if (window.scrollY === 0) {
            startY = e.touches[0].clientY;
        }
    });
    
    document.addEventListener('touchmove', function(e) {
        if (window.scrollY === 0 && startY > 0) {
            currentY = e.touches[0].clientY;
            pullDistance = currentY - startY;
            
            if (pullDistance > 0) {
                e.preventDefault();
                document.body.style.transform = `translateY(${Math.min(pullDistance / 3, 50)}px)`;
                document.body.style.opacity = Math.max(0.5, 1 - (pullDistance / 300));
            }
        }
    });
    
    document.addEventListener('touchend', function(e) {
        if (pullDistance > pullThreshold) {
            // Refresh the page
            window.location.reload();
        } else {
            // Reset the transform
            document.body.style.transform = '';
            document.body.style.opacity = '';
        }
        startY = 0;
        currentY = 0;
        pullDistance = 0;
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.mobile', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/khanozai/portal.topcourierservice.com.pk/resources/views/mobile/orders/index.blade.php ENDPATH**/ ?>