<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="theme-color" content="#4e73df">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="apple-mobile-web-app-title" content="TCS Courier">
    
    <title><?php echo $__env->yieldContent('title', 'TCS Courier'); ?> - Mobile App</title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    <link rel="apple-touch-icon" href="/favicon.ico">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    
    <!-- PWA Manifest -->
    <link rel="manifest" href="/manifest.json">
    
    <!-- PWA Meta Tags -->
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="apple-mobile-web-app-title" content="TCS Courier">
    <meta name="application-name" content="TCS Courier">
    <meta name="msapplication-TileColor" content="#4e73df">
    <meta name="msapplication-config" content="/browserconfig.xml">
    
    <!-- PWA Icons -->
    <link rel="apple-touch-icon" sizes="180x180" href="/favicon.ico">
    <link rel="icon" type="image/png" sizes="32x32" href="/favicon.ico">
    <link rel="icon" type="image/png" sizes="16x16" href="/favicon.ico">
    <link rel="mask-icon" href="/favicon.ico" color="#4e73df">
    
    <!-- PWA Startup Images -->
    <link rel="apple-touch-startup-image" href="/favicon.ico">
    
    <!-- Preload Critical Resources -->
    <link rel="preload" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" as="style">
    <link rel="preload" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" as="style">
    
    <!-- Old English Font -->
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Cinzel:wght@400;500;600;700&family=UnifrakturMaguntia&display=swap" as="style">
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@400;500;600;700&family=UnifrakturMaguntia&display=swap" rel="stylesheet">
    
    <?php echo $__env->yieldPushContent('head'); ?>
    
    <!-- Mobile App Styles -->
    <style>
        :root {
            --primary-color: #4e73df;
            --secondary-color: #858796;
            --success-color: #1cc88a;
            --info-color: #36b9cc;
            --warning-color: #f6c23e;
            --danger-color: #e74a3b;
            --light-color: #f8f9fc;
            --dark-color: #5a5c69;
            --white: #ffffff;
            --gray-100: #f8f9fa;
            --gray-200: #e9ecef;
            --gray-300: #dee2e6;
            --gray-400: #ced4da;
            --gray-500: #adb5bd;
            --gray-600: #6c757d;
            --gray-700: #495057;
            --gray-800: #343a40;
            --gray-900: #212529;
            --border-radius: 12px;
            --shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
            --shadow-lg: 0 1rem 3rem rgba(0, 0, 0, 0.175);
        }
        
        * {
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Nunito', -apple-system, BlinkMacSystemFont, 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            background-color: var(--gray-100);
            margin: 0;
            padding: 0;
            padding-top: 70px; /* Top bar height */
            padding-bottom: 80px; /* Bottom tab bar height */
            overflow-x: hidden;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
        }
        
        /* Top Bar */
        .mobile-top-bar {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            height: 70px;
            background: linear-gradient(135deg, var(--primary-color) 0%, #6f42c1 100%);
            color: white;
            z-index: 1000;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 20px;
            box-shadow: var(--shadow);
        }
        
        .mobile-top-bar .logo {
            font-size: 1.5rem;
            font-weight: 700;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .mobile-top-bar .actions {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .mobile-top-bar .btn {
            background: rgba(255, 255, 255, 0.2);
            border: 1px solid rgba(255, 255, 255, 0.3);
            color: white;
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 0.875rem;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        
        .mobile-top-bar .btn:hover {
            background: rgba(255, 255, 255, 0.3);
            border-color: rgba(255, 255, 255, 0.5);
            color: white;
            transform: translateY(-1px);
        }
        
        /* Main Content */
        .mobile-content {
            min-height: calc(100vh - 155px);
            padding: 20px 15px 100px 15px;
            background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%);
        }
        
        /* Bottom Tab Bar */
        .mobile-bottom-tabs {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            height: 85px;
            background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
            border-top: 2px solid rgba(78, 115, 223, 0.1);
            z-index: 1000;
            display: flex;
            align-items: center;
            justify-content: space-around;
            padding: 10px 5px;
            box-shadow: 0 -4px 20px rgba(0, 0, 0, 0.15);
            backdrop-filter: blur(10px);
        }
        
        .mobile-tab {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            text-decoration: none;
            color: #6c757d;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            padding: 10px 8px;
            border-radius: 16px;
            min-width: 65px;
            position: relative;
            background: transparent;
        }
        
        .mobile-tab.active {
            color: var(--primary-color);
            background: linear-gradient(135deg, rgba(78, 115, 223, 0.15) 0%, rgba(111, 66, 193, 0.1) 100%);
            transform: translateY(-3px);
            box-shadow: 0 4px 15px rgba(78, 115, 223, 0.3);
        }
        
        .mobile-tab:hover {
            color: var(--primary-color);
            text-decoration: none;
            transform: translateY(-2px);
            background: rgba(78, 115, 223, 0.08);
        }
        
        .mobile-tab i {
            font-size: 1.6rem;
            margin-bottom: 6px;
            transition: all 0.3s ease;
        }
        
        .mobile-tab.active i {
            transform: scale(1.1);
        }
        
        .mobile-tab span {
            font-size: 0.75rem;
            font-weight: 500;
            text-align: center;
        }
        
        .mobile-tab .badge {
            position: absolute;
            top: 2px;
            right: 8px;
            background: var(--danger-color);
            color: white;
            border-radius: 10px;
            padding: 2px 6px;
            font-size: 0.6rem;
            min-width: 18px;
            height: 18px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        /* Cards */
        .mobile-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
            margin-bottom: 25px;
            overflow: hidden;
            border: 1px solid rgba(78, 115, 223, 0.1);
            transition: all 0.3s ease;
        }
        
        .mobile-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 12px 35px rgba(0, 0, 0, 0.15);
        }
        
        .mobile-card-header {
            background: linear-gradient(135deg, var(--primary-color) 0%, #6f42c1 100%);
            color: white;
            padding: 25px 20px;
            border: none;
            position: relative;
        }
        
        .mobile-card-header::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, rgba(255,255,255,0.3) 0%, rgba(255,255,255,0.1) 100%);
        }
        
        .mobile-card-body {
            padding: 25px 20px;
        }
        
        /* Buttons */
        .btn-mobile {
            border-radius: 30px;
            padding: 14px 28px;
            font-weight: 600;
            font-size: 0.95rem;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            border: none;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.15);
            position: relative;
            overflow: hidden;
        }
        
        .btn-mobile::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
            transition: left 0.6s;
        }
        
        .btn-mobile:hover::before {
            left: 100%;
        }
        
        .btn-mobile:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.2);
        }
        
        .btn-mobile:active {
            transform: translateY(-1px);
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
        }
        
        .btn-mobile-primary {
            background: linear-gradient(135deg, var(--primary-color) 0%, #6f42c1 100%);
            color: white;
        }
        
        .btn-mobile-success {
            background: linear-gradient(135deg, var(--success-color) 0%, #17a2b8 100%);
            color: white;
        }
        
        .btn-mobile-warning {
            background: linear-gradient(135deg, var(--warning-color) 0%, #fd7e14 100%);
            color: white;
        }
        
        .btn-mobile-danger {
            background: linear-gradient(135deg, var(--danger-color) 0%, #dc3545 100%);
            color: white;
        }
        
        .btn-mobile-secondary {
            background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
            color: white;
        }
        
        /* Form Controls */
        .form-control-mobile {
            border-radius: 15px;
            padding: 15px 18px;
            border: 2px solid #e9ecef;
            font-size: 1rem;
            transition: all 0.3s ease;
            background: #f8f9fa;
        }
        
        .form-control-mobile:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
            background: white;
            transform: translateY(-1px);
        }
        
        /* Alert Styles */
        .alert-mobile {
            border-radius: 15px;
            padding: 18px 20px;
            border: none;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
        }
        
        /* Loading Improvements */
        .mobile-loading {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(255, 255, 255, 0.9);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 9999;
            backdrop-filter: blur(5px);
        }
        
        .mobile-spinner {
            width: 50px;
            height: 50px;
            border: 4px solid rgba(78, 115, 223, 0.3);
            border-top: 4px solid var(--primary-color);
            border-radius: 50%;
            animation: spin 1s linear infinite;
         }
         
         /* Floating Action Button */
         .mobile-fab {
             position: fixed;
             bottom: 100px;
             right: 20px;
             width: 60px;
             height: 60px;
             background: linear-gradient(135deg, var(--primary-color) 0%, #6f42c1 100%);
             border-radius: 50%;
             display: flex;
             align-items: center;
             justify-content: center;
             color: white;
             font-size: 1.5rem;
             box-shadow: 0 8px 25px rgba(78, 115, 223, 0.4);
             z-index: 999;
             transition: all 0.3s ease;
             text-decoration: none;
         }
         
         .mobile-fab:hover {
             transform: scale(1.1) translateY(-2px);
             box-shadow: 0 12px 35px rgba(78, 115, 223, 0.5);
             color: white;
         }
         
         .mobile-fab:active {
              transform: scale(0.95);
          }
        }
        
        .form-control-mobile:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
        }
        
        /* Alerts */
        .alert-mobile {
            border-radius: 12px;
            border: none;
            padding: 16px 20px;
            margin-bottom: 20px;
            box-shadow: var(--shadow);
        }
        
        /* Loading Spinner */
        .mobile-loading {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(255, 255, 255, 0.9);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 9999;
        }
        
        .mobile-spinner {
            width: 40px;
            height: 40px;
            border: 4px solid var(--gray-300);
            border-top: 4px solid var(--primary-color);
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }
        
        @keyframes  spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        /* Responsive adjustments */
        @media (max-width: 576px) {
            .mobile-content {
                padding: 15px 10px;
            }
            
            .mobile-top-bar {
                padding: 0 15px;
            }
            
            .mobile-top-bar .logo {
                font-size: 1.25rem;
            }
            
            .mobile-tab span {
                font-size: 0.7rem;
            }
        }
        
        /* Hide scrollbars but keep functionality */
        ::-webkit-scrollbar {
            width: 0px;
            background: transparent;
        }
        
        /* Hide all navbar elements on mobile */
        .navbar-toggler,
        .navbar-toggler-icon,
        .navbar-collapse,
        .navbar-nav,
        .navbar,
        nav.navbar {
            display: none !important;
            visibility: hidden !important;
        }
        
        /* Old English Language Styles */
        .olde-text,
        [lang="ur"],
        .lang-ur {
            font-family: 'Cinzel', 'UnifrakturMaguntia', serif !important;
            direction: ltr;
            text-align: left;
            line-height: 1.6;
            font-size: 1.05em;
            letter-spacing: 0.5px;
        }
        
        .olde-text h1, .olde-text h2, .olde-text h3, .olde-text h4, .olde-text h5, .olde-text h6,
        [lang="ur"] h1, [lang="ur"] h2, [lang="ur"] h3, [lang="ur"] h4, [lang="ur"] h5, [lang="ur"] h6 {
            font-family: 'Cinzel', 'UnifrakturMaguntia', serif !important;
            font-weight: 600;
            line-height: 1.4;
            letter-spacing: 1px;
        }
        
        .olde-text .btn, [lang="ur"] .btn {
            font-family: 'Cinzel', serif !important;
            font-weight: 500;
            letter-spacing: 0.5px;
        }
        
        .olde-text input, .olde-text textarea, .olde-text select,
        [lang="ur"] input, [lang="ur"] textarea, [lang="ur"] select {
            font-family: 'Cinzel', serif !important;
            direction: ltr;
            text-align: left;
        }
        
        .olde-text input::placeholder, .olde-text textarea::placeholder,
        [lang="ur"] input::placeholder, [lang="ur"] textarea::placeholder {
            direction: ltr;
            text-align: left;
            font-style: italic;
        }
        
        /* Language Switcher */
        .language-switcher {
            position: relative;
            display: inline-block;
        }
        
        .language-btn {
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            color: white;
            padding: 8px 12px;
            border-radius: 20px;
            font-size: 0.85rem;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 5px;
        }
        
        .language-btn:hover {
            background: rgba(255, 255, 255, 0.2);
            border-color: rgba(255, 255, 255, 0.3);
            transform: translateY(-1px);
        }
        
        .language-dropdown {
            position: absolute;
            top: 100%;
            right: 0;
            background: white;
            border-radius: 10px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
            min-width: 120px;
            z-index: 1000;
            opacity: 0;
            visibility: hidden;
            transform: translateY(-10px);
            transition: all 0.3s ease;
        }
        
        .language-dropdown.show {
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }
        
        .language-option {
            padding: 10px 15px;
            cursor: pointer;
            transition: background-color 0.2s ease;
            display: flex;
            align-items: center;
            gap: 8px;
            color: #333;
            text-decoration: none;
        }
        
        .language-option:hover {
            background-color: #f8f9fa;
            color: #4e73df;
        }
        
        .language-option.active {
            background-color: #4e73df;
            color: white;
        }
        
        .language-option:first-child {
            border-radius: 10px 10px 0 0;
        }
        
        .language-option:last-child {
            border-radius: 0 0 10px 10px;
        }
        
        /* RTL Layout Adjustments */
        .rtl {
            direction: rtl;
        }
        
        .rtl .mobile-tab-bar {
            direction: ltr; /* Keep navigation LTR for consistency */
        }
        
        .rtl .mobile-top-bar {
            direction: rtl;
        }
        
        .rtl .mobile-top-bar .d-flex {
            flex-direction: row-reverse;
        }
        
        .rtl .alert {
            text-align: right;
        }
        
        .rtl .text-center {
            text-align: center !important;
        }
        
        .rtl .text-left {
            text-align: right !important;
        }
        
        .rtl .text-right {
            text-align: left !important;
        }
        
        .rtl .me-2 {
            margin-left: 0.5rem !important;
            margin-right: 0 !important;
        }
        
        .rtl .ms-2 {
            margin-right: 0.5rem !important;
            margin-left: 0 !important;
        }
        
        /* Smooth scrolling */
        html {
            scroll-behavior: smooth;
        }
        
        /* Touch-friendly interactions */
        .mobile-tab, .btn-mobile {
            -webkit-tap-highlight-color: transparent;
            touch-action: manipulation;
        }
    </style>
    
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body class="<?php echo e(app()->getLocale() === 'ur' ? 'lang-ur olde-text' : ''); ?>" lang="<?php echo e(app()->getLocale()); ?>">
    <!-- Top Bar -->
    <div class="mobile-top-bar">
        <div class="logo">
            <i class="bi bi-truck"></i>
            <span>TCS Courier</span>
        </div>
        <div class="actions">
            <div class="d-flex align-items-center gap-2">

                <?php if(auth()->guard()->check()): ?>
                    <form method="POST" action="<?php echo e(route('logout')); ?>" class="d-inline">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn btn-sm btn-outline-light">
                            <i class="bi bi-box-arrow-right"></i>
                        </button>
                    </form>
                <?php else: ?>
                    <a href="<?php echo e(route('login')); ?>" class="btn btn-sm btn-outline-light">
                        <i class="bi bi-person"></i>
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <!-- Main Content -->
    <div class="mobile-content">
        <?php echo $__env->yieldContent('content'); ?>
    </div>
    
    <!-- Floating Action Button -->
    <a href="<?php echo e(route('courier.create')); ?>" class="mobile-fab" title="<?php echo e(__('mobile.book_courier')); ?>">
        <i class="bi bi-plus"></i>
    </a>
    
    <!-- Bottom Tab Bar -->
    <div class="mobile-bottom-tabs">
        <?php if(auth()->guard()->guest()): ?>
            <a href="<?php echo e(route('login')); ?>" class="mobile-tab <?php echo e(request()->routeIs('login') ? 'active' : ''); ?>">
                <i class="bi bi-box-arrow-in-right"></i>
                <span><?php echo e(__('mobile.login')); ?></span>
            </a>
        <?php else: ?>
            <a href="<?php echo e(route('profile')); ?>" class="mobile-tab <?php echo e(request()->routeIs('profile') ? 'active' : ''); ?>">
                <i class="bi bi-person-circle"></i>
                <span><?php echo e(__('mobile.profile')); ?></span>
            </a>
        <?php endif; ?>
        
        <a href="<?php echo e(route('orders.index')); ?>" class="mobile-tab <?php echo e(request()->routeIs('orders.*') ? 'active' : ''); ?>">
            <i class="bi bi-box-seam"></i>
            <span><?php echo e(__('mobile.orders')); ?></span>
            <?php if(auth()->guard()->check()): ?>
                <?php if(auth()->user()->orders()->whereIn('status', ['created', 'picked', 'in_transit'])->count() > 0): ?>
                    <span class="badge"><?php echo e(auth()->user()->orders()->whereIn('status', ['created', 'picked', 'in_transit'])->count()); ?></span>
                <?php endif; ?>
            <?php endif; ?>
        </a>
        
        <a href="<?php echo e(route('tracking')); ?>" class="mobile-tab <?php echo e(request()->routeIs('tracking*') ? 'active' : ''); ?>">
            <i class="bi bi-search"></i>
            <span><?php echo e(__('mobile.tracking')); ?></span>
        </a>
    </div>
    
    <!-- Loading Overlay -->
    <div class="mobile-loading" id="mobileLoading" style="display: none;">
        <div class="mobile-spinner"></div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- PWA & Mobile App JavaScript -->
    <script>
        // PWA Variables
        let deferredPrompt;
        let isOnline = navigator.onLine;
        let swRegistration = null;
        
        // Mobile app functionality
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize PWA features
            initializePWA();
            
            // Add touch feedback to interactive elements
            const touchElements = document.querySelectorAll('.mobile-tab, .btn-mobile');
            touchElements.forEach(element => {
                element.addEventListener('touchstart', function() {
                    this.style.transform = 'scale(0.95)';
                });
                
                element.addEventListener('touchend', function() {
                    setTimeout(() => {
                        this.style.transform = '';
                    }, 150);
                });
            });
            
            // Show loading overlay for navigation
            const navLinks = document.querySelectorAll('.mobile-tab');
            navLinks.forEach(link => {
                link.addEventListener('click', function(e) {
                    if (this.href && !this.href.includes('#')) {
                        showLoading();
                    }
                });
            });
            
            // Hide loading on page load
            hideLoading();
            
            // Initialize offline detection
            initializeOfflineDetection();
        });
        
        // PWA Initialization
        function initializePWA() {
            // Register Service Worker
            if ('serviceWorker' in navigator) {
                registerServiceWorker();
            }
            
            // Handle app installation
            handleAppInstallation();
            
            // Initialize push notifications
            if ('Notification' in window && 'serviceWorker' in navigator) {
                initializePushNotifications();
            }
            
            // Handle app updates
            handleAppUpdates();
        }
        
        // Service Worker Registration
        async function registerServiceWorker() {
            try {
                swRegistration = await navigator.serviceWorker.register('/sw.js', {
                    scope: '/'
                });
                
                console.log('Service Worker registered successfully:', swRegistration);
                
                // Listen for updates
                swRegistration.addEventListener('updatefound', () => {
                    const newWorker = swRegistration.installing;
                    newWorker.addEventListener('statechange', () => {
                        if (newWorker.state === 'installed' && navigator.serviceWorker.controller) {
                            showUpdateAvailable();
                        }
                    });
                });
                
            } catch (error) {
                console.error('Service Worker registration failed:', error);
            }
        }
        
        // App Installation Handling
        function handleAppInstallation() {
            window.addEventListener('beforeinstallprompt', (e) => {
                e.preventDefault();
                deferredPrompt = e;
                
                // Show install banner after 3 seconds
                setTimeout(() => {
                    showInstallBanner();
                }, 3000);
            });
            
            // Handle successful installation
            window.addEventListener('appinstalled', () => {
                console.log('PWA was installed');
                hideInstallBanner();
                showNotification('App Installed', 'TCS Courier has been added to your home screen!');
            });
        }
        
        // Show Install Banner
        function showInstallBanner() {
            if (deferredPrompt && !localStorage.getItem('installBannerDismissed')) {
                const installBanner = document.createElement('div');
                installBanner.id = 'installBanner';
                installBanner.className = 'install-banner';
                installBanner.innerHTML = `
                    <div class="alert alert-primary alert-mobile d-flex justify-content-between align-items-center position-fixed" style="top: 80px; left: 15px; right: 15px; z-index: 9999; box-shadow: 0 4px 20px rgba(0,0,0,0.3);">
                        <div>
                            <i class="bi bi-download me-2"></i>
                            <strong>Install TCS Courier App</strong>
                            <br><small>Get faster access and offline features</small>
                        </div>
                        <div>
                            <button class="btn btn-sm btn-light me-2" onclick="installApp()">Install</button>
                            <button class="btn btn-sm btn-outline-light" onclick="dismissInstallBanner()">×</button>
                        </div>
                    </div>
                `;
                
                document.body.appendChild(installBanner);
            }
        }
        
        // Install App
        function installApp() {
            if (deferredPrompt) {
                deferredPrompt.prompt();
                deferredPrompt.userChoice.then((choiceResult) => {
                    if (choiceResult.outcome === 'accepted') {
                        console.log('User accepted the install prompt');
                    }
                    deferredPrompt = null;
                    hideInstallBanner();
                });
            }
        }
        
        // Dismiss Install Banner
        function dismissInstallBanner() {
            localStorage.setItem('installBannerDismissed', 'true');
            hideInstallBanner();
        }
        
        function hideInstallBanner() {
            const banner = document.getElementById('installBanner');
            if (banner) {
                banner.remove();
            }
        }
        
        // Offline Detection
        function initializeOfflineDetection() {
            window.addEventListener('online', () => {
                isOnline = true;
                hideOfflineIndicator();
                showNotification('Back Online', 'Internet connection restored');
                syncOfflineData();
            });
            
            window.addEventListener('offline', () => {
                isOnline = false;
                showOfflineIndicator();
                showNotification('Offline Mode', 'You are now offline. Some features may be limited.');
            });
            
            // Show initial offline state if needed
            if (!isOnline) {
                showOfflineIndicator();
            }
        }
        
        // Show Offline Indicator
        function showOfflineIndicator() {
            let indicator = document.getElementById('offlineIndicator');
            if (!indicator) {
                indicator = document.createElement('div');
                indicator.id = 'offlineIndicator';
                indicator.className = 'offline-indicator';
                indicator.innerHTML = `
                    <div class="alert alert-warning alert-mobile position-fixed" style="top: 80px; left: 15px; right: 15px; z-index: 9998;">
                        <i class="bi bi-wifi-off me-2"></i>
                        <strong>Offline Mode</strong> - Limited functionality available
                    </div>
                `;
                document.body.appendChild(indicator);
            }
        }
        
        function hideOfflineIndicator() {
            const indicator = document.getElementById('offlineIndicator');
            if (indicator) {
                indicator.remove();
            }
        }
        
        // Push Notifications
        async function initializePushNotifications() {
            if (Notification.permission === 'default') {
                // Ask for permission after user interaction
                setTimeout(() => {
                    requestNotificationPermission();
                }, 5000);
            }
        }
        
        async function requestNotificationPermission() {
            try {
                const permission = await Notification.requestPermission();
                if (permission === 'granted') {
                    console.log('Notification permission granted');
                    subscribeToNotifications();
                }
            } catch (error) {
                console.error('Error requesting notification permission:', error);
            }
        }
        
        async function subscribeToNotifications() {
            if (swRegistration) {
                try {
                    const subscription = await swRegistration.pushManager.subscribe({
                        userVisibleOnly: true,
                        applicationServerKey: urlBase64ToUint8Array('your-vapid-public-key-here')
                    });
                    
                    // Send subscription to server
                    console.log('Push subscription:', subscription);
                } catch (error) {
                    console.error('Error subscribing to push notifications:', error);
                }
            }
        }
        
        // Utility Functions
        function urlBase64ToUint8Array(base64String) {
            const padding = '='.repeat((4 - base64String.length % 4) % 4);
            const base64 = (base64String + padding).replace(/-/g, '+').replace(/_/g, '/');
            const rawData = window.atob(base64);
            const outputArray = new Uint8Array(rawData.length);
            for (let i = 0; i < rawData.length; ++i) {
                outputArray[i] = rawData.charCodeAt(i);
            }
            return outputArray;
        }
        
        // App Updates
        function handleAppUpdates() {
            if ('serviceWorker' in navigator) {
                navigator.serviceWorker.addEventListener('controllerchange', () => {
                    window.location.reload();
                });
            }
        }
        
        function showUpdateAvailable() {
            const updateBanner = document.createElement('div');
            updateBanner.innerHTML = `
                <div class="alert alert-success alert-mobile position-fixed" style="bottom: 100px; left: 15px; right: 15px; z-index: 9999;">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <i class="bi bi-arrow-clockwise me-2"></i>
                            <strong>Update Available</strong>
                            <br><small>A new version is ready to install</small>
                        </div>
                        <button class="btn btn-sm btn-success" onclick="updateApp()">Update</button>
                    </div>
                </div>
            `;
            document.body.appendChild(updateBanner);
        }
        
        function updateApp() {
            if (swRegistration && swRegistration.waiting) {
                swRegistration.waiting.postMessage({ type: 'SKIP_WAITING' });
            }
        }
        
        // Offline Data Sync
        function syncOfflineData() {
            // Sync any offline data when back online
            if ('serviceWorker' in navigator && 'sync' in window.ServiceWorkerRegistration.prototype) {
                navigator.serviceWorker.ready.then(registration => {
                    return registration.sync.register('background-sync');
                });
            }
        }
        
        // Show Notification
        function showNotification(title, body, options = {}) {
            if (Notification.permission === 'granted') {
                const notification = new Notification(title, {
                    body: body,
                    icon: '/favicon.ico',
                    badge: '/favicon.ico',
                    tag: 'tcs-courier',
                    ...options
                });
                
                setTimeout(() => {
                    notification.close();
                }, 5000);
            }
        }
        
        // Loading Functions
        function showLoading() {
            document.getElementById('mobileLoading').style.display = 'flex';
        }
        
        function hideLoading() {
            document.getElementById('mobileLoading').style.display = 'none';
        }
        
        // Prevent zoom on double tap
        let lastTouchEnd = 0;
        document.addEventListener('touchend', function (event) {
            const now = (new Date()).getTime();
            if (now - lastTouchEnd <= 300) {
                event.preventDefault();
            }
            lastTouchEnd = now;
        }, false);
        
        // Language Switching Functions
        function toggleLanguageDropdown() {
            const dropdown = document.getElementById('languageDropdown');
            dropdown.classList.toggle('show');
        }
        
        function changeLanguage(lang, event) {
             if (event) {
                 event.preventDefault();
             }
             
             showLoading();
             
             // Create form to submit language change
             const form = document.createElement('form');
             form.method = 'POST';
             form.action = '<?php echo e(route("language.switch")); ?>';
             form.style.display = 'none';
             
             // Add CSRF token
             const csrfToken = document.createElement('input');
             csrfToken.type = 'hidden';
             csrfToken.name = '_token';
             csrfToken.value = '<?php echo e(csrf_token()); ?>';
             form.appendChild(csrfToken);
             
             // Add language input
             const langInput = document.createElement('input');
             langInput.type = 'hidden';
             langInput.name = 'language';
             langInput.value = lang;
             form.appendChild(langInput);
             
             // Submit form
             document.body.appendChild(form);
             form.submit();
         }
        
        // Close language dropdown when clicking outside
        document.addEventListener('click', function(event) {
            const languageSwitcher = document.querySelector('.language-switcher');
            const dropdown = document.getElementById('languageDropdown');
            
            if (languageSwitcher && !languageSwitcher.contains(event.target)) {
                dropdown.classList.remove('show');
            }
        });
        
        // Performance Monitoring
        window.addEventListener('load', () => {
            if ('performance' in window) {
                const perfData = performance.getEntriesByType('navigation')[0];
                console.log('Page load time:', perfData.loadEventEnd - perfData.loadEventStart, 'ms');
            }
        });
    </script>
    
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH C:\Users\ASC\Desktop\Trae Projects\TCS Web app\resources\views/layouts/mobile.blade.php ENDPATH**/ ?>