<?php $__env->startSection('title', 'Order Confirmation'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <!-- Success Header -->
            <div class="text-center mb-5">
                <div class="mb-4">
                    <i class="bi bi-check-circle-fill text-success" style="font-size: 4rem;"></i>
                </div>
                <h1 class="display-5 fw-bold text-success mb-3">Order Confirmed!</h1>
                <p class="lead text-muted">Your courier booking has been successfully placed and is being processed.</p>
            </div>
            
            <!-- Order Summary Card -->
            <div class="card shadow-lg mb-4">
                <div class="card-header bg-success text-white">
                    <div class="row align-items-center">
                        <div class="col">
                            <h4 class="mb-0">
                                <i class="bi bi-box-seam"></i> Order Summary
                            </h4>
                        </div>
                        <div class="col-auto">
                            <span class="badge bg-light text-dark fs-6">
                                <?php echo e($order->tracking_code); ?>

                            </span>
                        </div>
                    </div>
                </div>
                <div class="card-body p-4">
                    <!-- Delivery Route -->
                    <div class="row align-items-center mb-4">
                        <div class="col-md-5 text-center">
                            <div class="p-3 bg-light rounded">
                                <i class="bi bi-geo-alt-fill text-primary fs-2 mb-2"></i>
                                <h6 class="mb-1">Pickup Location</h6>
                                <p class="mb-1 fw-bold"><?php echo e($order->pickupDistrict->name); ?></p>
                                <small class="text-muted"><?php echo e($order->pickupDistrict->province); ?></small>
                            </div>
                        </div>
                        <div class="col-md-2 text-center">
                            <i class="bi bi-arrow-right text-primary" style="font-size: 2rem;"></i>
                        </div>
                        <div class="col-md-5 text-center">
                            <div class="p-3 bg-light rounded">
                                <i class="bi bi-geo-alt-fill text-success fs-2 mb-2"></i>
                                <h6 class="mb-1">Drop Location</h6>
                                <p class="mb-1 fw-bold"><?php echo e($order->dropDistrict->name); ?></p>
                                <small class="text-muted"><?php echo e($order->dropDistrict->province); ?></small>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Package & Delivery Details -->
                    <div class="row g-4 mb-4">
                        <div class="col-md-6">
                            <h6 class="text-primary mb-3">Package Details</h6>
                            <div class="row g-2">
                                <div class="col-6">
                                    <div class="text-center p-2 bg-light rounded">
                                        <i class="bi bi-speedometer2 text-primary d-block mb-1"></i>
                                        <small class="text-muted">Weight</small>
                                        <div class="fw-bold"><?php echo e($order->weight); ?>kg</div>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="text-center p-2 bg-light rounded">
                                        <i class="bi bi-arrows-fullscreen text-info d-block mb-1"></i>
                                        <small class="text-muted">Size</small>
                                        <div class="fw-bold"><?php echo e($order->size); ?></div>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="text-center p-2 bg-light rounded">
                                        <i class="bi bi-tag text-warning d-block mb-1"></i>
                                        <small class="text-muted">Category</small>
                                        <div class="fw-bold"><?php echo e($order->category); ?></div>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="text-center p-2 bg-light rounded">
                                        <i class="bi bi-truck text-success d-block mb-1"></i>
                                        <small class="text-muted">Vehicle</small>
                                        <div class="fw-bold"><?php echo e(ucfirst($order->vehicle_type)); ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <h6 class="text-success mb-3">Delivery Information</h6>
                            <div class="p-3 bg-light rounded">
                                <div class="d-flex justify-content-between mb-2">
                                    <span>Delivery Type:</span>
                                    <span class="fw-bold"><?php echo e(ucfirst(str_replace('_', ' ', $order->delivery_type))); ?></span>
                                </div>
                                <div class="d-flex justify-content-between mb-2">
                                    <span>Payment Method:</span>
                                    <span class="fw-bold"><?php echo e($order->payment_method === 'cod' ? 'Cash on Delivery' : ucfirst($order->payment_method)); ?></span>
                                </div>
                                <div class="d-flex justify-content-between mb-2">
                                    <span>Payment Status:</span>
                                    <span class="badge bg-<?php echo e($order->payment_status === 'paid' ? 'success' : 'warning'); ?>">
                                        <?php echo e(ucfirst($order->payment_status)); ?>

                                    </span>
                                </div>
                                <hr>
                                <div class="d-flex justify-content-between">
                                    <span class="fw-bold">Total Amount:</span>
                                    <span class="fw-bold text-success fs-5">PKR <?php echo e(number_format($order->final_price, 2)); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Contact Information -->
                    <div class="row g-4">
                        <div class="col-md-6">
                            <h6 class="text-info mb-3">Sender Information</h6>
                            <div class="p-3 bg-light rounded">
                                <p class="mb-2"><strong><?php echo e($order->sender_name); ?></strong></p>
                                <p class="mb-2">
                                    <i class="bi bi-telephone text-primary"></i> 
                                    <a href="tel:<?php echo e($order->sender_phone); ?>" class="text-decoration-none"><?php echo e($order->sender_phone); ?></a>
                                </p>
                                <p class="mb-0">
                                    <i class="bi bi-geo-alt text-primary"></i> 
                                    <?php echo e($order->sender_address); ?>

                                </p>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <h6 class="text-warning mb-3">Receiver Information</h6>
                            <div class="p-3 bg-light rounded">
                                <p class="mb-2"><strong><?php echo e($order->receiver_name); ?></strong></p>
                                <p class="mb-2">
                                    <i class="bi bi-telephone text-success"></i> 
                                    <a href="tel:<?php echo e($order->receiver_phone); ?>" class="text-decoration-none"><?php echo e($order->receiver_phone); ?></a>
                                </p>
                                <p class="mb-0">
                                    <i class="bi bi-geo-alt text-success"></i> 
                                    <?php echo e($order->receiver_address); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                    
                    <?php if($order->assignedOffice): ?>
                        <div class="mt-4 p-3 bg-info bg-opacity-10 rounded">
                            <h6 class="text-info mb-2">
                                <i class="bi bi-building"></i> Assigned Office
                            </h6>
                            <p class="mb-1 fw-bold"><?php echo e($order->assignedOffice->name); ?></p>
                            <p class="mb-1"><?php echo e($order->assignedOffice->address); ?></p>
                            <small class="text-muted">
                                <i class="bi bi-telephone"></i> <?php echo e($order->assignedOffice->phone); ?>

                            </small>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <!-- Next Steps -->
            <div class="card shadow mb-4">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-list-check"></i> What Happens Next?</h5>
                </div>
                <div class="card-body">
                    <div class="row g-4">
                        <div class="col-md-4 text-center">
                            <div class="mb-3">
                                <i class="bi bi-1-circle-fill text-primary" style="font-size: 2.5rem;"></i>
                            </div>
                            <h6>Order Processing</h6>
                            <p class="small text-muted">Your order is being processed and will be assigned to our nearest courier agent.</p>
                        </div>
                        <div class="col-md-4 text-center">
                            <div class="mb-3">
                                <i class="bi bi-2-circle-fill text-warning" style="font-size: 2.5rem;"></i>
                            </div>
                            <h6>Package Pickup</h6>
                            <p class="small text-muted">Our agent will contact you and pickup the package from your specified location.</p>
                        </div>
                        <div class="col-md-4 text-center">
                            <div class="mb-3">
                                <i class="bi bi-3-circle-fill text-success" style="font-size: 2.5rem;"></i>
                            </div>
                            <h6>Delivery</h6>
                            <p class="small text-muted">Your package will be delivered to the receiver with real-time tracking updates.</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Important Information -->
            <div class="alert alert-info" role="alert">
                <h6 class="alert-heading">
                    <i class="bi bi-info-circle"></i> Important Information
                </h6>
                <ul class="mb-0">
                    <li>You will receive SMS and email notifications for status updates</li>
                    <li>Our agent will contact you before pickup</li>
                    <li>Keep your tracking code <strong><?php echo e($order->tracking_code); ?></strong> for reference</li>
                    <?php if($order->payment_method === 'cod'): ?>
                        <li>Payment will be collected from the receiver upon delivery</li>
                    <?php endif; ?>
                    <li>For any queries, contact our customer support</li>
                </ul>
            </div>
            
            <!-- Action Buttons -->
            <div class="text-center">
                <div class="d-flex flex-wrap gap-3 justify-content-center">
                    <a href="<?php echo e(route('orders.show', $order)); ?>" class="btn btn-primary btn-lg">
                        <i class="bi bi-eye"></i> View Full Details
                    </a>
                    <a href="<?php echo e(route('tracking.search')); ?>" 
                       onclick="event.preventDefault(); document.getElementById('track-form').submit();" 
                       class="btn btn-success btn-lg">
                        <i class="bi bi-search"></i> Track Order
                    </a>
                    <form id="track-form" action="<?php echo e(route('tracking.search')); ?>" method="POST" style="display: none;">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="tracking_code" value="<?php echo e($order->tracking_code); ?>">
                    </form>
                    <a href="<?php echo e(route('courier.create')); ?>" class="btn btn-outline-primary btn-lg">
                        <i class="bi bi-plus-circle"></i> Book Another Order
                    </a>
                </div>
            </div>
            
            <!-- Contact Support -->
            <div class="text-center mt-4">
                <p class="text-muted">
                    Need help? Contact our support team at 
                    <a href="tel:+92-300-1234567" class="text-decoration-none">+92-300-1234567</a> or 
                    <a href="mailto:support@tcscourier.com" class="text-decoration-none">support@tcscourier.com</a>
                </p>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .card {
        transition: transform 0.2s ease-in-out;
    }
    .card:hover {
        transform: translateY(-2px);
    }
    .alert {
        border-left: 4px solid #0dcaf0;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Auto-scroll to top on page load
    window.addEventListener('load', function() {
        window.scrollTo(0, 0);
    });
    
    // Copy tracking code to clipboard
    function copyTrackingCode() {
        const trackingCode = '<?php echo e($order->tracking_code); ?>';
        navigator.clipboard.writeText(trackingCode).then(function() {
            // Show success message
            const toast = document.createElement('div');
            toast.className = 'alert alert-success position-fixed top-0 start-50 translate-middle-x mt-3';
            toast.style.zIndex = '9999';
            toast.innerHTML = '<i class="bi bi-check-circle"></i> Tracking code copied to clipboard!';
            document.body.appendChild(toast);
            
            setTimeout(() => {
                toast.remove();
            }, 3000);
        });
    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/khanozai/portal.topcourierservice.com.pk/resources/views/courier/confirmation.blade.php ENDPATH**/ ?>