<?php $__env->startSection('title', 'Register'); ?>

<?php $__env->startSection('content'); ?>
<!-- Registration Form -->
<div class="mobile-card">
    <div class="mobile-card-header text-center">
        <h2 class="mb-2">
            <i class="bi bi-person-plus me-2"></i>
            <?php echo e(__('mobile.create_account_title')); ?>

        </h2>
        <p class="mb-0 opacity-75"><?php echo e(__('mobile.join_tcs_courier')); ?></p>
    </div>
    <div class="mobile-card-body">
        <?php if($errors->any()): ?>
            <div class="alert alert-danger alert-mobile">
                <i class="bi bi-exclamation-triangle me-2"></i>
                <strong>Registration Failed!</strong>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <br><?php echo e($error); ?>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
        
        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-mobile">
                <i class="bi bi-exclamation-triangle me-2"></i>
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>
        
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-mobile">
                <i class="bi bi-check-circle me-2"></i>
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>
        
        <form method="POST" action="<?php echo e(route('register')); ?>">
            <?php echo csrf_field(); ?>
            
            <!-- Full Name -->
            <div class="mb-4">
                <label for="name" class="form-label fw-bold">
                    <i class="bi bi-person me-2 text-primary"></i>Full Name
                </label>
                <input type="text" class="form-control form-control-mobile <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                       id="name" name="name" value="<?php echo e(old('name')); ?>" 
                       placeholder="Enter your full name" required autofocus>
                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            
            <!-- Email -->
            <div class="mb-4">
                <label for="email" class="form-label fw-bold">
                    <i class="bi bi-envelope me-2 text-primary"></i>Email Address
                </label>
                <input type="email" class="form-control form-control-mobile <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                       id="email" name="email" value="<?php echo e(old('email')); ?>" 
                       placeholder="Enter your email address" required>
                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            
            <!-- Phone Number -->
            <div class="mb-4">
                <label for="phone" class="form-label fw-bold">
                    <i class="bi bi-telephone me-2 text-success"></i>Phone Number
                </label>
                <input type="tel" class="form-control form-control-mobile <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                       id="phone" name="phone" value="<?php echo e(old('phone')); ?>" 
                       placeholder="+92-300-1234567" required>
                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <small class="form-text text-muted">
                    <i class="bi bi-info-circle me-1"></i>
                    We'll use this for order notifications
                </small>
            </div>
            
            <!-- Password -->
            <div class="mb-4">
                <label for="password" class="form-label fw-bold">
                    <i class="bi bi-lock me-2 text-primary"></i>Password
                </label>
                <div class="input-group">
                    <input type="password" class="form-control form-control-mobile <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                           id="password" name="password" placeholder="Create a strong password" required>
                    <button class="btn btn-outline-secondary" type="button" id="togglePassword">
                        <i class="bi bi-eye" id="toggleIcon"></i>
                    </button>
                </div>
                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <small class="form-text text-muted">
                    <i class="bi bi-shield-check me-1"></i>
                    Minimum 8 characters with letters and numbers
                </small>
            </div>
            
            <!-- Confirm Password -->
            <div class="mb-4">
                <label for="password_confirmation" class="form-label fw-bold">
                    <i class="bi bi-lock-fill me-2 text-primary"></i>Confirm Password
                </label>
                <div class="input-group">
                    <input type="password" class="form-control form-control-mobile" 
                           id="password_confirmation" name="password_confirmation" 
                           placeholder="Confirm your password" required>
                    <button class="btn btn-outline-secondary" type="button" id="toggleConfirmPassword">
                        <i class="bi bi-eye" id="toggleConfirmIcon"></i>
                    </button>
                </div>
            </div>
            
            <!-- Terms and Conditions -->
            <div class="mb-4">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="terms" name="terms" required>
                    <label class="form-check-label" for="terms">
                        I agree to the <a href="#" class="text-primary">Terms of Service</a> and <a href="#" class="text-primary">Privacy Policy</a>
                    </label>
                </div>
            </div>
            
            <!-- Marketing Consent -->
            <div class="mb-4">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="marketing" name="marketing">
                    <label class="form-check-label" for="marketing">
                        Send me promotional offers and updates via SMS/Email
                    </label>
                </div>
            </div>
            
            <!-- Submit Button -->
            <div class="d-grid mb-4">
                <button type="submit" class="btn btn-mobile btn-mobile-primary">
                    <i class="bi bi-person-plus me-2"></i>
                    Create My Account
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Social Registration -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <div class="text-center mb-4">
            <p class="text-muted mb-3">Or sign up with</p>
        </div>
        
        <div class="row g-3 mb-4">
            <div class="col-6">
                <a href="#" class="btn btn-mobile btn-mobile-danger w-100" onclick="alert('Google registration coming soon!')">
                    <i class="bi bi-google me-2"></i>
                    Google
                </a>
            </div>
            <div class="col-6">
                <a href="#" class="btn btn-mobile btn-mobile-primary w-100" onclick="alert('Facebook registration coming soon!')">
                    <i class="bi bi-facebook me-2"></i>
                    Facebook
                </a>
            </div>
        </div>
        
        <!-- Phone Registration -->
        <div class="d-grid mb-4">
            <a href="#" class="btn btn-mobile btn-mobile-success" onclick="alert('Phone registration coming soon!')">
                <i class="bi bi-phone me-2"></i>
                Register with Phone Number
            </a>
        </div>
    </div>
</div>

<!-- Login Link -->
<div class="mobile-card">
    <div class="mobile-card-body text-center">
        <p class="text-muted mb-3">Already have an account?</p>
        <a href="<?php echo e(route('login')); ?>" class="btn btn-mobile btn-mobile-warning w-100">
            <i class="bi bi-box-arrow-in-right me-2"></i>
            Sign In to Existing Account
        </a>
    </div>
</div>

<!-- Benefits Section -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <h6 class="mb-4 text-center">
            <i class="bi bi-star text-warning me-2"></i>
            Why Join TCS Courier?
        </h6>
        
        <div class="row g-3">
            <div class="col-12">
                <div class="d-flex align-items-center p-2">
                    <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                        <i class="bi bi-lightning-charge"></i>
                    </div>
                    <div>
                        <h6 class="mb-0 small">Fast Delivery</h6>
                        <small class="text-muted">Same day & next day options</small>
                    </div>
                </div>
            </div>
            <div class="col-12">
                <div class="d-flex align-items-center p-2">
                    <div class="bg-success text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                        <i class="bi bi-shield-check"></i>
                    </div>
                    <div>
                        <h6 class="mb-0 small">Secure & Insured</h6>
                        <small class="text-muted">Your packages are protected</small>
                    </div>
                </div>
            </div>
            <div class="col-12">
                <div class="d-flex align-items-center p-2">
                    <div class="bg-info text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                        <i class="bi bi-geo-alt"></i>
                    </div>
                    <div>
                        <h6 class="mb-0 small">Real-time Tracking</h6>
                        <small class="text-muted">Track every step of delivery</small>
                    </div>
                </div>
            </div>
            <div class="col-12">
                <div class="d-flex align-items-center p-2">
                    <div class="bg-warning text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                        <i class="bi bi-credit-card"></i>
                    </div>
                    <div>
                        <h6 class="mb-0 small">Flexible Payment</h6>
                        <small class="text-muted">COD, JazzCash, EasyPaisa</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Quick Access -->
<div class="mobile-card">
    <div class="mobile-card-body">
        <h6 class="mb-3 text-center">
            <i class="bi bi-lightning-charge text-warning me-2"></i>
            Quick Access (No Registration Required)
        </h6>
        <div class="row g-2">
            <div class="col-6">
                <a href="<?php echo e(route('tracking')); ?>" class="btn btn-outline-info w-100 btn-sm">
                    <i class="bi bi-search"></i>
                    <br>
                    <small>Track Package</small>
                </a>
            </div>
            <div class="col-6">
                <a href="<?php echo e(route('home')); ?>" class="btn btn-outline-secondary w-100 btn-sm">
                    <i class="bi bi-house"></i>
                    <br>
                    <small>Back to Home</small>
                </a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Toggle password visibility
    document.getElementById('togglePassword').addEventListener('click', function() {
        const passwordField = document.getElementById('password');
        const toggleIcon = document.getElementById('toggleIcon');
        
        if (passwordField.type === 'password') {
            passwordField.type = 'text';
            toggleIcon.className = 'bi bi-eye-slash';
        } else {
            passwordField.type = 'password';
            toggleIcon.className = 'bi bi-eye';
        }
    });
    
    // Toggle confirm password visibility
    document.getElementById('toggleConfirmPassword').addEventListener('click', function() {
        const confirmField = document.getElementById('password_confirmation');
        const toggleIcon = document.getElementById('toggleConfirmIcon');
        
        if (confirmField.type === 'password') {
            confirmField.type = 'text';
            toggleIcon.className = 'bi bi-eye-slash';
        } else {
            confirmField.type = 'password';
            toggleIcon.className = 'bi bi-eye';
        }
    });
    
    // Auto-format phone number
    document.getElementById('phone').addEventListener('input', function(e) {
        let value = e.target.value.replace(/\D/g, '');
        if (value.length > 0) {
            if (value.startsWith('92')) {
                value = '+' + value;
            } else if (!value.startsWith('+92')) {
                value = '+92' + value;
            }
        }
        e.target.value = value;
    });
    
    // Password confirmation validation
    document.getElementById('password_confirmation').addEventListener('input', function() {
        const password = document.getElementById('password').value;
        const confirmation = this.value;
        
        if (password !== confirmation) {
            this.setCustomValidity('Passwords do not match');
            this.classList.add('is-invalid');
        } else {
            this.setCustomValidity('');
            this.classList.remove('is-invalid');
            this.classList.add('is-valid');
        }
    });
    
    // Form validation and loading state
    document.querySelector('form').addEventListener('submit', function(e) {
        const name = document.getElementById('name').value;
        const email = document.getElementById('email').value;
        const phone = document.getElementById('phone').value;
        const password = document.getElementById('password').value;
        const confirmation = document.getElementById('password_confirmation').value;
        const terms = document.getElementById('terms').checked;
        
        if (!name || !email || !phone || !password || !confirmation || !terms) {
            e.preventDefault();
            
            const alertDiv = document.createElement('div');
            alertDiv.className = 'alert alert-warning alert-mobile';
            alertDiv.innerHTML = '<i class="bi bi-exclamation-triangle me-2"></i>Please fill in all required fields and accept the terms.';
            
            const form = document.querySelector('form');
            form.insertBefore(alertDiv, form.firstChild);
            
            setTimeout(() => {
                alertDiv.remove();
            }, 3000);
            
            return;
        }
        
        if (password !== confirmation) {
            e.preventDefault();
            
            const alertDiv = document.createElement('div');
            alertDiv.className = 'alert alert-warning alert-mobile';
            alertDiv.innerHTML = '<i class="bi bi-exclamation-triangle me-2"></i>Passwords do not match.';
            
            const form = document.querySelector('form');
            form.insertBefore(alertDiv, form.firstChild);
            
            setTimeout(() => {
                alertDiv.remove();
            }, 3000);
            
            return;
        }
        
        // Show loading state
        const submitBtn = document.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        submitBtn.innerHTML = '<i class="bi bi-hourglass-split me-2"></i>Creating Account...';
        submitBtn.disabled = true;
        
        showLoading();
    });
    
    // Auto-focus on name field for desktop, but not mobile to avoid keyboard popup
    document.addEventListener('DOMContentLoaded', function() {
        if (!window.matchMedia('(max-width: 768px)').matches) {
            setTimeout(() => {
                document.getElementById('name').focus();
            }, 500);
        }
    });
    
    // Add haptic feedback for form submission
    document.querySelector('button[type="submit"]').addEventListener('click', function() {
        if ('vibrate' in navigator) {
            navigator.vibrate(100);
        }
    });
    
    // Real-time validation feedback
    document.querySelectorAll('input').forEach(input => {
        input.addEventListener('input', function() {
            if (this.value.trim()) {
                this.classList.remove('is-invalid');
                this.classList.add('is-valid');
            } else {
                this.classList.remove('is-valid');
            }
        });
    });
    
    // Password strength indicator
    document.getElementById('password').addEventListener('input', function() {
        const password = this.value;
        const strength = {
            0: 'Very Weak',
            1: 'Weak', 
            2: 'Fair',
            3: 'Good',
            4: 'Strong'
        };
        
        let score = 0;
        if (password.length >= 8) score++;
        if (password.match(/[a-z]/)) score++;
        if (password.match(/[A-Z]/)) score++;
        if (password.match(/[0-9]/)) score++;
        if (password.match(/[^a-zA-Z0-9]/)) score++;
        
        // Remove existing strength indicator
        const existingIndicator = document.querySelector('.password-strength');
        if (existingIndicator) {
            existingIndicator.remove();
        }
        
        if (password.length > 0) {
            const indicator = document.createElement('small');
            indicator.className = 'password-strength form-text';
            indicator.innerHTML = `<i class="bi bi-shield-${score >= 3 ? 'check text-success' : 'exclamation text-warning'} me-1"></i>Password Strength: ${strength[score]}`;
            
            this.parentNode.parentNode.appendChild(indicator);
        }
    });
    
    // Auto-hide alerts after 5 seconds
    document.querySelectorAll('.alert').forEach(alert => {
        setTimeout(() => {
            alert.style.opacity = '0';
            alert.style.transform = 'translateY(-20px)';
            setTimeout(() => {
                alert.remove();
            }, 300);
        }, 5000);
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.mobile', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/khanozai/portal.topcourierservice.com.pk/resources/views/mobile/auth/register.blade.php ENDPATH**/ ?>